/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.io.DeviceManager;
import galatea.main.Debug;
import galatea.outitem.OutItem;
import java.util.ArrayList;

public class OutQueueManager {
    private Debug dbg = new Debug("OQM", 0);
    private DeviceManager deviceManager;
    private int outputState = 0;
    private int prevOutputCount = 0;
    private OutItem currOutItem = null;
    private ArrayList queue_;
    private boolean currOutItemIsValid_ = false;
    private int outputCount = 0;

    public OutQueueManager(DeviceManager d) {
        this.deviceManager = d;
        this.queue_ = new ArrayList();
    }

    public void doOutput(OutItem item) {
        this.deviceManager.doOutput(item);
    }

    public void doStop(OutItem item) {
        this.deviceManager.doStop(item);
    }

    public synchronized void setCurrOutItemIsValid(boolean b) {
        this.currOutItemIsValid_ = b;
    }

    private void resetOutputCount() {
        this.outputCount = 0;
    }

    public void incrementOutputCount() {
        ++this.outputCount;
    }

    public void decrementOutputCount() {
        --this.outputCount;
    }

    public synchronized void discard() {
        this.queue_.clear();
    }

    public synchronized void enqueue(OutItem o) {
        this.queue_.add(o);
        this.dbg.print("OQM: added " + o.getClass().getName() + ", total:" + this.queue_.size());
    }

    public synchronized OutItem dequeue() {
        if (this.queue_.isEmpty()) {
            return null;
        }
        OutItem ret = (OutItem)this.queue_.remove(0);
        this.dbg.print("OQM: removed " + ret.getClass().getName() + ", total:" + this.queue_.size());
        return ret;
    }

    public synchronized void removeDelayedOutputItems() {
        ArrayList<OutItem> newvec = new ArrayList<OutItem>();
        int i = 0;
        while (i < this.queue_.size()) {
            OutItem o = (OutItem)this.queue_.get(i);
            if (o.isInstant() || o.isImportant()) {
                newvec.add(o);
            }
            ++i;
        }
        this.queue_ = newvec;
    }

    public boolean doOutputIteration() {
        switch (this.getOutputState()) {
            case 0: {
                this.dbg.print("IC: [1] starting output");
                OutItem item = this.dequeue();
                if (item == null) {
                    this.dbg.print("IC: dequeue item is null");
                    return false;
                }
                if (item.isInstant()) {
                    this.dbg.print("IC: output instant: " + item.toString());
                    this.doOutput(item);
                    break;
                }
                this.dbg.print("IC: output non-instant: " + item.toString());
                this.doOutput(item);
                this.setCurrOutItemIsValid(true);
                this.setOutputState(1);
                this.setCurrOutItem(item);
                this.setPrevOutputCount(this.outputCount);
                break;
            }
            case 1: {
                this.dbg.print("IC: [1] waiting for output busy");
                if (!this.currOutItemIsValid_) {
                    this.doStop(this.getCurrOutItem());
                    this.setOutputState(3);
                    break;
                }
                if (this.outputCount != this.getPrevOutputCount() + 1) break;
                this.setOutputState(2);
                break;
            }
            case 2: {
                this.dbg.print("IC: [2] waiting for output ready");
                if (!this.currOutItemIsValid_) {
                    this.doStop(this.getCurrOutItem());
                    this.setOutputState(3);
                    break;
                }
                if (this.outputCount != this.getPrevOutputCount()) break;
                this.setOutputState(0);
                break;
            }
            case 3: {
                this.dbg.print("IC: [3] waiting for output stop done");
                if (this.outputCount != this.getPrevOutputCount()) break;
                this.setOutputState(0);
                break;
            }
        }
        return true;
    }

    public OutItem getCurrOutItem() {
        return this.currOutItem;
    }

    public void setCurrOutItem(OutItem currOutItem) {
        this.currOutItem = currOutItem;
    }

    public int getOutputState() {
        return this.outputState;
    }

    public void setOutputState(int outputState) {
        this.outputState = outputState;
    }

    public int getPrevOutputCount() {
        return this.prevOutputCount;
    }

    public void setPrevOutputCount(int prevOutputCount) {
        this.prevOutputCount = prevOutputCount;
    }
}

