/*
 * Decompiled with CFR 0.152.
 */
package galatea.main;

import galatea.DialogManagerWindow;
import galatea.command.Command;
import galatea.document.ContentState;
import galatea.document.DocError;
import galatea.document.DocLoader;
import galatea.document.StateMap;
import galatea.io.DeviceEvent;
import galatea.io.DeviceListener;
import galatea.io.DeviceManager;
import galatea.io.EventQueueManager;
import galatea.io.OutQueueManager;
import galatea.main.AbstractIC;
import galatea.main.Debug;
import galatea.main.ICEventListener;
import galatea.outitem.OutItem;
import galatea.relaxer.event.EventEv;
import galatea.relaxer.event.EventInterpreted;
import galatea.relaxer.event.IEventEvChoice;
import galatea.scripting.ECMAScript;
import galatea.util.Util;
import java.util.ArrayList;

public class IC
implements AbstractIC,
DeviceListener,
ICEventListener {
    private Debug dbg = new Debug("IC");
    private String nextDocFile_ = "";
    private StateMap stateMap_ = null;
    private ContentState currState_ = null;
    private ArrayList commands_ = null;
    private OutQueueManager oqm_ = null;
    private EventQueueManager inputEventQueueManager_ = null;
    private EventQueueManager outputEventQueueManager_ = null;
    private boolean endFlag_ = false;
    private boolean endImmFlag_ = false;
    private boolean pauseMode_ = false;
    private String currFilePath_ = null;
    private ECMAScript ecmascript_ = null;
    private DeviceManager deviceManager;
    private String nextStateName_ = null;
    private boolean currOutQueueIsValid_ = false;
    private String evalAfterInputHandler_ = null;

    public synchronized void setNextState(String state) {
        this.dbg.print("IC: setNextState: " + state);
        this.nextStateName_ = state;
    }

    private synchronized void _setCurrOutQueueIsValid(boolean b) {
        this.currOutQueueIsValid_ = b;
        this.dbg.print("IC: currOutQueueIsValid: " + b);
    }

    private synchronized void _resetEvalAfterInputHandler() {
        this.evalAfterInputHandler_ = null;
    }

    private synchronized void _appendEvalAfterInputHandler(String s) {
        this.evalAfterInputHandler_ = this.evalAfterInputHandler_ == null ? s : String.valueOf(this.evalAfterInputHandler_) + s;
    }

    private synchronized void _doEvalAfterInputHandler() {
        if (this.evalAfterInputHandler_ != null) {
            this.ecmascript_.evaluate(this.evalAfterInputHandler_);
            this.dbg.print("IC: afterInputHandler: " + this.evalAfterInputHandler_);
        }
    }

    public IC() {
        DialogManagerWindow.doSetICEventListener(this);
        this.ecmascript_ = new ECMAScript();
        this.inputEventQueueManager_ = new EventQueueManager();
        this.outputEventQueueManager_ = new EventQueueManager();
        this.deviceManager = new DeviceManager(this);
        this.oqm_ = new OutQueueManager(this.deviceManager);
        this.commands_ = new ArrayList();
    }

    public void loadDocument(String uri) throws Exception {
        this.setEndFlag(false);
        this.setEndImm(false);
        DialogManagerWindow.doDispLocation(uri);
        DialogManagerWindow.doDispState("[Load] " + uri);
        String path = Util.getUriWithoutFragment(uri);
        String dialog = Util.getUriFragment(uri);
        DocLoader doc = new DocLoader(uri, path, dialog);
        doc.sendSrcToWindow();
        this.stateMap_ = doc.getStateMap();
        this.currState_ = this.stateMap_.getFirstState();
        if (this.currState_ == null) {
            throw new DocError("State not found: " + this.currState_);
        }
        this.currFilePath_ = Util.getFirstGroup("^([^\\?]+).*", path);
        DialogManagerWindow.doDispState(String.valueOf(this.currFilePath_) + " " + this.currState_.getName());
    }

    private void _sleep() {
        try {
            Thread.sleep(0L, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _doEvents() {
        this._resetEvalAfterInputHandler();
        this._sleep();
        this._processOutputEventQueueItem();
        this._processInputEventQueueItem();
        this._doEvalAfterInputHandler();
    }

    private void _iteration() {
        block9: {
            this.dbg.print("IC: iteration start");
            this.commands_.clear();
            this.commands_.addAll(this.currState_.getCommands());
            while (!this.commands_.isEmpty()) {
                Command cmd = (Command)this.commands_.remove(0);
                cmd.setContext(this, this.ecmascript_);
                cmd.execute();
                this.dbg.print("IC: command done: " + cmd.toString(), 2);
            }
            this._setCurrOutQueueIsValid(true);
            do {
                this._doEvents();
                if (!this.currOutQueueIsValid_) {
                    this.dbg.print("IC: currOutQueue not valid.");
                    this.oqm_.removeDelayedOutputItems();
                    break block9;
                }
                if (!this.pauseMode_ && !this.oqm_.doOutputIteration()) break block9;
            } while (!this.endImmFlag_);
            this.oqm_.discard();
            this.dbg.print("IC: discard queue");
            this.currState_ = null;
        }
        this.dbg.print("IC: iteration output done.");
        if (this.endFlag_) {
            this.dbg.print("IC: end");
            this.currState_ = null;
            return;
        }
        if (this.stateMap_ == null) {
            this.dbg.print("IC: stateMap is null");
            return;
        }
        if (this.nextStateName_ == null) {
            this.dbg.print("IC: nextStateName is null");
            try {
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.currState_ = null;
        } else {
            this.dbg.print("IC: from " + this.currState_.getName());
            this.dbg.print("IC: to " + this.nextStateName_);
            this.currState_ = this.stateMap_.get(this.nextStateName_);
            this._doDispState(this.currState_.getName());
            this.setNextState(null);
        }
        this.dbg.print("IC: iteration done.");
    }

    private void _doDispState(String name) {
        DialogManagerWindow.doDispState(String.valueOf(this.currFilePath_) + " " + name);
    }

    public void mainLoop() {
        this.dbg.print("IC: mainLoop start");
        while (this.currState_ != null) {
            this._iteration();
        }
        this.dbg.print("IC: mainLoop end");
    }

    public String getNextDocFile() {
        return this.nextDocFile_;
    }

    public void terminate() {
    }

    private void _gotoDefaultNextState() {
        this._gotoNextStateByText("_");
    }

    private void _gotoNextStateByText(String text) {
        if (this.currState_ == null) {
            return;
        }
        this.dbg.print("IC: gotoNextStateByText(" + text + ") at state:" + this.currState_.getName());
        String next = this.currState_.findEventHandler(text);
        this.dbg.print("IC: inputEvent: next: " + next);
        if (next == null) {
            this.dbg.print("IC: handler not found in " + this.currState_.getName());
            return;
        }
        this.oqm_.setCurrOutItemIsValid(false);
        this._setCurrOutQueueIsValid(false);
        this.setNextState(next);
    }

    private void _repeatCurrState() {
        this.oqm_.setCurrOutItemIsValid(false);
        this._setCurrOutQueueIsValid(false);
        this.setNextState(this.currState_.getName());
    }

    private void _updateInputEvent(DeviceEvent evt) {
        EventEv ev;
        String type = "";
        String src = "";
        String text = "";
        try {
            ev = evt.getEv();
        }
        catch (Exception e) {
            this.dbg.print("IC: getEv() error.");
            return;
        }
        if (ev != null) {
            src = ev.getSrc();
            type = ev.getType();
            if (!type.equals("INPUT") && !type.equals("COMMAND")) {
                this.dbg.print("IC: ignored: " + src + " " + type);
                return;
            }
            IEventEvChoice c = ev.getContent();
            if (c instanceof EventInterpreted) {
                this.dbg.print("IC: EventInterpreted " + evt.toString());
                EventInterpreted ei = (EventInterpreted)c;
                if (ei.getScript() != null) {
                    this._appendEvalAfterInputHandler(ei.getScript());
                }
                if (ei.getText() != null) {
                    text = ei.getText();
                    this._gotoNextStateByText(text);
                } else {
                    this._gotoDefaultNextState();
                }
            }
        }
    }

    public void setNextDocumentICEvent(String uri) {
        if (uri != null && uri.length() > 0) {
            this.dbg.print("IC: setNextDocumentICEvent " + uri);
            this.setNextDocFile(uri);
        }
    }

    public void terminateDialogICEvent() {
        this.dbg.print("IC: terminateDialogICEvent");
        if (this.oqm_ != null) {
            this.oqm_.setCurrOutItemIsValid(false);
        } else {
            System.err.println("Warning: no current outitem.");
        }
        this._setCurrOutQueueIsValid(false);
        this.setNextState(null);
        this.setEndFlag(true);
        this.setEndImm(true);
    }

    public void setPauseModeICEvent(boolean b) {
        this.pauseMode_ = b;
    }

    public boolean getPauseMode() {
        return this.pauseMode_;
    }

    public void quitICEvent() {
        this.dbg.print("IC: quitICEvent");
        this.oqm_.setCurrOutItemIsValid(false);
        this._setCurrOutQueueIsValid(false);
        this.setNextState(null);
        this.setEndFlag(true);
        this.setEndImm(true);
        this.setNextDocFile("");
    }

    public void enqueueOutputEvent(DeviceEvent evt) {
        this.outputEventQueueManager_.enqueue(evt);
    }

    public void enqueueInputEvent(DeviceEvent evt) {
        this.inputEventQueueManager_.enqueue(evt);
    }

    private void _processOutputEventQueueItem() {
        DeviceEvent evt;
        while ((evt = this.outputEventQueueManager_.dequeue()) != null) {
            DeviceEvent.State state = evt.getState();
            if (state == DeviceEvent.State.BUSY) {
                this.dbg.print("IC: " + evt.toString());
                this.oqm_.incrementOutputCount();
                continue;
            }
            if (state != DeviceEvent.State.READY) continue;
            this.dbg.print("IC: " + evt.toString());
            this.oqm_.decrementOutputCount();
        }
    }

    private void _processInputEventQueueItem() {
        DeviceEvent evt;
        while ((evt = this.inputEventQueueManager_.dequeue()) != null) {
            this._updateInputEvent(evt);
        }
    }

    public void enqueueOutItem(OutItem oi) {
        this.dbg.print("IC: enqueueOutput " + oi.toString());
        this.oqm_.enqueue(oi);
    }

    public void insertCommandsTop(ArrayList v) {
        if (this.commands_ == null) {
            return;
        }
        this.commands_.addAll(0, v);
    }

    public void setEndFlag(boolean b) {
        this.dbg.print("IC: setEndFlag: " + b);
        this.endFlag_ = b;
    }

    public void setNextDocFile(String s) {
        this.dbg.print("IC: setNextDocFile:" + s);
        this.nextDocFile_ = s;
    }

    public void gotoState(String state) {
        this.setNextState(state);
        this.commands_.clear();
    }

    public void stopOutput() {
        this.oqm_.setCurrOutItemIsValid(false);
        this._setCurrOutQueueIsValid(false);
    }

    public void setEndImm(boolean b) {
        this.endImmFlag_ = b;
    }
}

