/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import galatea.document.DocError;
import galatea.scripting.Tools;
import galatea.util.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetUtil {
    private NetUtil() {
    }

    public static String getTopName(Element elem) {
        String topName = elem.getNodeType() == 1 ? elem.getNodeName() : "";
        return topName;
    }

    public static Element loadXMLFile(String filename) throws Exception {
        Document root;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (filename.startsWith("http:")) {
            String line;
            String buf = "";
            URL url = new URL(filename);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setUseCaches(false);
            uc.setRequestMethod("GET");
            String encoding = Util.getPropertyStr("NetUtil.HttpEncoding", "Shift_JIS");
            InputStreamReader isr = new InputStreamReader(uc.getInputStream(), encoding);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                buf = String.valueOf(buf) + line;
            }
            root = builder.parse(new ByteArrayInputStream(buf.getBytes(encoding)));
            br.close();
            uc.disconnect();
        } else {
            root = builder.parse(filename);
        }
        Element elem = root.getDocumentElement();
        return elem;
    }

    public static String loadTextFile(String filename) throws Exception {
        String doc = Tools.readURL(filename);
        if (Tools.getError().equals("")) {
            return doc;
        }
        throw new DocError(Tools.getError());
    }
}

