/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import galatea.main.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class SubProcess {
    private Debug dbg = new Debug(8);
    private String module_command;
    private Runtime rt;
    private Process child;
    private InputStream out;
    private InputStream err;
    private OutputStream in;
    private PrintStream stdin;
    private BufferedReader stdout;
    private BufferedReader stderr;
    private boolean running = false;

    public SubProcess() {
    }

    public SubProcess(String com) {
        this();
        this.module_command = com;
    }

    public void SetCommand(String com) {
        this.module_command = com;
    }

    public boolean Run() {
        String[] com = new String[3];
        if (this.module_command.length() == 0) {
            this.dbg.err("SubProcess.Run(): 'module_command' is undefined.");
            return false;
        }
        com[0] = System.getProperty("SubProcess.shell", "/bin/sh");
        com[1] = "-c";
        com[2] = this.module_command;
        this.rt = Runtime.getRuntime();
        try {
            this.child = this.rt.exec(com);
        }
        catch (IOException e) {
            this.dbg.err("SubProcess.Run(): Runtime.exec() failed.");
            return false;
        }
        this.in = this.child.getOutputStream();
        this.out = this.child.getInputStream();
        this.err = this.child.getErrorStream();
        this.stdin = new PrintStream(this.in);
        this.stdout = new BufferedReader(new InputStreamReader(this.out));
        this.stderr = new BufferedReader(new InputStreamReader(this.err));
        this.running = true;
        return true;
    }

    public boolean IsRunning() {
        return this.running;
    }

    public void ToStdin(String str) {
        this.dbg.print("ToStdin: " + str, 9);
        this.stdin.println(str);
        this.stdin.flush();
    }

    public String FromStdout() {
        String s;
        try {
            s = this.stdout.readLine();
            this.dbg.print("FromStdout: " + s, 9);
        }
        catch (IOException e) {
            this.dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.", 8);
            return null;
        }
        return s;
    }

    public String FromStdoutNB() {
        String s;
        try {
            if (this.stdout.ready()) {
                s = this.stdout.readLine();
                this.dbg.print("FromStdoutNB: " + s, 9);
            } else {
                s = "";
            }
        }
        catch (IOException e) {
            this.dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.");
            return null;
        }
        return s;
    }

    public String FromStderr() {
        String s;
        try {
            s = this.stderr.readLine();
        }
        catch (IOException e) {
            this.dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
            return null;
        }
        return s;
    }

    public String FromStderrNB() {
        String s;
        try {
            s = this.stderr.ready() ? this.stderr.readLine() : "";
        }
        catch (IOException e) {
            this.dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
            return null;
        }
        return s;
    }

    public InputStream GetStdout() {
        if (this.running) {
            return this.out;
        }
        return null;
    }

    public InputStream GetStderr() {
        if (this.running) {
            return this.err;
        }
        return null;
    }

    public OutputStream GetStdin() {
        if (this.running) {
            return this.in;
        }
        return null;
    }

    public void waitFor() throws InterruptedException {
        this.child.waitFor();
    }

    public void destroy() {
        this.child.destroy();
    }

    public int exitValue() throws IllegalThreadStateException {
        return this.child.exitValue();
    }
}

