/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    public static int getPropertyInt(String name, int defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return Integer.parseInt(s);
    }

    public static String getPropertyStr(String name, String defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return s;
    }

    public static void halt(String msg) {
        System.err.println(msg);
        while (true) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void runtimeError(String msg) {
        System.err.println(msg);
    }

    public static String removeSpaces(String str) {
        StringBuffer retStr = new StringBuffer("");
        if (str == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(str, " \t\n\r");
        while (st.hasMoreTokens()) {
            retStr.append(st.nextToken());
        }
        if (retStr.length() == 0) {
            return "";
        }
        return retStr.toString();
    }

    public static String xmlSafeRemoveSpaces(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer retStr = new StringBuffer("");
        boolean inTag = false;
        StringTokenizer st = new StringTokenizer(str, " \t\n\r");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("<") && !token.equals("<")) {
                inTag = true;
            }
            if (token.endsWith(">")) {
                inTag = false;
            }
            retStr.append(token);
            if (!inTag) continue;
            retStr.append(" ");
        }
        if (retStr.length() == 0) {
            return "";
        }
        return retStr.toString();
    }

    public static String removeNewLines(String str) {
        StringBuffer retStr = new StringBuffer("");
        if (str == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(str, "\n\r");
        while (st.hasMoreTokens()) {
            retStr.append(st.nextToken());
        }
        if (retStr.length() == 0) {
            return "";
        }
        return retStr.toString();
    }

    public static String encodeXmlChars(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer t = new StringBuffer("");
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '<') {
                t.append("&lt;");
            } else if (ch == '>') {
                t.append("&gt;");
            } else if (ch == '&') {
                t.append("&amp;");
            } else {
                t.append(ch);
            }
            ++i;
        }
        return t.toString();
    }

    public static String decodeXmlChars(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        ret = ret.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("&amp;", "&");
        return ret;
    }

    public static String resolveAdrs(String base, String rel) {
        String s;
        if (base == null || rel == null) {
            return "";
        }
        try {
            URI u1 = new URI(base);
            URI u2 = new URI(rel);
            URI u3 = u1.resolve(u2);
            s = u3.toString();
        }
        catch (URISyntaxException e) {
            s = "_error_resolveAdrs_";
        }
        return s;
    }

    public static String getUriFragment(String uri) {
        String fragment = Util.getFirstGroup("^[^#]+#(.*)$", uri);
        if (fragment == null) {
            return "";
        }
        return fragment;
    }

    public static String getUriWithoutFragment(String uri) {
        String path = Util.getFirstGroup("^([^#]+)#.*$", uri);
        if (path == null) {
            return uri;
        }
        return path;
    }

    public static String getFirstGroup(String pat, String str) {
        Pattern p = Pattern.compile(pat);
        Matcher m = p.matcher(str);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static boolean isSameFile(String f1, String f2) {
        boolean b = false;
        try {
            URI u1 = new URI(f1);
            URI u2 = new URI(f2);
            URI u3 = new URI(u1.getScheme(), u1.getUserInfo(), u1.getHost(), u1.getPort(), u1.getPath(), u1.getQuery(), u2.getFragment());
            if (u2.equals(u3)) {
                b = true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return b;
    }

    public static void writeToFile(String file, String content) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(fos);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(content);
        bw.close();
        osw.close();
        fos.close();
    }

    public static String loadFromFile(String file) throws Exception {
        String line;
        String content = "";
        FileReader fr = new FileReader(file);
        BufferedReader reader = new BufferedReader(fr);
        while ((line = reader.readLine()) != null) {
            content = String.valueOf(content) + line;
            content = String.valueOf(content) + "\n";
        }
        reader.close();
        return content;
    }

    public static List makeTokenizedList(String src, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(src, delim, false);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    public static String removeTags(String str) {
        String s = str.replaceAll("<[^>]*>", "");
        return s;
    }

    public static String getStringHead(String str) {
        if ((str = Util.removeNewLines(str)).length() > 40) {
            str = String.valueOf(str.substring(0, 40)) + "...";
        }
        return str;
    }

    public static void main(String[] args) throws Exception {
        String s = "if (1<=num && 2>nantoka) {infiniteLoop}";
        System.out.println(s);
        s = Util.encodeXmlChars(s);
        System.out.println(s);
        s = Util.decodeXmlChars(s);
        System.out.println(s);
    }
}

