/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

public class Vector3D {
    public double x;
    public double y;
    public double z;
    private double xMin_;
    private double yMin_;
    private double zMin_;
    private double xMax_;
    private double yMax_;
    private double zMax_;
    private static double SMALL_VALUE = 0.02;

    public Vector3D(double d1, double d2, double d3) {
        this.x = d1;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D set(double d1, double d2, double d3) {
        this.x = d1;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3D set(Vector3D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public Vector3D add(Vector3D v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector3D setLimitter(double d1, double d2, double d3) {
        this.xMin_ = -d1;
        this.yMin_ = -d2;
        this.zMin_ = -d3;
        this.xMax_ = d1;
        this.yMax_ = d2;
        this.zMax_ = d3;
        return this;
    }

    public Vector3D applyLimitter() {
        if (this.x < this.xMin_) {
            this.x = this.xMin_;
        }
        if (this.y < this.yMin_) {
            this.y = this.yMin_;
        }
        if (this.z < this.zMin_) {
            this.z = this.zMin_;
        }
        if (this.x > this.xMax_) {
            this.x = this.xMax_;
        }
        if (this.y > this.yMax_) {
            this.y = this.yMax_;
        }
        if (this.z > this.zMax_) {
            this.z = this.zMax_;
        }
        return this;
    }

    public boolean equals(Vector3D v) {
        if (v == null) {
            return false;
        }
        return Math.abs(this.x - v.x) < SMALL_VALUE && Math.abs(this.y - v.y) < SMALL_VALUE && Math.abs(this.z - v.z) < SMALL_VALUE;
    }
}

