/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Rule
implements Serializable,
Cloneable {
    private String id_;
    private Lhs lhs_;
    private Rhs rhs_;

    public Rule() {
        this.id_ = "";
    }

    public Rule(Rule rule) {
        this.setup(rule);
    }

    public Rule(RStack rStack) {
        this.setup(rStack);
    }

    public Rule(Document document) {
        this.setup(document.getDocumentElement());
    }

    public Rule(Element element) {
        this.setup(element);
    }

    public Rule(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Rule(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public Rule(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public Rule(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public Rule(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public Rule(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Rule rule) {
        this.setId(rule.getId());
        this.setLhs(rule.getLhs());
        this.setRhs(rule.getRhs());
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        if (Lhs.isMatch(rStack)) {
            this.setLhs(new Lhs(rStack));
        }
        if (Rhs.isMatch(rStack)) {
            this.setRhs(new Rhs(rStack));
        }
    }

    public Object clone() {
        return new Rule(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("rule");
        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }
        if (this.lhs_ != null) {
            this.lhs_.makeElement(element);
        }
        if (this.rhs_ != null) {
            this.rhs_.makeElement(element);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 0));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 0));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 0));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String string) {
        this.id_ = string;
    }

    public final Lhs getLhs() {
        return this.lhs_;
    }

    public final void setLhs(Lhs lhs) {
        this.lhs_ = lhs;
    }

    public final Rhs getRhs() {
        return this.rhs_;
    }

    public final void setRhs(Rhs rhs) {
        this.rhs_ = rhs;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<rule");
        if (this.id_ != null) {
            stringBuffer.append(" id=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        if (this.lhs_ != null) {
            this.lhs_.makeTextElement(stringBuffer);
        }
        if (this.rhs_ != null) {
            this.rhs_.makeTextElement(stringBuffer);
        }
        stringBuffer.append("</rule>");
    }

    public void makeTextElement(Writer writer) throws IOException {
        writer.write("<rule");
        if (this.id_ != null) {
            writer.write(" id=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            writer.write("\"");
        }
        writer.write(">");
        if (this.lhs_ != null) {
            this.lhs_.makeTextElement(writer);
        }
        if (this.rhs_ != null) {
            this.rhs_.makeTextElement(writer);
        }
        writer.write("</rule>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<rule");
        if (this.id_ != null) {
            printWriter.print(" id=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            printWriter.print("\"");
        }
        printWriter.print(">");
        if (this.lhs_ != null) {
            this.lhs_.makeTextElement(printWriter);
        }
        if (this.rhs_ != null) {
            this.rhs_.makeTextElement(printWriter);
        }
        printWriter.print("</rule>");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "rule")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        if (!Lhs.isMatchHungry(rStack)) {
            return false;
        }
        bl = true;
        if (!Rhs.isMatchHungry(rStack)) {
            return false;
        }
        bl = true;
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return Rule.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (Rule.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

