#!/usr/bin/ruby -Ke -vw
# $Id: AM-MCL.rb,v 1.43 2004/07/15 04:00:50 nishi Exp $
#
# by Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)

# ------------------------------

require 'GalateaBase.rb'
require 'Agent.rb'
require 'thread'

class AM_MCL < GalateaBase

  def initialize
    super
    @modulename = "AM-MCL"
    @debug = false

    @useEventViewer = 0

    #
    # sequence for Speak
    # state0 : IDLE
    # state1 : wait FSM/SSM "rep Speak.stat = READY"
    # state2 : wait FSM/SSM "rep Speak.stat = IDLE"
    #
    # sequence for MouthMove
    # state0 : IDLE
    # state3 : wait FSM     "rep Speak.stat = READY"
    # state4 : wait FSM     "rep Speak.stat = IDLE"
    #
    @state = 0

    @ready_ssm = false
    @ready_fsm = false

    # @fsm_wait_time = 0
    # @ssm_wait_time = 0

    @auto_emotion_speak = 0

    print_debug "initializing..."

    @agents = {}

    @agents["man01"]   = Agent.new('man01',   'male01')
    @agents["man02"]   = Agent.new('man02',   'm001')
    @agents["woman01"] = Agent.new('woman01', 'female01')
    @agents["koizumi"] = Agent.new('koizumi', 'male01')

    @curr_agent = "man01"

  end

  attr_accessor :state, :ready_ssm, :ready_fsm, :agents, :curr_agent, :auto_emotion_speak


  def sendAgentSpeakState
    if @useEventViewer == 1
      send_set( "DIM.GEV.FS-MCL", "AgentSpeakState", self.state )
    else 
      send_set( "DIM.FS-MCL", "AgentSpeakState", self.state )
    end
  end


  def curr_mouth_scale
    self.agents[self.curr_agent].mouth_scale
  end


  def curr_output_text(arg)
    if self.auto_emotion_speak == 1
      print_debug "open_tag : #{self.agents[self.curr_agent].open_tag}"
      print_debug "close_tag: #{self.agents[self.curr_agent].close_tag}"
      return "#{self.agents[self.curr_agent].open_tag}#{arg}#{self.agents[self.curr_agent].close_tag}"
    else
      return arg
    end
  end


  def do_set_speak(arg)
    if arg == "STOP"
      self.state = 0
      sendAgentSpeakState
      print_out "to \@FSM set Speak = STOP"
      print_out "to \@SSM set Speak = STOP"
      self.ready_ssm = false
      self.ready_fsm = false
      print_debug "state: #{self.state}"
      
    else
      # if speaking, stop automatically
      if self.state != 0
	print_out "to \@FSM set Speak = STOP"
	print_out "to \@SSM set Speak = STOP"
      end

      self.state = 1
      sendAgentSpeakState
      print_out "to \@FSM set MouthScale = #{curr_mouth_scale}"
      print_out "to \@FSM prop Speak.stat = AutoOutput"
      print_out "to \@SSM prop Speak.stat = AutoOutput"
      print_out "to \@SSM prop Speak.pho = AutoOutput"
      print_out "to \@SSM set Text = #{curr_output_text(arg)}"
      self.ready_ssm = false
      self.ready_fsm = false
      print_debug "state: #{self.state}"
    end
  end


  def do_set_move_mouth(arg)
    case arg
    when "STOP"
      self.state = 0
      sendAgentSpeakState
      print_out "to \@SSM set Speak = STOP"
      self.ready_ssm = false
      self.ready_fsm = false
      print_debug "state: #{self.state}"
    when /scale\s+(\S+)\s+(.*)/
      self.state = 3
      sendAgentSpeakState
#      print_out "to \@FSM prop Speak.stat = AutoOutput"
      print_out "to \@FSM set MouthScale = #{$1}"
      print_out "to \@FSM set LipSync.pho = #{$2}"
      self.ready_fsm = false
      print_debug "state: #{self.state}"
    else
      self.state = 3
      sendAgentSpeakState
#      print_out "to \@FSM prop Speak.stat = AutoOutput"
      print_out "to \@FSM set MouthScale = #{curr_mouth_scale}"
      print_out "to \@FSM set LipSync.pho = #{arg}"
      self.ready_fsm = false
      print_debug "state: #{self.state}"
    end
  end


  def curr_speaker
    self.agents[self.curr_agent].speaker    
  end


  def do_set_mask(arg)
    case arg
    when /(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)/
      print_out "to \@FS-MCL set Mask = #{$1}"
      print_out "to \@FS-MCL set EmotionNow = #{$2} #{$3}"
      print_out "to \@FS-MCL set RotNow = #{$4} #{$5} #{$6}"
      if self.curr_agent != $1
	self.curr_agent = $1
	print_out "to \@SSM set Speaker = #{curr_speaker}"
      end
      set_emotion $2, $3.to_f
    when /(\S+)\s+(\S+)\s+([0-9\.\+\-]+)/
      if self.curr_agent != $1
	self.curr_agent = $1
	print_out "to \@SSM set Speaker = #{curr_speaker}"
      end
      set_emotion $2, $3.to_f
      print_out "to \@FS-MCL set Mask = #{$1}"
      print_out "to \@FS-MCL set EmotionNow = #{$2} #{$3}"
    when /(\S+)\s+(\S+)/
      if self.curr_agent != $1
	self.curr_agent = $1
	print_out "to \@SSM set Speaker = #{curr_speaker}"
      end
      set_emotion $2
      print_out "to \@FS-MCL set Mask = #{$1}"
      print_out "to \@FS-MCL set EmotionNow = #{$2}"
    when /(\S+)/
      if self.curr_agent != $1
	self.curr_agent = $1
	print_out "to \@SSM set Speaker = #{curr_speaker}"
      end
      print_out "to \@FS-MCL set Mask = #{$1}"
    end
  end


  def set_emotion(type, level=90, duration=0)
    # duration is not used
=begin
    @mutex.synchronize do
      @agents[@curr_agent].set_emotion(type, level)
    end
=end
    self.agents[self.curr_agent].set_emotion(type, level)
  end


  def do_set_emotion(arg)
    print_out "to \@FS-MCL set Emotion = #{arg}"
    case arg
    when /(.+)\s+([0-9\.\+\-]+)\s+([0-9\.\+\-]+)/
      set_emotion($1, $2.to_f, $3.to_f)
    when /(.+)\s+([0-9\.\+\-]+)/
      set_emotion($1, $2.to_f)
    when /(.+)/
      set_emotion($1)
    end
  end


  def set_speak_speed(arg)
    self.agents[self.curr_agent].ssmspeed = arg.to_f
  end
  

  def do_set(slot, arg)
    super
    case slot
    when "Speak" 
      do_set_speak(arg)
    when "MoveMouth" 
      do_set_move_mouth(arg)
    when "SpeakSpeed" 
      set_speak_speed(arg)
    when "AutoMove" 
      print_out "to \@FS-MCL set AutoMove = #{arg}"
    when "AutoGaze" 
      print_out "to \@DIM set AutoGaze = #{arg}"
    when "Mask" 
      do_set_mask(arg)
    when "Emotion" 
      do_set_emotion(arg)
    when "AutoEmotionSpeak" 
      self.auto_emotion_speak = arg.to_i
    end
  end


  def accept_from_state0(mod, str)
  end


  def accept_from_state1(mod, str)
    # waiting responce of "@SSM set Text = value"
    case mod
    when "SSM"
      case str
      when /rep\s+Speak\.pho\s*=\s*(.*)$/
	phones = $1
	phones.gsub!( /\[/, " " )
	phones.gsub!( /\]/, "" )
	# sil 10 k 100 o 85 N 90 n 25 i 60 ch 105 i 50 w 50 a 95 sil 10
	print_debug phones
#	print_out "to \@FSM prop Speak.stat = AutoOutput"
	print_out "to \@FSM set LipSync.pho = #{phones}"
	print_out "to \@FSM inq Speak.stat"
	print_debug "state: #{self.state} speak.pho ready"
      when /rep\s+Speak\.stat\s*=\s*READY\s*$/
	self.ready_ssm = true
	print_debug "state: #{self.state} ready_ssm"
      when /rep\s+Speak\.stat\s*=\s*ERROR\s*$/ 
	self.state = 0
	sendAgentSpeakState
	self.ready_ssm = false
	self.ready_fsm = false
	print_debug "state: #{self.state}"
      end
    when "FSM"
      case str
      when /rep\s+Speak\.stat\s*=\s*READY\s*$/
	self.ready_fsm = true
	print_debug "state: #{self.state} ready_fsm"
      when /rep\s+Speak\.stat\s*=\s*ERROR\s*$/
	self.state = 0
	sendAgentSpeakState
	self.ready_ssm = false
	self.ready_fsm = false
	print_debug "state: #{self.state}"
      end
    end

    if self.ready_fsm && self.ready_ssm
      self.state = 2
      sendAgentSpeakState
      # print_out "to \@SSM set Save = _speech.raw"
      # print_out "to \@SSM set SpeechFile = _speech.raw"
      # $ play -t .sw -x -r 16000 ../../SSM/_speech.raw

#      print_out "to \@SSM set Speak = +100" # for SSMclient.rb
      print_out "to \@SSM set Speak = +0" # 

      print_out "to \@FSM set Speak = + 0"
      print_debug "state: #{self.state} Speak start"
    end
  end


  def accept_from_state2(mod, str)
    #
    if mod == "SSM" && /rep\s+Speak\.stat\s*=\s*IDLE\s*$/ =~ str
      self.ready_ssm = false
      # print_debug "state: #{self.state} ready_ssm = false"

    elsif mod == "FSM" && /rep\s+Speak\.stat\s*=\s*IDLE\s*$/ =~ str
      self.ready_fsm = false
      # print_debug "state: #{self.state} ready_fsm = false"

    end

    if self.ready_fsm == false && self.ready_ssm == false
      self.state = 0 
      print_debug "state: #{self.state} Speak end"
      sendAgentSpeakState
    end
  end


  def accept_from_state3(mod, str)
    if mod == "FSM" && /rep\s+Speak\.stat\s*=\s*READY\s*$/ =~ str
      self.state = 4
      sendAgentSpeakState
      self.ready_ssm = false
      self.ready_fsm = true
      print_debug "state: #{self.state} ready_fsm"
      print_out "to \@FSM set Speak = + 0"
      print_debug "state: #{self.state} Speak start"

    elsif mod == "FSM" && /rep\s+Speak\.stat\s*=\s*ERROR\s*$/ =~ str
      self.state = 0
      sendAgentSpeakState
      self.ready_ssm = false
      self.ready_fsm = false
      print_debug "state: #{self.state}"
    end
  end


  def accept_from_state4(mod, str)
    if mod == "FSM" && /rep\s+Speak\.stat\s*=\s*IDLE\s*$/ =~ str
      self.state = 0 
      print_debug "state: #{self.state} Speak end"
      self.ready_fsm = false
      sendAgentSpeakState
    end
  end


  def accept_from(mod, str)

    #
    # From @XXX set YYY = ZZZ  to @AM-MCL ȸʤ do_set ǽ
    #
    if /^\s*set\s+([^\s=]*)\s*=\s*(.*)$/ =~ str
      do_set $1, $2
      return
    end

    #
    # lipsync
    #
      
    case self.state 
    when 1
      accept_from_state1(mod, str)
    when 2
      accept_from_state2(mod, str)
    when 3
      accept_from_state3(mod, str)
    when 4
      accept_from_state4(mod, str)
    end

  end

  def accept_to(mod, str)
    print_out "to \@MON set SysLogText = #{str}"
  end

end

# ------------------------------

AM_MCL.new.run

# end of file
