#!/usr/bin/ruby -Ke -w
# $Id: Agent.rb,v 1.17 2004/07/15 07:42:31 nishi Exp $
#
# by Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)

# ------------------------------

class Agent

  HEAD_ROT_X_MAX = 10
  HEAD_ROT_Y_MAX = 10
  HEAD_ROT_Z_MAX = 10
  
  EYE_ROT_X_MAX = 20
  EYE_ROT_Y_MAX = 10
  EYE_ROT_Z_MAX = 20
  
  # (mask, speaker, rot_x, rot_y, trans_x, trans_y, scale)
  # rot_z = 0
  # @agents["man01"]   = Agent.new('man01',   'male01',   5, 3, -0.05, 0, 1.2 )

  def initialize(mask, speaker, rot_x=0, rot_y=0, trans_x=0, trans_y=0, scale=1)
    # clock
    @clock = 0.0
    @clock_head = 0.0

    # speak
    @speaker = speaker
    @ssmspeed = 1.0

    # mask
    @mask = mask

    # agent trans
    @agent_trans_x_base, @agent_trans_y_base = trans_x, trans_y
    @agent_trans_x, @agent_trans_y = trans_x, trans_y

    # agent scale
    @agent_scale_base = scale
    @agent_scale = scale

    # agent rot
    @agent_rot_x_base, @agent_rot_y_base = rot_x, rot_y
    # @agent_rot_z_base = 0

    @target_agent_rot_count = 0
    @target_agent_rot_dx = 0.0
    @target_agent_rot_dy = 0.0
    # @target_agent_rot_dz = 0.0

    @agent_rot_x, @agent_rot_y = rot_x, rot_y
    # @agent_rot_z = 0

    # head rot
    @head_rot_x_base = 0
    @head_rot_y_base = 0
    @head_rot_z_base = 0

    @target_head_rot_count = 0
    @target_head_rot_dx = 0.0
    @target_head_rot_dy = 0.0
    @target_head_rot_dz = 0.0

    @head_rot_x = 0
    @head_rot_y = 0
    @head_rot_z = 0

    # eye rot
    @eye_rot_x = 0
    @eye_rot_y = 0
    @eye_rot_z = 0

    # exp
    @exp_level = 0.0
    @exp_level_base = 0.0
    @exp_level_target = 0.0
    @exp_level_max = 100.0
    @exp_level_range = 10.0
    @exp_type = 'NEUTRAL'
    @exp_type_target = 'NEUTRAL'

    @agentSpeakState = 0

    @nodding_range = 0.0
    @nodding_range_delta = 0.0
    @nodding_count = 0
    @nodding_head_x = 0.0

  end


  def calc
    calc_head_movement
    calc_agent_movement
    calc_emotion_change
  end

  def calc_head_movement
    if @target_head_rot_count > 0
      @head_rot_x_base += @target_head_rot_dx
      @head_rot_y_base += @target_head_rot_dy
      @head_rot_z_base += @target_head_rot_dz
      @target_head_rot_count -= 1
    end

    # x:up/down y:left/right z:rotate
    @head_rot_x = @head_rot_x_base + Math.cos(@clock_head * 0.4) * 1.10 + Math.cos(@clock_head * 5.0 ) * 0.50
    @head_rot_y = @head_rot_y_base + Math.cos(@clock_head * 0.1) * 0.05 + Math.cos(@clock_head * 4.0 ) * 0.02
    @head_rot_z = @head_rot_z_base + Math.cos(@clock_head * 0.9) * 0.15 + Math.cos(@clock_head * 3.0 ) * 0.07

    # nodding
    calc_nodding()
    @head_rot_x += self.nodding_head_x
    
    if @head_rot_x < -HEAD_ROT_X_MAX then @head_rot_x = -HEAD_ROT_X_MAX end
    if @head_rot_y < -HEAD_ROT_Y_MAX then @head_rot_y = -HEAD_ROT_Y_MAX end
    if @head_rot_z < -HEAD_ROT_Z_MAX then @head_rot_z = -HEAD_ROT_Z_MAX end
    
    if @head_rot_x > HEAD_ROT_X_MAX then @head_rot_x = HEAD_ROT_X_MAX end
    if @head_rot_y > HEAD_ROT_Y_MAX then @head_rot_y = HEAD_ROT_Y_MAX end
    if @head_rot_z > HEAD_ROT_Z_MAX then @head_rot_z = HEAD_ROT_Z_MAX end
  end

  def calc_agent_movement
    if @target_agent_rot_count > 0
      @agent_rot_x_base += @target_agent_rot_dx
      @agent_rot_y_base += @target_agent_rot_dy
      # @agent_rot_z_base += @target_agent_rot_dz
      @target_agent_rot_count -= 1
    end

    @agent_rot_x = @agent_rot_x_base + Math.cos(@clock * 1.6) * 0.20
    @agent_rot_y = @agent_rot_y_base + Math.cos(@clock * 1.2) * 0.10
    # @agent_rot_z = @agent_rot_z_base + Math.cos(@clock * 1.3) * 0.05
    @agent_trans_x = @agent_trans_x_base + Math.cos(@clock * 2.5) * 0.001
    @agent_trans_y = @agent_trans_y_base + Math.cos(@clock * 1.5) * 0.001
    @agent_scale = @agent_scale_base + Math.cos(@clock * 0.2) * 0.005
  end

  def set_emotion(type, level)
    @exp_type_target = type
    @exp_level_target = level
    @exp_level_max = level
  end

  def set_emotion_now(type, level)
    @exp_type_target = type
    @exp_level_target = level
    @exp_level_max = level

    @exp_type = type
    @exp_level = level
  end

  def calc_emotion_change
    if @exp_type != @exp_type_target
      if @exp_level_base < 10 
	@exp_level_base = 0
	@exp_type = @exp_type_target
      else
	@exp_level_base -= 20
      end
    else
      @exp_level_base += (@exp_level_target - @exp_level_base) * 0.5
    end

    @exp_level = @exp_level_base + Math.cos(@clock * 5) * @exp_level_range

    if @exp_level > @exp_level_max then @exp_level = @exp_level_max end
    if @exp_level < 0              then @exp_level = 0              end

  end

  def set_target_rot(target_x, target_y, target_z)
    set_target_agent_rot(target_x, target_y, target_z)    
    set_target_head_rot(target_x, target_y, target_z)    
    set_target_eye_rot(target_x, target_y, target_z)    
  end

  def set_rot_now(target_x, target_y, target_z)
    @agent_rot_x_base, @agent_rot_y_base = target_x, target_y
    @head_rot_x_base, @head_rot_y_base, @head_rot_z_base = target_x, target_y, target_z
    set_target_rot(target_x, target_y, target_z)
  end

  def set_target_head_rot(target_x, target_y, target_z)
    @target_head_rot_count = 3
    @target_head_rot_dx = (target_x - @head_rot_x_base) / @target_head_rot_count
    @target_head_rot_dy = (target_y - @head_rot_y_base) / @target_head_rot_count
    @target_head_rot_dz = (target_z - @head_rot_z_base) / @target_head_rot_count
  end

  def set_target_agent_rot(target_x, target_y, target_z)
    @target_agent_rot_count = 5
    @target_agent_rot_dx = (target_x - @agent_rot_x_base) / @target_agent_rot_count
    @target_agent_rot_dy = (target_y - @agent_rot_y_base) / @target_agent_rot_count
  end

  def set_target_eye_rot(target_x, target_y, target_z)
    @eye_rot_x, @eye_rot_y, @eye_rot_z  = target_x, target_y, target_z

    if @eye_rot_x < -EYE_ROT_X_MAX then @eye_rot_x = -EYE_ROT_X_MAX end
    if @eye_rot_y < -EYE_ROT_Y_MAX then @eye_rot_y = -EYE_ROT_Y_MAX end
    if @eye_rot_z < -EYE_ROT_Z_MAX then @eye_rot_z = -EYE_ROT_Z_MAX end

    if @eye_rot_x > EYE_ROT_X_MAX then @eye_rot_x = EYE_ROT_X_MAX end
    if @eye_rot_y > EYE_ROT_Y_MAX then @eye_rot_y = EYE_ROT_Y_MAX end
    if @eye_rot_z > EYE_ROT_Z_MAX then @eye_rot_z = EYE_ROT_Z_MAX end
  end

  def open_tag
    rate_speed = @ssmspeed
    volume_level = 0.5
    pitch_level = 1.0
    pitch_range = 1.0
    if @exp_type_target == "HAPPY"
      volume_level = 0.55
      pitch_level = 1.1
      pitch_range = 1.0
    elsif @exp_type_target == "DISGUSTED"
      pitch_level = 0.9
      pitch_range = 0.8
    elsif @exp_type_target == "SAD"
      pitch_level = 0.9
      pitch_range = 0.8
      rate_speed *= 1.1
    elsif @exp_type_target == "ANGRY"
      volume_level = 0.75
      pitch_level = 1.2
      pitch_range = 1.5
    elsif @exp_type_target == "SURPRISED"
      volume_level = 0.75
      pitch_level = 1.2
      pitch_range = 0.6
      rate_speed *= 0.8
    elsif @exp_type_target == "FEARED"
      volume_level = 0.75
      pitch_level = 1.4
      pitch_range = 0.7
      rate_speed *= 1.3
    end
    return "<RATE SPEED=\"#{rate_speed}\"><VOLUME LEVEL=\"#{volume_level}\"><PITCH LEVEL=\"#{pitch_level}\" RANGE=\"#{pitch_range}\">"
  end

  def close_tag
    return "</PITCH></VOLUME></RATE>"
  end

  def mouth_scale
    if @exp_type_target == "HAPPY"
      return "40"
    elsif @exp_type_target == "DISGUSTED"
      return "20"
    elsif @exp_type_target == "SAD"
      return "20"
    elsif @exp_type_target == "ANGRY"
      return "40"
    elsif @exp_type_target == "SURPRISED"
      return "10"
    elsif @exp_type_target == "FEARED"
      return "10"
    end
    return "30"
  end

  def add_clock(delta, nospeak = 1.0, speak = 0.3)
    @clock += delta
    if @agentSpeakState != 2
      @clock_head += delta * nospeak
    else
      @clock_head += delta * speak
    end
  end

  def start_nodding(size)
    self.nodding_range = size
    self.nodding_count = 100
    self.nodding_range_delta = -(size / 100)
  end

  def calc_nodding
    if self.nodding_count > 0
      self.nodding_head_x = Math.cos(self.clock * 0.3) * size * 10.0
      self.nodding_count -= 1
      self.nodding_range += self.nodding_range_delta
    else
      self.nodding_head_x = 0.0
    end
  end

  attr_reader :head_rot_x, :head_rot_y, :head_rot_z
  attr_reader :eye_rot_x,  :eye_rot_y,  :eye_rot_z
  attr_reader :trans_x,  :trans_y
  attr_reader :agent_rot_x, :agent_rot_y
  # attr_reader :agent_rot_z
  attr_reader :agent_trans_x, :agent_trans_y
  attr_reader :agent_scale
  attr_reader :mask, :speaker

  attr_accessor :exp_type, :exp_level
  attr_accessor :ssmspeed
  attr_accessor :clock
  attr_accessor :clock_head
  attr_accessor :agentSpeakState

  attr_accessor :nodding_range, :nodding_range_delta, :nodding_count
  attr_accessor :nodding_head_x

end


# end of file
