#!/usr/bin/perl -w
#----------------------------------------------------------------------
# AgentManager ver 1.5.4 by Shin-ichi Kawamoto (skawa@jaist.ac.jp) on 2004 Jul 7.
#
# * added to configuration functions.
#   - broadcast-input  ... recognize module outputs as commands.
#   - broadcast-output ... receive other module outputs.
#   - broadcast-macro  ... receive macro commands.
# * improve inter-module IO.
#
#----------------------------------------------------------------------
# AgentManager ver 1.5.3 by Shin-ichi Kawamoto (skawa@jaist.ac.jp)
# based on AgentManager.pl (s-tamura/skawa)
#
# options:
#       -C ե̾ : ⥸塼եλ
# 	-d            : debug mode
#
# below is the original header:
#----------------------------------------------------------------------
# AgentManager ver 1.5.1 by Shin-ichi Kawamoto (skawa@jaist.ac.jp)
# based on AgentManager.pl (s-tamura/skawa)
#
# options:
#       -C ե̾ : ⥸塼եλ
# 	-d            : debug mode
#
# below is the original header:
#----------------------------------------------------------------------
# AgentManager ver 1.5 by Matsushita Yoshinori (matsuy@jaist.ac.jp)
# based on AgentManager.pl (s-tamura/skawa)
#
# care on open2. option $broadcast. Thu Aug  2 05:25:05 JST 2001
# SIGCHLD concidered version. Tue Jul 31 03:09:42 JST 2001
# include sysreadline() in main_AgentManager(). Tue Jul 31 18:55:53 JST 2001
# added by Shin-ichi KAWAMOTO(skawa@jaist.ac.jp)
# - logfile output.
#
# options:
# 	-d	debug mode
#
# below is the original header:
#----------------------------------------------------------------------
# Filename : AgentManager.pl
#
# ʣλҥץươɸϤPerlΥեϥɥ
# 礹롣(rshѤremoteȤɸϤ)
#
# coded by Sayuki TAMURA	 (s-tamura@jaist.ac.jp) ... Jun 4, 2001.
#		  Shin-ichi KAWAMOTO(skawa@jaist.ac.jp)
#
##################################################################
#----------------------------------------------------------------------

# ɸ⥸塼μ
use strict;
use IPC::Open2;
use IO::Handle '_IONBF';
use IO::Select;
use Fcntl;
use Errno 'EWOULDBLOCK';
use constant READSIZE => 1024;

# use sigtrap;
# use sigtrap qw(stack-trace old-interface-signals);

#- config -------------------------------------------------------------
#----------------------------------------------------------------------
my $verbose;			# Ĺʽϥ⡼
my $blocking_supported = 0;
my $debug = undef;
my $BaseDir = './';
my $logfile = './AgentManager.log';
my $logfp;
my $configfile = './modules.conf';
my $configfp;

# if you would to add module, add line in %module
# 'modulename', 'modulepath',
my %module = ( );		# $module{'modulename'} = command
my %broadcast_input = ( );
my @broadcast2_input;
my %broadcast_output = ( );
my @broadcast2_output;
my %broadcast_macro = ( );
my @broadcast2_macro;
my %pid;			# hold sub process's id
my(%IN_SUB, %OUT_SUB);		# hold references of sub process's IN/OUT file handle
my %FH2MN;			# convert from file-handle to module-name
my %MultiLineBufferCom;		# input buffer for multi-line(Command)
my %MultiLineBufferEndMark;		# input buffer for multi-line(End Marker)
my %MultiLineBufferSlot;		# input buffer for multi-line(Slot)
my %MultiLineBufferValue;		# input buffer for multi-line(Value)
my $read_set = new IO::Select;
my $write_set = new IO::Select;
my $error_set = new IO::Select;
my $timeout = 1;
my $f_flag = '';
my ($r_ready, $w_ready, $e_ready);
my $handlename;
my %ReadBuffer;			# cached input line-buffer.
my %ReadIndex;			# index of cached line-buffer.
my %ReadHandleFlag_EOF;		# detect EOF flag of module I/O handle
my %ReadHandleFlag_ERROR;	# detect ERROR flag of module I/O handle


arg_proc();			# analyze argument
read_config_file();		# read module configuration file
initialize();			# open sub process and set signal handler
main_AgentManager();		# the main routine of Agent manager
finalize();			# kill sub processes handled in %pid
exit 0;

#- subroutines --------------------------------------------------------
#----------------------------------------------------------------------

#- usage --------------------------------------------------------------
sub usage{
    STDERR->print("Usage:\n");
    STDERR->print("%% \n");
    STDERR->print("\n");
    STDERR->print("\n");
    STDERR->print("\n");
    exit(-1);
}

#- command argument analysis-------------------------------------------
sub arg_proc{
    my $i;
    for ($i=0;$i<=$#ARGV;$i++) {
	if ($ARGV[$i] =~ /^-C$/) {
	    $i++;
	    if ($i<=$#ARGV) {
		$configfile = $ARGV[$i];
	    } else {
		STDERR->print("invalid option!!\n");
		usage();
	    }
	} elsif ($ARGV[$i] =~ /^-d$/) {
	    $debug = 1;
	} else {
	    usage();
	}
    }
}

#- read module configuration file -------------------------------------
sub read_config_file{
    $configfp = IO::Handle->new();
    open($configfp,$configfile);
    while (<$configfp>) {
	chomp;
	s;#.*$;; ;      # delete comment 
	if ( /^\s*module:\s*(\S+)\s+commands:\s*(.+)/) {
	    # PIPE³ (open2)
	    $module{$1}="$2";
	}
	elsif ( /^\s*broadcast:\s*(.*)/) {
	    $_=$1;
	    foreach my $key (split) {
		$broadcast_input{$key}=$key;
		$broadcast_output{$key}=$key;
	    }
	}
	elsif ( /^\s*broadcast-input:\s*(.*)/) {
	    # ⥸塼Ϥ򥳥ޥɤȤƲ᤹⥸塼뷲
	    $_=$1;
	    foreach my $key (split) {
		$broadcast_input{$key}=$key;
	    }
	}
	elsif ( /^\s*broadcast-output:\s*(.*)/) {
	    # ¾Υ⥸塼Ϥ⥸塼뷲
	    $_=$1;
	    foreach my $key (split) {
		$broadcast_output{$key}=$key;
	    }
	}
	elsif ( /^\s*broadcast-macro:\s*(.*)/) {
	    # ޥޥɤ⥸塼뷲
	    $_=$1;
	    foreach my $key (split) {
		$broadcast_macro{$key}=$key;
	    }
	}
    }
    close($configfp);
    push(@broadcast2_input,(sort(keys(%broadcast_input))));
    push(@broadcast2_output,(sort(keys(%broadcast_output))));
    push(@broadcast2_macro,(sort(keys(%broadcast_macro))));
}

#- initialize ---------------------------------------------------------
sub initialize{
    $SIG{'CHLD'} = 'finalize_CHLD';	# if caught 'SIGCHLD', and exit AgentManager by finalize()
    $SIG{'PIPE'} = 'finalize_PIPE';
    $SIG{'KILL'} = 'finalize_KILL';
    $SIG{'TERM'} = 'finalize_TERM';
    $SIG{'BUS'} = 'finalize_BUS';
    $SIG{'QUIT'} = 'finalize_QUIT';
    $SIG{'INT'} = 'finalize_INT';
    
    checking_POSIX_packages();	# checking POSIX packages

    if ($debug) {
	$logfp = IO::Handle->new();
	open($logfp,">$logfile");
    }
    foreach (keys %module) {	# open subprocess listed in %module
	STDERR->print(sprintf("LOG: START %s\n",$_));

	# PIPE Connection
	$IN_SUB{$_} = IO::Handle->new(); # subprocess's STDOUT
	$OUT_SUB{$_} = IO::Handle->new(); # subprocess's STDIN
	$FH2MN{$IN_SUB{$_}} = $_;
	$FH2MN{$OUT_SUB{$_}} = $_;
	$pid{$_} = open2($IN_SUB{$_}, $OUT_SUB{$_}, $module{$_}); # pipe subprocess
	if (! $pid{$_}) {
	    warn("$! can't excute $_ ($module{$_}).\n");
	    delete($pid{$_});
	    delete($IN_SUB{$_});
	    delete($OUT_SUB{$_});
	    delete($broadcast_input{$_});
	    delete($broadcast_output{$_});
	    next;
	}
	print_debug("$_ opened. pid is $pid{$_}\n");
	
	$IN_SUB{$_}->autoflush(1);
	$OUT_SUB{$_}->autoflush(1);
	if ($blocking_supported) {
	    blocking($IN_SUB{$_},0);
	    blocking($OUT_SUB{$_},0);
	}
	$read_set->add($IN_SUB{$_});
	$write_set->add($OUT_SUB{$_});
	$error_set->add($IN_SUB{$_});
	$error_set->add($OUT_SUB{$_});
	$ReadBuffer{$_}='';
	$ReadIndex{$_}=0;
	$ReadHandleFlag_EOF{$_}=0;
	$ReadHandleFlag_ERROR{$_}=0;
	# sleep(1);
    }
    $IN_SUB{'STDIN'} = *STDIN;
    $OUT_SUB{'STDOUT'} = *STDOUT;
    $read_set->add(*STDIN);
    $write_set->add(*STDOUT);
    $error_set->add(*STDIN);
    $error_set->add(*STDOUT);
    $FH2MN{*STDIN} = "STDIN";
    $FH2MN{*STDOUT} = "STDOUT";
    $ReadBuffer{'STDIN'}='';
    $ReadIndex{'STDIN'}=0;
    $ReadBuffer{'STDOUT'}='';
    $ReadIndex{'STDOUT'}=0;
}

#- main roop ----------------------------------------------------------
sub main_AgentManager{
    my $start = time();
    my %string;
    my $read_bits = '';
    my $err_bits = '';
    my $count = 0;

    foreach my $hn (sort(keys(%FH2MN))){
	$string{$hn}='';
    }
    STDERR->print(sprintf("broadcast_input: %s\n",join(" ",sort(keys(%broadcast_input)))));

    while (1) {
	$count ++;
	$r_ready = undef;
	$w_ready = undef;
	$e_ready = undef;
	($r_ready, $w_ready, $e_ready) =
	    IO::Select->select($read_set,undef,$error_set,undef);
	if ( $#$e_ready >= 0 ) {	 # detect error handles
	    STDERR->print(sprintf("LOG: e(%d)\n",$#$e_ready+1));
	    foreach my $handle (@$e_ready) {
		$handlename = $FH2MN{$handle};
		print STDERR "ERROR($handlename)\n";
	    }
	    finalize();
	    exit(1);
	}

	foreach my $handle (@$r_ready) { # readable handles
	    my ($char, $moduleStr, $readlen);	# $char: 

	    $handlename = $FH2MN{$handle};
	    if(($readlen = my_getline($handlename,\$string{$handlename}))>0){
		# ɤߤߴλ
		$moduleStr = $string{$handlename};
		$string{$handlename} = undef;
		
		print_debug("from'$handlename': $moduleStr");
		if ($moduleStr =~ /^\s*\n$/) {
		    # Ԥϲʤ
		} elsif ($moduleStr =~ /^\s*AM\s+quit\s*$/) {
		    # "AM quit"üAgentManagerλޥ
		    finalize();
		} elsif ( (exists $broadcast_input{$handlename}) || $handlename =~ /STDIN/ ) {
		    # ⥸塼뤫ʸ򥳥ޥɤȤƲ
		    print_debug("read $handlename: $moduleStr");
		    cut_to($moduleStr,$handlename);
		    # STDERR->print("cut to ( $handlename )\n");
		} else {
		    # ⥸塼뤫ʸϥåȤƲ
		    print_debug($moduleStr);
		    add_from($handlename, $moduleStr);
		    # STDERR->print("add from ( $handlename )\n");
		}
		$moduleStr = '';
	    }
	}

    }
}

#----------------------------------------------------------------------
# distribute to specified module
sub cut_to{
    my($str,$module) = @_;
    my($dest, $content, @dests);

    $_ = $str;
    if (m;\bto\b;) {
	# AM-DCLͳǥ⥸塼ľܥޥ
	if (m;^\s*to\s*\@(\S+)\s+(.*)\s*$;) {
	    $dest = $1;
	    $content = $2;
	    @dests = $dest =~ m;\.;? split(/\./, $dest): $dest;
	    foreach $dest (@dests) {
		print_debug("select_module '$dest': $content");
		select_module($dest, $content);
	    }
	}
    } else {
	# AM-MCLؤ
	if (m;^\s*set\s+(\S+)\s+\<\<\s*(.*)\s*$;) {
	    # ʣϤγ
	    $MultiLineBufferCom{$module} = "set";
	    $MultiLineBufferValue{$module} = "";
	    $MultiLineBufferSlot{$module} = $1;
	    $MultiLineBufferEndMark{$module} = $2;
	}
	elsif(exists($MultiLineBufferEndMark{$module})){
	    # ʣ
	    if (m;^\s*$MultiLineBufferEndMark{$module}\s*$;) {
		# ü
		$MultiLineBufferValue{$module} =~ s/\r//g;
		$MultiLineBufferValue{$module} =~ s/\n//g;
		# set Speak = ʤȤפȤƽ
		my $tmp_message = sprintf("%s %s = %s",$MultiLineBufferCom{$module},$MultiLineBufferSlot{$module},$MultiLineBufferValue{$module});
		select_module('AM-MCL', $tmp_message);
		foreach my $tmp_module (@broadcast2_macro){
		    select_module($tmp_module, $tmp_message);
		}
		
		delete($MultiLineBufferCom{$module});
		delete($MultiLineBufferSlot{$module});
		delete($MultiLineBufferValue{$module});
		delete($MultiLineBufferEndMark{$module});
	    }
	    else{
		# ü
		$MultiLineBufferValue{$module} .= $_;
	    }
	    
	}
	else{			# ¾
	    # select_module('AM-MCL', $_);
	    my $tmp_message = $_;
	    select_module('AM-MCL', $tmp_message);
	    foreach my $tmp_module (@broadcast2_macro){
		select_module($tmp_module, $tmp_message);
	    }

	    if(exists($MultiLineBufferCom{$module})){
		# $MultiLineBufferCom{$module} = "";
		delete($MultiLineBufferCom{$module});
	    }
	    if(exists($MultiLineBufferValue{$module})){
		# $MultiLineBufferValue{$module} = "";
		delete($MultiLineBufferValue{$module});
	    }
	    if(exists($MultiLineBufferSlot{$module})){
		# $MultiLineBufferSlot{$module} = "";
		delete($MultiLineBufferSlot{$module});
	    }
	    if(exists($MultiLineBufferEndMark{$module})){
		# $MultiLineBufferEndMark{$module} = "";
		delete($MultiLineBufferEndMark{$module});
	    }
	}
    }
}

#----------------------------------------------------------------------
sub add_from{			# send to module 'From @SRM ...'
    my($modulename, $string) = @_;

    $_ = $string;
    my($out) = sprintf('From @'.$modulename." $string");
    print_out($out);
    foreach (keys %broadcast_output) {
	# $OUT_SUB{$_}->print($out);
	print $OUT_SUB{$_} ($out);
	$OUT_SUB{$_}->flush();
    }
}

sub select_module{
    my ($dest, $data) = @_;
    #$OUT_SUB{$dest}->print("$data\n");
    #$OUT_SUB{$dest}->flush();

    #my $hdl = $OUT_SUB{$dest};
    #print $hdl "$data\n";
    #$hdl->flush();

    print {$OUT_SUB{$dest}} "$data\n";
    ($OUT_SUB{$dest})->flush();
    print_debug("to'$dest': $data");
}

#- utilities ----------------------------------------------------------
#----------------------------------------------------------------------
sub print_out{
    #$OUT_SUB{'STDOUT'}->print(@_);
    print $OUT_SUB{'STDOUT'} (@_);
    $OUT_SUB{'STDOUT'}->flush();
}

sub print_debug{
    if ($debug) {
	print STDERR "dout:@_";
	$logfp->print("@_");
	$logfp->flush();
    }
}

#----------------------------------------------------------------------
sub finalize{			# close FILEHANDLE and kill childprocess
    STDERR->print("LOG: AM: finalize()\n");

    $SIG{'CHLD'} = 'IGNORE';
    $SIG{'PIPE'} = 'IGNORE';
    $SIG{'KILL'} = 'IGNORE';
    $SIG{'TERM'} = 'IGNORE';
    $SIG{'BUS'}  = 'IGNORE';
    $SIG{'QUIT'} = 'IGNORE';
    $SIG{'INT'}  = 'IGNORE';

    foreach (keys %module) {
	# PIPE Connection
	if( exists($pid{$_}) ){
	    print_debug(sprintf("kill(%s) : pid=%d\n",$_,$pid{$_}));
	    
	    if($_ ne "AM-MCL"){
		$OUT_SUB{$_}->print("set Run = EXIT\n");
		$OUT_SUB{$_}->flush();
	    }
	    close($OUT_SUB{$_});
	    close($IN_SUB{$_});
	    kill('TERM', $pid{$_});
	    kill('KILL', $pid{$_});
	    # kill(9, $pid{$_});
	}
    }
    foreach (keys %module) {
	# PIPE Connection
	if( exists($pid{$_}) ){
	    print_debug(sprintf("wait(%s) : pid=%d\n",$_,$pid{$_}));
	    # wait();
	    waitpid($pid{$_},1);
	    
	    delete($pid{$_});
	    delete($IN_SUB{$_});
	    delete($OUT_SUB{$_});
	}
    }
    if ($debug) {
	close($logfp);
    }

    $SIG{'CHLD'} = 'DEFAULT';
    $SIG{'PIPE'} = 'DEFAULT';
    $SIG{'KILL'} = 'DEFAULT';
    $SIG{'TERM'} = 'DEFAULT';
    $SIG{'BUS'}  = 'DEFAULT';
    $SIG{'QUIT'} = 'DEFAULT';
    $SIG{'INT'}  = 'DEFAULT';

    exit 0;
}
#----------------------------------------------------------------------
# signal
sub finalize_CHLD {
    if($verbose){
	STDERR->print("LOG: caught signal (SIGCHLD)\n");
    }
    finalize();
}
sub finalize_PIPE {
    if($verbose){
	STDERR->print("LOG: caught signal (SIGPIPE)\n");
    }
    finalize();
}
sub finalize_KILL {
    if($verbose){
	STDERR->print("LOG: caught signal (SIGKILL)\n");
    }
    finalize();
}
sub finalize_TERM {
    if($verbose){
	STDERR->print("LOG: caught signal (SIGTERM)\n");
    }
    finalize();
}
sub finalize_BUS {
    if($verbose){
	STDERR->print("LOG: caught signal (SIGBUS)\n");
    }
    finalize();
}
sub finalize_QUIT {
    if($verbose){
	STDERR->print("LOG: caught signal (SIGQUIT)\n");
    }
    finalize();
}
sub finalize_INT {
    if($verbose){
	STDERR->print("LOG: caught signal (SIGINT)\n");
    }
    finalize();
}

sub checking_POSIX_packages {
    eval {
	require POSIX; POSIX->import(qw(F_SETFL O_NONBLOCK EAGAIN));
    };
    $blocking_supported = 1 unless $@;
}

sub blocking {
    my ($handle,$blocking) = @_;
    #die "Can't fcntl(F_GETFL)" unless my $flags = fcntl($handle,F_GETFL,0);
    my $flags = fcntl($handle,F_GETFL(),0);
    my $current = ($flags & O_NONBLOCK) == 0;
    if(defined $blocking){
	$flags &= ~O_NONBLOCK     if $blocking;
	$flags |= ~O_NONBLOCK unless $blocking;
	#die "Can't fcntl(F_SETFL)" unless fcntl($handle,F_SETFL,$flags);
	fcntl($handle,F_SETFL(),$flags);
    }
    return $current;
}


# $bytes = my_getline($handle,$data);
# returns bytes read on success
# returns undef on error
# returns 0 on EOF
# returns 0E0 if would block
sub my_getline {
  my ($handlename,$buffer) = @_;
  my $handle = $IN_SUB{$handlename};
  my $tmpindex = $ReadIndex{$handlename};
  my $tmpbuffer = $ReadBuffer{$handlename};

  return 0 if $ReadHandleFlag_EOF{$handlename};	# a previous read returned EOF
  return   if $ReadHandleFlag_ERROR{$handlename}; # a previous read returned error

  # Look up position of the line end character in the buffer.
  my $i = index($tmpbuffer,$/,$tmpindex);
  if ($i < 0) {
    $tmpindex = length $tmpbuffer;
    my $rc = $handle->sysread($tmpbuffer,
			      READSIZE,length $tmpbuffer);

    unless (defined $rc) {  # we got an error
      return '0E0' if $! == EWOULDBLOCK;  # wouldblock is OK
      $$buffer = $tmpbuffer;            # return whatever we have left
      $ReadHandleFlag_ERROR{$handlename}=$!; # remember what happened
      return length $$buffer;                # and return the size
    } 

    elsif ($rc == 0) {    # we got EOF
      $$buffer = $tmpbuffer;            # return whatever we have left
      $ReadHandleFlag_EOF{$handlename}++; # remember what happened
      return length $$buffer;
    }

    # if we get here, we got a positive read, so look for EOL again
    $i = index($tmpbuffer,$/,$tmpindex);
  }


  # If $i<0, then newline not found.  Pretend this is an EWOULDBLOCK
  if ($i < 0) {
    $tmpindex = length $tmpbuffer;
    $ReadIndex{$handlename} = $tmpindex;
    $ReadBuffer{$handlename} = $tmpbuffer;
    return '0E0';
  }

  $$buffer = substr($tmpbuffer,0,$i+length($/));  # save the line
  substr($tmpbuffer,0,$i+length($/)) = '';     # and chop off the rest
  $tmpindex = 0;
  $ReadIndex{$handlename} = $tmpindex;
  $ReadBuffer{$handlename} = $tmpbuffer;
  return length $$buffer;
}

#- end of script ------------------------------------------------------
#----------------------------------------------------------------------
