#!/usr/bin/perl -w
# $Id: AgentManager.pl,v 1.11 2004/11/29 10:15:18 nishi Exp $
#----------------------------------------------------------------------
# AgentManager for Galatea Dialog Manager
# by Takuya Nishimoto (nishi@hil.t.u-tokyo.ac.jp)
#
# below is the original header:
#----------------------------------------------------------------------
# AgentManager ver 1.5.1 by Shin-ichi Kawamoto (skawa@jaist.ac.jp)
# based on AgentManager.pl (s-tamura/skawa)
#
# options:
#       -C ե̾ : ⥸塼եλ
# 	-d            : debug mode
#
# below is the original header:
#----------------------------------------------------------------------
# AgentManager ver 1.5 by Matsushita Yoshinori (matsuy@jaist.ac.jp)
# based on AgentManager.pl (s-tamura/skawa)
#
# care on open2. option $broadcast. Thu Aug  2 05:25:05 JST 2001
# SIGCHLD concidered version. Tue Jul 31 03:09:42 JST 2001
# include sysreadline() in main_AgentManager(). Tue Jul 31 18:55:53 JST 2001
# added by Shin-ichi KAWAMOTO(skawa@jaist.ac.jp)
# - logfile output.
#
# options:
# 	-d	debug mode
#
# below is the original header:
#----------------------------------------------------------------------
# Filename : AgentManager.pl
#
# ʣλҥץươɸϤPerlΥեϥɥ
# 礹롣(rshѤremoteȤɸϤ)
#
# coded by Sayuki TAMURA	 (s-tamura@jaist.ac.jp) ... Jun 4, 2001.
#		  Shin-ichi KAWAMOTO(skawa@jaist.ac.jp)
#
##################################################################
#----------------------------------------------------------------------

# ɸ⥸塼μ
use strict;
use IPC::Open2;
use IO::Handle '_IONBF';
use IO::Select;
use Fcntl;
# use sigtrap;
# use sigtrap qw(stack-trace old-interface-signals);

#- config -------------------------------------------------------------
#----------------------------------------------------------------------

#my $debug = grep(/^-d$/, @ARGV);
my $debug = undef;
my $BaseDir = './';
my $logfile = './AgentManager.log';
my $logfp;
my $configfile = './modules.conf';
my $configfp;

# if you would to add module, add line in %module
# 'modulename', 'modulepath',
my %module = ( );
my %broadcast = ( );
my @broadcast2;
my %pid;			# hold sub process's id
my(%IN_SUB, %OUT_SUB);		# hold references of sub process's IN/OUT file handle
my %FH2MN;			# convert from file-handle to module-name
my %MultiLineBufferCom;		# input buffer for multi-line(Command)
my %MultiLineBufferEndMark;		# input buffer for multi-line(End Marker)
my %MultiLineBufferSlot;		# input buffer for multi-line(Slot)
my %MultiLineBufferValue;		# input buffer for multi-line(Value)
my $read_set = new IO::Select;
my $write_set = new IO::Select;
my $error_set = new IO::Select;
#my $timeout = 0.1;
my $timeout = 1;
#my $timeout = undef;
my $f_flag = '';
my ($r_ready, $w_ready, $e_ready);
#my (@r_ready, @w_ready, @e_ready);
my $handlename;

arg_proc();			# analyze argument
read_config_file();		# read module configuration file
initialize();			# open sub process and set signal handler
main_AgentManager();		# the main routine of Agent manager
finalize();			# kill sub processes handled in %pid
exit 0;

#- subroutines --------------------------------------------------------
#----------------------------------------------------------------------

#- usage --------------------------------------------------------------
sub usage{
  STDERR->print("Usage:\n");
  STDERR->print("%% \n");
  STDERR->print("\n");
  STDERR->print("\n");
  STDERR->print("\n");
  exit(-1);
}

#- command argument analysis-------------------------------------------
sub arg_proc{
  my $i;
  for ($i=0;$i<=$#ARGV;$i++) {
    if ($ARGV[$i] =~ /^-C$/) {
      $i++;
      if ($i<=$#ARGV) {
	$configfile = $ARGV[$i];
      } else {
	STDERR->print("invalid option!!\n");
	usage();
      }
    } elsif ($ARGV[$i] =~ /^-d$/) {
      $debug = 1;
    } else {
      usage();
    }
  }
}

#- read module configuration file -------------------------------------
sub read_config_file{
  $configfp = IO::Handle->new();
  open($configfp,$configfile);
  while (<$configfp>) {
    chomp;
    s;#.*$;; ;      # delete comment 
      if ( /^\s*module:\s*(\S+)\s+commands:\s*(.+)/) {
	$module{$1}="$2";
      } elsif ( /^\s*broadcast:\s*(.*)/) {
	$_=$1;
	foreach my $key (split) {
	  $broadcast{$key}=$key;
	}
      }
  }
  close($configfp);
  push(@broadcast2,(sort(keys(%broadcast))));

  foreach (sort(keys(%broadcast))) {
    STDERR->print(sprintf("set broadcast = %s\n",$_));
  }
}

#- initialize ---------------------------------------------------------
sub initialize{
  $SIG{'CHLD'} = 'finalize_CHLD';	# if caught 'SIGCHLD', and exit AgentManager by finalize()
  $SIG{'PIPE'} = 'finalize_PIPE';
  $SIG{'KILL'} = 'finalize_KILL';
  $SIG{'TERM'} = 'finalize_TERM';
  $SIG{'BUS'} = 'finalize_BUS';
  $SIG{'QUIT'} = 'finalize_QUIT';
  $SIG{'INT'} = 'finalize_INT';
    
  if ($debug) {
    $logfp = IO::Handle->new();
    open($logfp,">$logfile");
  }
  foreach (keys %module) {	# open subprocess listed in %module
    STDERR->print(sprintf("LOG: START %s\n",$_));
    $IN_SUB{$_} = IO::Handle->new(); # subprocess's STDOUT
    $OUT_SUB{$_} = IO::Handle->new(); # subprocess's STDIN
    $FH2MN{$IN_SUB{$_}} = $_;
    $FH2MN{$OUT_SUB{$_}} = $_;
    $pid{$_} = open2($IN_SUB{$_}, $OUT_SUB{$_}, $module{$_}); # pipe subprocess
    if (! $pid{$_}) {
      warn("$! can't excute $_ ($module{$_}).\n");
      delete($pid{$_});
      delete($IN_SUB{$_});
      delete($OUT_SUB{$_});
      delete($broadcast{$_});
      next;
    } 
#    else{
#      $pid{$_}++;
#    }
    print_debug("$_ opened. pid is $pid{$_}\n");

# by nishi
#    open(FH,">/var/tmp/$_.pid");
#    print FH "$pid{$_}";
#    close(FH);
# by nishi end

    $IN_SUB{$_}->autoflush();
    $OUT_SUB{$_}->autoflush();
    # $IN_SUB{$_}->setvbuf(undef, _IONBF, 0);
    # $OUT_SUB{$_}->setvbuf(undef, _IONBF, 0);
    #	$f_flag = '';
    #	fcntl($OUT_SUB{$_},F_GETFL(),$f_flag);
    #	$f_flag |= O_NONBLOCK();
    #	fcntl($OUT_SUB{$_},F_SETFL(),$f_flag);
    # fcntl($OUT_SUB{$_},F_SETFL(),O_NONBLOCK());
    $read_set->add($IN_SUB{$_});
    $write_set->add($OUT_SUB{$_});
    $error_set->add($IN_SUB{$_});
    $error_set->add($OUT_SUB{$_});

    # by nishi
    # TODO:  sleep äƤԶ礬ʤ褦ˤ
    # sleep(1); 
  }
  $IN_SUB{'STDIN'} = *STDIN;
  $OUT_SUB{'STDOUT'} = *STDOUT;
  $read_set->add(*STDIN);
  $write_set->add(*STDOUT);
  $error_set->add(*STDIN);
  $error_set->add(*STDOUT);
  $FH2MN{*STDIN} = "STDIN";
  $FH2MN{*STDOUT} = "STDOUT";
}

#- main roop ----------------------------------------------------------
sub main_AgentManager{
  my $start = time();
  my %string;
  my $read_bits = '';
  my $err_bits = '';
  my $count = 0;
  while (1) {
    $count ++;
    $r_ready = undef;
    $w_ready = undef;
    $e_ready = undef;
    ($r_ready, $w_ready, $e_ready) =
      IO::Select->select($read_set,undef,$error_set,undef);
    if ( $#$e_ready >= 0 ) {	 # detect error handles
      STDERR->print(sprintf("LOG: e(%d)\n",$#$e_ready+1));
      foreach my $handle (@$e_ready) {
	$handlename = $FH2MN{$handle};
	print STDERR "ERROR($handlename)\n";
      }
      finalize();
      exit(1);
    }

    foreach my $handle (@$r_ready) { # readable handles
      my ($char, $moduleStr);	# $char: 
      $handlename = $FH2MN{$handle};
      # $handle->sysread($char, 1) or die("read-net:$!");
      if ( ! $handle->sysread($char, 1) ) {
	# warn("read-net:$!");
	# finalize();
	#
        # by nishi
	warn("read-net:$! $moduleStr");
      }
      $string{$handlename} .= $char;
      #	    $string{$handlename} = $handle->getline or die("read-net:$!");
      #	    $char = "\n";
      if ($char =~ /\n/) {
	$moduleStr = $string{$handlename};
	$string{$handlename} = undef;
	print_debug("from'$handlename': $moduleStr");
	if ($moduleStr =~ /^\s*\n$/) {
	} elsif ($moduleStr =~ /^AM\s+quit/) {
	  finalize();
	} elsif ( (exists $broadcast{$handlename}) || $handlename =~ /STDIN/ ) {
	  print_debug("read $handlename: $moduleStr");
	  cut_to($moduleStr,$handlename);
	  #		    STDERR->print("cut to ( $handlename )\n");
	} else {
	  print_debug($moduleStr);
	  add_from($handlename, $moduleStr);
	  #		    STDERR->print("add from ( $handlename )\n");
	}
	$moduleStr = '';
      }
    }

  }
}

#----------------------------------------------------------------------
# distribute to specified module
sub cut_to{
  my($str,$module) = @_;
  my($dest, $content, @dests);

  $_ = $str;
  if (m;\bto\b;) {
    if (m;^\s*to\s*\@(\S+)\s+(.*)\s*$;) {
      $dest = $1;
      $content = $2;
      @dests = $dest =~ m;\.;? split(/\./, $dest): $dest;
      foreach $dest (@dests) {
	print_debug("select_module '$dest': $content\n"); # \n added by nishi
	select_module($dest, $content);
      }
    }
  } else {
    # AM-MCLؤ
    if (m;^\s*set\s+(\S+)\s+\<\<\s*(.*)\s*$;) {
      # ʣϤγ
      $MultiLineBufferCom{$module} = "set";
      $MultiLineBufferValue{$module} = "";
      $MultiLineBufferSlot{$module} = $1;
      $MultiLineBufferEndMark{$module} = $2;
    }
    elsif(exists($MultiLineBufferEndMark{$module})){
      # ʣ
      if (m;^\s*$MultiLineBufferEndMark{$module}\s*$;) {
	# ü
	$MultiLineBufferValue{$module} =~ s/\r//g;
	$MultiLineBufferValue{$module} =~ s/\n//g;
	# set Speak = ʤȤפȤƽ
	select_module('AM-MCL', sprintf("%s %s = %s",$MultiLineBufferCom{$module},$MultiLineBufferSlot{$module},$MultiLineBufferValue{$module}));
	delete($MultiLineBufferCom{$module});
	delete($MultiLineBufferSlot{$module});
	delete($MultiLineBufferValue{$module});
	delete($MultiLineBufferEndMark{$module});
	
      }
      else{
	# ü
	$MultiLineBufferValue{$module} .= $_;
      }
      
    }
    else{			# ¾
      select_module('AM-MCL', $_);
      if(exists($MultiLineBufferCom{$module})){
	# $MultiLineBufferCom{$module} = "";
	delete($MultiLineBufferCom{$module});
      }
      if(exists($MultiLineBufferValue{$module})){
	# $MultiLineBufferValue{$module} = "";
	delete($MultiLineBufferValue{$module});
      }
      if(exists($MultiLineBufferSlot{$module})){
	# $MultiLineBufferSlot{$module} = "";
	delete($MultiLineBufferSlot{$module});
      }
      if(exists($MultiLineBufferEndMark{$module})){
	# $MultiLineBufferEndMark{$module} = "";
	delete($MultiLineBufferEndMark{$module});
      }
    }
  }
}

#----------------------------------------------------------------------
# by nishi
# : ƥ⥸塼뤫ν (From @xxx) broadcast & print_out 
#
# : ƥ⥸塼뤫ν (From @xxx) 
#       From @xxx to @yyy Ǥ yyy 
#       From @xxx to @yyy,zzz Ǥ yyy,zzz 
#       to ʤ broadcast
#       print_out Ϥʤ
# 
# sub add_from{			# send to module 'From @SRM ...'
#   my($modulename, $string) = @_;
# 
#   $_ = $string;
#   my($out) = sprintf('From @'.$modulename." $string");
#   print_out($out);
#   print_debug($out);
#   foreach (keys %broadcast) {
#     $OUT_SUB{$_}->print($out);
#     $OUT_SUB{$_}->flush();
#   }
# }
#
sub add_from{			# send to module 'From @SRM ...'
  my($modulename, $string) = @_;

  $_ = $string;
  if (m;\bto\b;) {
    if (m;^\s*to\s*\@(\S+)\s+(.*)\s*$;) {
	my $dest = $1;
	my $content = $2;
	my @dests = $dest =~ m;\.;? split(/\./, $dest): $dest;
	foreach $dest (@dests) {
	    print_debug("select_module '$dest': $content\n");  # \n added by nishi
	    select_module($dest, $content);
	}
    }
  } else {
      my($out) = sprintf('From @'.$modulename." $string");
      # print_out($out);
      print_debug($out);
      foreach (keys %broadcast) {
	  $OUT_SUB{$_}->print($out);
	  $OUT_SUB{$_}->flush();
      }
  }
}

sub select_module{
  my ($dest, $data) = @_;

#  $OUT_SUB{$dest}->print("$data\n");
#  $OUT_SUB{$dest}->flush();

  if (exists($OUT_SUB{$dest})) {
    $OUT_SUB{$dest}->print("$data\n");
    $OUT_SUB{$dest}->flush();
  } else {
    warn("$dest : module not found");
  }

  print_debug("to'$dest': $data\n");  # \n added by nishi
}

#- utilities ----------------------------------------------------------
#----------------------------------------------------------------------
sub print_out{
  $OUT_SUB{'STDOUT'}->print(@_);
  $OUT_SUB{'STDOUT'}->flush();
}

sub print_debug{
  if ($debug) {
    print STDERR "dout:@_";
    $logfp->print("@_");
    $logfp->flush();
  }
}

#----------------------------------------------------------------------
sub finalize{			# close FILEHANDLE and kill childprocess
  STDERR->print("LOG: AM: finalize()\n");
  foreach (keys %module) {
    print_debug(sprintf("kill(%s) : pid=%d\n",$_,$pid{$_}));

    if($_ ne "AM-MCL"){
      $OUT_SUB{$_}->print("set Run = EXIT\n");
      $OUT_SUB{$_}->flush();
    }
    close($OUT_SUB{$_});
    close($IN_SUB{$_});
    kill('TERM', $pid{$_});
    kill('KILL', $pid{$_});
    # kill(9, $pid{$_});
  }
  foreach (keys %module) {
    print_debug(sprintf("wait(%s) : pid=%d\n",$_,$pid{$_}));
    # wait();
    waitpid($pid{$_},1);
  }
  if ($debug) {
    close($logfp);
  }
  exit 0;
}
#----------------------------------------------------------------------
# signal
sub finalize_CHLD {
  warn("finalize_CHLD"); # by nishi
  finalize();
}
sub finalize_PIPE {
  warn("finalize_PIPE"); # by nishi
  finalize();
}
sub finalize_KILL {
  warn("finalize_KILL"); # by nishi
  finalize();
}
sub finalize_TERM {
  warn("finalize_TERM"); # by nishi
  finalize();
}
sub finalize_BUS {
  warn("finalize_BUS"); # by nishi
  finalize();
}
sub finalize_QUIT {
  warn("finalize_QUIT"); # by nishi
  finalize();
}
sub finalize_INT {
  warn("finalize_INT"); # by nishi
  finalize();
}


#- end of script ------------------------------------------------------
#----------------------------------------------------------------------
