#!/usr/bin/ruby -Ke
#
# (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
# $Id: MON.rb,v 1.55 2004/05/31 01:36:10 nishi Exp $
#
# Galatea Monitor
#
# to @MON set SysLogText = message
# to @MON set AppLogText = message
# to @MON set Run = EXIT

require 'GalateaBase.rb'

# -------------

$tk_thread_safe = true
require 'tk'
require 'open3'

$applog_height = 3
$syslog_height = 3


# -------------

menubar = TkFrame.new {
  relief 'raised'
  borderwidth 1
  pack('fill' => 'x')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "File"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'xmixer', 'command' => proc{
      Open3.popen3("xmixer")
    }

    add 'command', 'label' => 'gmix', 'command' => proc{
      Open3.popen3("gmix")
    }
    
    add 'command', 'label' => 'Pause', 'command' => proc{
      send_cmd "GDM_PAUSE"
    }
    add 'command', 'label' => 'Resume', 'command' => proc{
      send_cmd "GDM_RESUME"
    }
    add 'command', 'label' => 'Restart', 'command' => proc{
      send_cmd "GDM_RESTART"
    }

    add 'command', 'label' => 'Open VXML File', 'command' => proc{
      filename = Tk.getOpenFile
      if filename != "" then
	send_restart_doc filename
      end
    }

    add 'command', 'label' => 'default', 'command' => proc{
      send_restart_doc "../lib/default.vxml"
    }

    add 'command', 'label' => 'ξȸ', 'command' => proc{
      send_restart_doc "../demo/kani.vxml"
    }

    add 'command', 'label' => 'ưֶ', 'command' => proc{
      send_restart_doc "../tests/conte01.vxml"
    }

    add 'command', 'label' => 'ŷ', 'command' => proc{
      send_restart_doc "../tests/weather.vxml"
    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

def send_cmd(cmd)
  puts "to \@SIM set ButtonPressed = <ev src=\"GUI\" type=\"COMMAND\"><interpreted><text>#{cmd}</text></interpreted></ev>"
  STDOUT.flush
end

def send_restart_doc(filename)
  puts "to \@SIM set ButtonPressed = <ev src=\"GUI\" type=\"COMMAND\"><interpreted><text>GDM_RESTART</text><script>$restart_document = '#{filename}';</script></interpreted></ev>"
  STDOUT.flush
end


# -------------

TkMenubutton.new(menubar) { |mb|
  text "FSM1"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'bg1', 'command' => proc{
      puts "to \@FSM set Background = bg1"; STDOUT.flush
    }
    add 'command', 'label' => 'bg2', 'command' => proc{
      puts "to \@FSM set Background = bg2"; STDOUT.flush
    }
    add 'command', 'label' => 'bg3', 'command' => proc{
      puts "to \@FSM set Background = bg3"; STDOUT.flush
    }
    add 'command', 'label' => 'bg4', 'command' => proc{
      puts "to \@FSM set Background = bg4"; STDOUT.flush
    }

    add 'command', 'label' => 'slab01', 'command' => proc{
      puts "to \@FSM set Background = slab01"; STDOUT.flush
    }
    add 'command', 'label' => 'slab02', 'command' => proc{
      puts "to \@FSM set Background = slab02"; STDOUT.flush
    }
    add 'command', 'label' => 'slab03', 'command' => proc{
      puts "to \@FSM set Background = slab03"; STDOUT.flush
    }
    add 'command', 'label' => 'slab04', 'command' => proc{
      puts "to \@FSM set Background = slab04"; STDOUT.flush
    }
    add 'command', 'label' => 'slab05', 'command' => proc{
      puts "to \@FSM set Background = slab05"; STDOUT.flush
    }

    add 'command', 'label' => 'AgentEnable', 'command' => proc{
      puts "to \@FSM set AgentEnable = ENABLE"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentDisable', 'command' => proc{
      puts "to \@FSM set AgentEnable = DISABLE"; STDOUT.flush
    }

    add 'command', 'label' => 'ViewMode TEXTURE', 'command' => proc{
      puts "to \@FSM set ViewMode = TEXTURE"; STDOUT.flush
    }
    add 'command', 'label' => 'ViewMode TEXTURE_WITH_WIREFRAME', 'command' => proc{
      puts "to \@FSM set ViewMode = TEXTURE_WITH_WIREFRAME"; STDOUT.flush
    }
    add 'command', 'label' => 'ViewMode WIREFRAME', 'command' => proc{
      puts "to \@FSM set ViewMode = WIREFRAME"; STDOUT.flush
    }

    add 'command', 'label' => 'Blink', 'command' => proc{
      puts "to \@FSM set FaceMot = BLINK 1"; STDOUT.flush
    }
    add 'command', 'label' => 'Nod', 'command' => proc{
      puts "to \@FSM set FaceMot = NOD 1"; STDOUT.flush
    }
    add 'command', 'label' => 'Refuse', 'command' => proc{
      puts "to \@FSM set FaceMot = REFUSE 1"; STDOUT.flush
    }
    add 'command', 'label' => 'Listen', 'command' => proc{
      puts "to \@FSM set FaceMot = LISTEN 1"; STDOUT.flush
    }

    add 'command', 'label' => 'FS-MCL Nod', 'command' => proc{
      puts "to \@FS-MCL set Nod = 1"; STDOUT.flush
    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "FSM2"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'MouthScale 0', 'command' => proc{
      puts "to \@FSM set MouthScale = 0"; STDOUT.flush
    }
    add 'command', 'label' => 'MouthScale 20', 'command' => proc{
      puts "to \@FSM set MouthScale = 20"; STDOUT.flush
    }
    add 'command', 'label' => 'MouthScale 25', 'command' => proc{
      puts "to \@FSM set MouthScale = 25"; STDOUT.flush
    }
    add 'command', 'label' => 'MouthScale 30 (normal)', 'command' => proc{
      puts "to \@FSM set MouthScale = 30"; STDOUT.flush
    }
    add 'command', 'label' => 'MouthScale 35', 'command' => proc{
      puts "to \@FSM set MouthScale = 35"; STDOUT.flush
    }

    add 'command', 'label' => 'AgentRot Init', 'command' => proc{
      puts "to \@FSM set AgentRot = 0.0 0.0 0.0"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentRot Up', 'command' => proc{
      puts "to \@FSM set AgentRot = -5.0 0.0 0.0"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentRot Down', 'command' => proc{
      puts "to \@FSM set AgentRot = 5.0 0.0 0.0"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentRot Left', 'command' => proc{
      puts "to \@FSM set AgentRot = 0.0 -5.0 0.0"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentRot Right', 'command' => proc{
      puts "to \@FSM set AgentRot = 0.0 5.0 0.0"; STDOUT.flush
    }

    add 'command', 'label' => 'AgentTrans None', 'command' => proc{
      puts "to \@FSM set AgentTrans = 0.0 0.0"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentTrans Up', 'command' => proc{
      puts "to \@FSM set AgentTrans = 0.0 0.2"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentTrans Down', 'command' => proc{
      puts "to \@FSM set AgentTrans = 0.0 -0.2"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentTrans Left', 'command' => proc{
      puts "to \@FSM set AgentTrans = -0.2 0.0"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentTrans Right', 'command' => proc{
      puts "to \@FSM set AgentTrans = 0.2 0.0"; STDOUT.flush
    }

    add 'command', 'label' => 'AgentScale 0.7', 'command' => proc{
      puts "to \@FSM set AgentScale = 0.7"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentScale 1.0', 'command' => proc{
      puts "to \@FSM set AgentScale = 1.0"; STDOUT.flush
    }
    add 'command', 'label' => 'AgentScale 1.2', 'command' => proc{
      puts "to \@FSM set AgentScale = 1.2"; STDOUT.flush
    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "Mask"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'man01', 'command' => proc{
      puts "to \@AM-MCL set Mask = man01"; STDOUT.flush
    }
    add 'command', 'label' => 'man02', 'command' => proc{
      puts "to \@AM-MCL set Mask = man02"; STDOUT.flush
    }
    add 'command', 'label' => 'koizumi', 'command' => proc{
      puts "to \@AM-MCL set Mask = koizumi"; STDOUT.flush
    }
    add 'command', 'label' => 'woman01', 'command' => proc{
      puts "to \@AM-MCL set Mask = woman01"; STDOUT.flush
    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "FaceExp"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'AutoMove ON', 'command' => proc{
      puts "to \@FS-MCL set AutoMove = 1"; STDOUT.flush
    }
    add 'command', 'label' => 'AutoMove OFF', 'command' => proc{
      puts "to \@FS-MCL set AutoMove = 0"; STDOUT.flush
    }

    add 'command', 'label' => 'Neutral', 'command' => proc{
      puts "to \@FS-MCL set Emotion = NEUTRAL"; STDOUT.flush
    }
    add 'command', 'label' => 'Happy', 'command' => proc{
      puts "to \@FS-MCL set Emotion = HAPPY 90"; STDOUT.flush
    }
    add 'command', 'label' => 'Disgusted', 'command' => proc{
      puts "to \@FS-MCL set Emotion = DISGUSTED 90"; STDOUT.flush
    }
    add 'command', 'label' => 'Sad', 'command' => proc{
      puts "to \@FS-MCL set Emotion = SAD 90"; STDOUT.flush
    }
    add 'command', 'label' => 'Angry', 'command' => proc{
      puts "to \@FS-MCL set Emotion = ANGRY 90"; STDOUT.flush
    }
    add 'command', 'label' => 'Surprised', 'command' => proc{
      puts "to \@FS-MCL set Emotion = SURPRISED 30"; STDOUT.flush
    }
    add 'command', 'label' => 'Feared', 'command' => proc{
      puts "to \@FS-MCL set Emotion = FEARED 90"; STDOUT.flush
    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "FaceRotate"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Center', 'command' => proc{
      puts "to \@FS-MCL set Rot = 0 0 0"; STDOUT.flush
    }

    add 'command', 'label' => 'Up', 'command' => proc{
      puts "to \@FS-MCL set Rot = -5 0 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Down', 'command' => proc{
      puts "to \@FS-MCL set Rot = 5 0 0"; STDOUT.flush
    }

    add 'command', 'label' => 'Left+', 'command' => proc{
      puts "to \@FS-MCL set Rot = 0 -15 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Left', 'command' => proc{
      puts "to \@FS-MCL set Rot = 0 -7 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Right', 'command' => proc{
      puts "to \@FS-MCL set Rot = 0 7 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Right+', 'command' => proc{
      puts "to \@FS-MCL set Rot = 0 15 0"; STDOUT.flush
    }
    add 'command', 'label' => 'EyeRot Left', 'command' => proc{
      puts "to \@FS-MCL set EyeRot = 0 -10 0"; STDOUT.flush
    }
    add 'command', 'label' => 'EyeRot Center', 'command' => proc{
      puts "to \@FS-MCL set EyeRot = 0 0 0"; STDOUT.flush
    }
    add 'command', 'label' => 'EyeRot Right', 'command' => proc{
      puts "to \@FS-MCL set EyeRot = 0 10 0"; STDOUT.flush
    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "Demo"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'MoveMouth', 'command' => proc{
      puts 'to @AM-MCL set MoveMouth = scale 100 k 100 o 85 N 90 n 25 i 60 ch 105 i 50 w 50 a 95'; STDOUT.flush
    }
    add 'command', 'label' => 'Say Hello', 'command' => proc{
      puts 'to @AM-MCL set Speak = ˤϡ'; STDOUT.flush
    }
    add 'command', 'label' => 'Say Bye', 'command' => proc{
      puts 'to @AM-MCL set Speak = 褦ʤ顣'; STDOUT.flush
    }
    add 'command', 'label' => 'Use PAR', 'command' => proc{
      puts 'to @PAR set Init = 1'
      puts 'to @PAR set Cmd = sleep 1.0'
      puts 'to @PAR set Cmd = to @FS-MCL set Emotion = HAPPY'
      puts 'to @PAR set Cmd = sleep 1.4'
      puts 'to @PAR set Cmd = to @FS-MCL set Emotion = SAD'
      puts 'to @PAR set Cmd = sleep 2.0'
      puts 'to @PAR set Cmd = to @FS-MCL set Emotion = NEUTRAL'
      puts 'to @PAR set Cmd = to @FSM set FaceMot = NOD 1'
      puts 'to @AM-MCL set Speak = ˤϡ줷Ȥ⡢ᤷȤ⡢ޤ'
      STDOUT.flush
    }
    add 'command', 'label' => 'Use SND', 'command' => proc{
      puts "to \@SND set Play = /usr/share/sndconfig/sample.au"
      STDOUT.flush
    }
    add 'command', 'label' => 'SSM 12345', 'command' => proc{
      puts "to \@SSM set Text = 12345"
      puts "to \@SSM set Speak = NOW"
      STDOUT.flush
    }
	

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

$gram  = '<grammar version="1.0">'

$gram += '<rule id="S"> <ruleref uri="NS_B"/> <ruleref uri="root"/> <ruleref uri="NS_E"/> </rule>'
$gram += '<rule id="NS_B"><token phoneme="silB;">silB:</token></rule>'
$gram += '<rule id="NS_E"><token phoneme="silE;">silE:</token></rule>'
$gram += '<rule id="SP"><token phoneme="sp;">sp:</token></rule>'

$gram += '<rule id="root">'
$gram += ' <ruleref uri="sent"/>'
$gram += '</rule>'
$gram += '<rule id="root">'
$gram += ' <ruleref uri="pre"/> <ruleref uri="SP"/> <ruleref uri="sent"/>'
$gram += '</rule>'
$gram += '<rule id="root">'
$gram += ' <ruleref uri="pre"/> <ruleref uri="SP"/> <ruleref uri="sent"/> <ruleref uri="post"/>'
$gram += '</rule>'
$gram += '<rule id="root">'
$gram += ' <ruleref uri="sent"/> <ruleref uri="post"/>'
$gram += '</rule>'

$gram += '<rule id="pre"> <ruleref uri="pre1"/> </rule>'
$gram += '<rule id="pre"> <ruleref uri="pre2"/> </rule>'
$gram += '<rule id="post"> <ruleref uri="post1"/> </rule>'
$gram += '<rule id="post"> <ruleref uri="post2"/> </rule>'

$gram += '<rule id="pre1"><token phoneme="a:;">:</token></rule>'
$gram += '<rule id="pre2"><token phoneme="e:;">:</token></rule>'
$gram += '<rule id="post1"><token phoneme="d;e;s;">Ǥ:</token></rule>'
$gram += '<rule id="post2"><token phoneme="o;n;e;g;a;i;sh;i;m;a;s;u;">ꤤޤ:</token></rule>'

$gram += '<rule id="sent"><ruleref uri="g1"/></rule>'
$gram += '<rule id="sent"><ruleref uri="g2"/></rule>'
$gram += '<rule id="sent"><ruleref uri="rule_coffee"/></rule>'
$gram += '<rule id="sent"><ruleref uri="rule_tea"/></rule>'

$gram += '<rule id="g1"> <token phoneme="h;a;i;" sym="Ϥ">Ϥ</token> </rule>'
$gram += '<rule id="g2"> <token phoneme="i:;e;" sym=""></token> </rule>'
$gram += '<rule id="rule_coffee"> <token phoneme="k;o:;h;i:;" sym="ҡ">ҡ</token> </rule>'
$gram += '<rule id="rule_tea"> <token phoneme="k;o:;ch;a;" sym=""></token> </rule>'

$gram += '</grammar>'

TkMenubutton.new(menubar) { |mb|
  text "SRM"
  menu TkMenu.new(mb) {

    add 'command', 'label' => 'Response ON', 'command' => proc{
      puts "set RecogResponse = 1"; STDOUT.flush
    }

    add 'command', 'label' => 'Recsponse OFF', 'command' => proc{
      puts "set RecogResponse = 0"; STDOUT.flush
    }

    add 'command', 'label' => 'Start', 'command' => proc{
      puts "to \@SIM set SRM_Recog = START"
      puts "to \@SIM set SRM_XML_String = " + $gram
      STDOUT.flush
    }

    add 'command', 'label' => 'XML renraku', 'command' => proc{
      puts "to \@SIM set SRM_XML_File = GramXML/renraku/renraku.xml"
      STDOUT.flush
      # ȯáֹ夵Ϣ򶵤Ʋ
    }
    add 'command', 'label' => 'XML string', 'command' => proc{
      puts "to \@SIM set SRM_XML_String = " + $gram
      STDOUT.flush
      # ȯá֤Ϥ
    }
    add 'command', 'label' => 'Julian vfr', 'command' => proc{
      puts "to \@SIM set SRM_Julian = GramJulian/vfr/vfr"
      STDOUT.flush
      # ȯá־ˤƤ
    }
    add 'command', 'label' => 'Julian name', 'command' => proc{
      puts "to \@SIM set SRM_Julian = GramJulian/attendant/name"
      STDOUT.flush
      # ȯá־󤪴ꤤޤ
    }

    add 'command', 'label' => 'Pause', 'command' => proc{
      puts "to \@SRM set Run = PAUSE"
      STDOUT.flush
    }
    add 'command', 'label' => 'Resume', 'command' => proc{
      puts "to \@SRM set Run = RESUME"
      STDOUT.flush
    }
    add 'command', 'label' => 'Stop', 'command' => proc{
      puts "to \@SRM set Run = STOP"
      STDOUT.flush
    }

    add 'command', 'label' => 'AddGram', 'command' => proc{
      puts "to \@SIM set AddGramName = hello"
      puts "to \@SIM set AddGram = " + $gram
      STDOUT.flush
    }

    add 'command', 'label' => 'DeactivateGram', 'command' => proc{
      puts "to \@SIM set DeactivateGram = hello"
      STDOUT.flush
    }

    add 'command', 'label' => 'ActivateGram', 'command' => proc{
      puts "to \@SIM set ActivateGram = hello"
      STDOUT.flush
    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

frame_toolbar = TkFrame.new {
  pack('fill' => 'x')
}

# -------------

$syslog = nil
$applog = nil
$start_day = Time.now.to_f

class MON < GalateaBase
  def initialize
    super
    @modulename = "MON"
    @debug = false

    @myslot["Run"] = "LIVE"

    @applog_disp = Array.new
    @syslog_disp = Array.new
  end
  
  def add_applog(arg)
    @applog_disp.push(arg)
    if @applog_disp.length > $applog_height then @applog_disp.delete_at(0) end
    str = ''
    @applog_disp.each do |i| str += i; str += "\n" end
    unless $applog.nil? then
      $applog.delete '1.0', 'end'
      $applog.insert 'end', str
    end
  end


  def add_syslog(arg)
    @syslog_disp.push(arg)
    if @syslog_disp.length > $syslog_height then @syslog_disp.delete_at(0) end
    str = ''
    @syslog_disp.each do |i| str += i; str += "\n" end
    unless $syslog.nil? then
      $syslog.delete '1.0', 'end'
      $syslog.insert 'end', str
    end
  end


  def do_set(slot, arg)
    super

    if slot == "AppLogText"
#      add_applog(arg)
    elsif slot == "SysLogText"
#      add_syslog(arg)
    elsif slot == "Run" && arg =="EXIT"
      Process.exit!(0)

    end

  end

end

# -------------

begin
  Thread.start do
    MON.new.run
  end

  # -------------
  
#  frame1 = TkFrame.new { 
#    pack('side'=>'top', 'fill'=>'both', 'expand'=>'true') 
#  }
#  
#  #$bar1 = TkScrollbar.new(frame1) {
#  #  pack('side'=>'right', 'fill'=>'y')
#  #}
#  $applog = TkText.new(frame1) {
#    wrap 'none'
#    height $applog_height
#    pack('side'=>'left', 'fill'=>'both', 'expand'=>'true')
#    #  insert 'end', "[AppLog]\n"
#  }
#  #$applog.yscrollbar($bar1) 
  
  # -------------
  
#  frame2 = TkFrame.new { 
#    pack('side'=>'top', 'fill'=>'both', 'expand'=>'true') 
#  }
#  
#  #$bar2 = TkScrollbar.new(frame2) {
#  #  pack('side'=>'right', 'fill'=>'y')
#  #}
#  $syslog = TkText.new(frame2) {
#    wrap 'none'
#    height $syslog_height
#    pack('side'=>'left', 'fill'=>'both', 'expand'=>'true')
#    #  insert 'end', "[SysLog]\n"
#  }
#  #$syslog.yscrollbar($bar2) 
  
  # -------------
  
  Tk.root.title("MON")
  Tk.mainloop

  # -------------
rescue
  Process.exit!(1)
end

# end of file
