####################################################
#
# config file for SRM-0.5
#

#
# SRM runtime configurations
#
%CONF = (
	 # debug message level: verbose output if set to 1
	 "DEBUG_LEVEL" => "0",

	 # engine-dependent module script name (current: SRM_Julian.pl only)
	 "ENGINE_MODULE" => "SRM_Julian.pl",
	 # default initial command set file (can be overridden by command line)
	 "SRM_INIT" => "srm.init",

	 # Julian: executable binary
	 "JULIAN_BIN" => "./bin/julian",
	 # Julian: module-control port number (default: 5506)
	 "JPORT" => "5506",
	 # Julian: output debug log to this file
	 "LOG_JULIAN" => "/data/istc/temp/julian.log",

	 # Perl module for grammar format converter (XML -> Julian) 
	 "XML2JULGRM" => "xml2julgrm.pl",
	 # temporary grammar file prefix
	 "TMP_GRAMMAR_PREFIX" => "/data/istc/temp/_tmpgrammar",

	 # XSLT executable & stylesheet
	 "XSLT_PROCESSOR" => "org.apache.xalan.xslt.Process",
	 "XSL_STYLE" => "./xml2julgrm.xsl",
	 # Java runtime environment
	 "JAVA_BIN" => "/usr/java/jdk1.5.0_05/bin/java",
	 # where Xalan and Xerces exists (from apache project)
	 "CLASSPATH" => "./xalan.jar:./xerces.jar",
	 # XML DTD
	 "XML_DTD" => "xmlsrg-ipa.dtd",
	 # Julian grammar compiler
	 "MKDFA" => "bin/mkdfa.pl",
	 # output log to these files
	 "LOG_XML2JULGRM" => "/data/istc/temp/xslt.log",
	 "LOG_JULGRM2DFA" => "/data/istc/temp/mkdfa.log"
	 );

#
# Julian internal default parameters (will be overridden by SRM_INIT initfile)
#
%optval = ("-h" => "phone_m/binhmm.mono16",
	   "-b" => "200",
	   "-b2" => "30",
	   "-s" => "500",
	   "-m" => "1000",
	   "-lookuprange" => "5",
	   "-tmix" => "2",
	   "-n" => "5",
	   "-progout" => "10",
	   "-walign" => "OFF",
	   "-palign" => "OFF",
	   "-input" => "mic",
	   "-lv" => "2000",
	   "-outcode" => "wlpsWLPSC"
	   );

1;
