############################################################
#
# Speech Recognition Sub Module for Julian
#
#  by speech recognition group, IPA agent project
#
#  Ver.0.0  (2001/06/25) (internal) initial version, "inq Options" added
#  Ver.0.1  (2001/06/??) (internal) initial interaction with julian
#  Ver.0.2  (2001/07/04) (internal) alpha release
#  Ver.0.3  (2001/07/09) initial public release
#  Ver.0.4  (2002/01/29) (internal) support for switching grammars
#  Ver.0.5  (2002/02/11) (internal) support for XML-format grammar ; added by A.Kai
#  Ver.0.6  (2003/01/30) update with julius-3.3p3-Galatea
#
# developed on perl version 5.005_03 built for i386-linux
# and julian/julius version 3.3p3-Galatea
#

use strict;
use IO::Socket;
use Fcntl;

my($version) = "0.6";

############################################################
#
# site defaults
#

# read in config variables
require "SRM_Config.pl";
use vars qw ( %CONF );

# Julian executable
my($julianbin) = $CONF{"JULIAN_BIN"};
# raw output log of julian 
my($logfile) = $CONF{"LOG_JULIAN"};
# (for debug) set to 1 to see julian raw output to stdout
my($debug) = $CONF{"DEBUG_LEVEL"};

# Sub module for grammar format converter (XML -> Julian)
my( $xml2julgrm ) = $CONF{"XML2JULGRM"};
my( $xmldtd) = $CONF{"XML_DTD"};

require $xml2julgrm;

# by nishi begin
my $modlogfile = './temp/module.log'; 
my $modlogfp = IO::Handle->new();
open($modlogfp,">$modlogfile");
# by nishi end

############################################################
#
# global variables
#

# these values are shared with SRM_Main.pl
%SLOT = ();	# slot
%PROPERTY = ();	# slot property 

# default option values (switch options has value of ON/OFF)
use vars qw ( %optval );

# correspondence of "set" commands to Julian option name (with arg type)
my( %set2opt ) = ("AcousticModel.hmm" => "-h:file",
		  "AcousticModel.imp" => "-hlist:file",
		  "Grammar" => "-dfa:file",
		  "Grammer" => "-dfa:file", # ver.0 spec. typo
		  "Dic" => "-v:file",
		  "Param.beam1" => "-b:int",
		  "Param.beam2" => "-b2:int",
		  "Param.stack" => "-s:int",
		  "Param.overflow" => "-m:int",
		  "Param.lookuprange" => "-lookuprange:int",
		  "Param.gauss" => "-tmix:int",
		  "Output.nbest" => "-n:int",
		  "Output.word" => "-outcode:sw_W",
		  "Output.LMword" => "-outcode:sw_L",
		  "Output.phone" => "-outcode:sw_P",
		  "Output.score" => "-outcode:sw_S",
		  "Output.pass1word" => "-outcode:sw_w",
		  "Output.pass1LMword" => "-outcode:sw_l",
		  "Output.pass1phone" => "-outcode:sw_p",
		  "Output.pass1score" => "-outcode:sw_s",
		  "Output.pass1prog" => "-progout:sw", 
		  "Output.walign" => "-walign:sw", 
		  "Output.palign" => "-palign:sw", 
		  "Output.pass1progtime" => "-proginterval:int",
		  "Input.from" => "-input:{mfcfile|rawfile|mic|adinnet|netaudio}",
################## by nishi begin
		  "Input.level" => "-lv:int",
		  "Input.headmargin" => "-headmargin:int",
		  "Input.tailmargin" => "-tailmargin:int",
		  "Input.zc" => "-zc:int",
		  "Input.hipass" => "-hipass:int",
		  "Input.lopass" => "-lopass:int",
		  "Input.record" => "-record:file",
		  "Input.adport" => "-adport:int",
		  "Input.rejectshort" => "-rejectshort:int",

		  "Output.confidence" => "-outcode:sw_C",
		  "Param.cmalpha" => "-cmalpha:int",   ## float
		  "Param.penalty1" => "-penalty1:int", ## float
		  "Param.penalty2" => "-penalty2:int"  ## float
################## by nishi end
		  );

# correspondence of "inq" commands to Julian option name
my( %inq2opt ) = ("AcousticModel.hmmfile" => "-h",
		  "AcousticModel.impfile" => "-hlist",
		  "Grammar.file" => "-dfa",
		  "Grammer.file" => "-dfa", # ver.0 spec. typo
		  "Grammar.type" => "-dummy", # added by A.Kai
		  "Dic.file" => "-v",
		  # Dic.type
		  "Param.beam1" => "-b",
		  "Param.beam2" => "-b2",
		  "Param.stack" => "-s",
		  "Param.overflow" => "-m",
		  "Param.lookuprange" => "-lookuprange",
		  "Param.gauss" => "-tmix", # for PTM only
		  "Output.nbest" => "-n",
		  "Output.word" => "-outcode:sw_W",
		  "Output.LMword" => "-outcode:sw_L",
		  "Output.phone" => "-outcode:sw_P",
		  "Output.score" => "-outcode:sw_S",
		  "Output.pass1word" => "-outcode:sw_w",
		  "Output.pass1LMword" => "-outcode:sw_l",
		  "Output.pass1phone" => "-outcode:sw_p",
		  "Output.pass1score" => "-outcode:sw_s",
		  "Output.pass1prog" => "-progout", 
		  "Output.walign" => "-walign", 
		  "Output.palign" => "-palign", 
		  "Output.pass1progtime" => "-proginterval",
		  "Input.from" => "-input",
################## by nishi begin
		  "Input.level" => "-lv:int",
		  "Input.headmargin" => "-headmargin:int",
		  "Input.tailmargin" => "-tailmargin:int",
		  "Input.zc" => "-zc:int",
		  "Input.hipass" => "-hipass:int",
		  "Input.lopass" => "-lopass:int",
		  "Input.record" => "-record:file",
		  "Input.adport" => "-adport:int",
		  "Input.rejectshort" => "-rejectshort:int",

		  "Output.confidence" => "-outcode:sw_C",
		  "Param.cmalpha" => "-cmalpha:int",   ## float
		  "Param.penalty1" => "-penalty1:int", ## float
		  "Param.penalty2" => "-penalty2:int"  ## float
################## by nishi end
		  );

# response to common inquery (except "Run") and their values
my ( %commoninq ) = ("ProtocolVersion" => "Protocol Ver. 0",
		     "ModuleVersion" => "Speech Recognition Module (Julian) Ver. $version");

# global variables for grammar types; added by Kai.
my( %grammartype ) =  ( ".dfa" => "Julian-DFA",
			".xml" => "IPA-SRG-XML"
			);
# default grammar file prefix
my( $default_grammarprefix ) = $CONF{"TMP_GRAMMAR_PREFIX"};

#############################################################
#
# misc global values
#

my ( $module_status ) = "DEAD";	# module status
my ( $julian_socket );		# accepted socket to communicate with julian
my ( $jport ) = $CONF{"JPORT"};		# comminucation port number
my ( $jpid );			# process ID of julian
my ( %modified );

#############################################################
#
# handle "set" command
# 
# return value: 0 for error, other for success
#
# when this function is called from SRM_Main.pl, the slot value
# "$SLOT{$slot}" is already set to $value.
# you can modify the slot value within this script.
#
sub SubCall_Set{
    my($slot, $value) = @_;
    my($optstr, $type, $grmhead);

    if ($set2opt{$slot} ne "") {	# julian option values
	if ($set2opt{$slot} eq "??") { # not implemented yet
	    print_tell("400 not implemented slot $slot\n");
	    return 0;
	}
	($optstr, $type) = split(/:/, $set2opt{$slot});
	if ($type eq "file") {	# file arg
#	    if (! -f $value) {	# not exist
#		print_tell("400 no such file $value\n");
#		return 0;
#	    }
	    $optval{$optstr} = $value;
	    if ($slot eq "AcousticModel.hmm") {
		$SLOT{"AcousticModel.hmmfile"} = $value;
	    }
	    if ($slot eq "AcousticModel.imp") {
		$SLOT{"AcousticModel.impfile"} = $value;
	    }
	    if ($slot eq "Grammar" || $slot eq "Grammer") {
		$value =~ /^\s*([^\s]*)\s*/;
		$grmhead = $1;
		if ($grmhead =~ /\.dfa$/){
		    $SLOT{"Grammar.type"} = $grammartype{".dfa"};
		}
		elsif ($grmhead =~ /\.xml$/ || $grmhead =~ /^<\?xml/i){
		    $SLOT{"Grammar.type"} = $grammartype{".xml"};
	            $SLOT{"Dic.file"} = "";
		}
		else {
		    # print_tell("400 unsupported speech recognition grammar format: $grmhead\n");
		    # return 0;

		    # by nishi begin
		    if (defined($julian_socket)) {
			if (! open(GRAM, "$grmhead.dfa")) {
			    print_tell("400 grammar file $grmhead.dfa not found\n");
			    return 0;
			}
			if (! open(DICT, "$grmhead.dict")) {
			    print_tell("400 dict file $grmhead.dict not found\n");
			    close(GRAM);
			    return 0;
			}
			send_command_julian("CHANGEGRAM");
			while(<GRAM>) {
			    send_data_julian($_);
			}
			send_data_julian("DFAEND\n");
			while(<DICT>) {
			    send_data_julian($_);
			}
			send_data_julian("DICEND\n");
			print_tell("100 grammar send complete.\n");
			close(GRAM);
			close(DICT);
			send_command_julian("RESUME");
		    }
		    # by nishi end
		    
		}
		if ($grmhead =~ /^<\?xml/i){
		    $grmhead = $default_grammarprefix . ".xml";
		    if ( !open(XML, "> $grmhead") ){
			print_tell("400 cannot open internal XML-grammar file: $grmhead\n");
			return 0;
		    }
		    print XML $value;
		    close( XML );
		    # 02/02/22 by ri: copy DTD to temp
		    system("cp $xmldtd `dirname $default_grammarprefix`");
	            $SLOT{"Grammar.file"} = $grmhead;
		}
		else {
	            $SLOT{"Grammar.file"} = $value;
		}
		if ($SLOT{"Grammar.type"} eq $grammartype{".xml"}) {
		    $grmhead =~ s/(.*)\.xml/$1/;
		    print_tell("100 grammar is now converted to Julian format...\n");
		    if (&convertGrammar($grmhead) != 0){
			print_tell("400 grammar conversion failed.\n");
			return 0;
		    }
		    print_tell("100 grammar conversion complete.\n");
		    $optval{$optstr} = $grmhead . ".dfa";
		    print_debbug("optval $optstr =" . $optval{$optstr} . "\n");
		    ($optstr, $type) = split(/:/, $set2opt{"Dic"});
		    $optval{$optstr} = $grmhead . ".dict";
		    print_debbug("optval $optstr =" . $optval{$optstr} . "\n");
		    if (defined($julian_socket)) {
		        $modified{"grammar"} = 1;
		        $modified{"dict"} = 1;
		        &change_gram_julian;
		    }
		}
		elsif (defined($julian_socket)) {
		    $modified{"grammar"} = 1;
		    &change_gram_julian;
		}
	    }
	    if ($slot eq "Dic") {
		$SLOT{"Dic.file"} = $value;
		if (defined($julian_socket)) {
		    $modified{"dict"} = 1;
		    &change_gram_julian;
		}
	    }
	} elsif ($type eq "int") { # integer arg
	    $optval{$optstr} = $value;
	} elsif ($type eq "sw") { # for option with no arg: ON / OFF
	    if ($value ne "ON" && $value ne "OFF") {
		print_tell("400 invalid value $value\n");
		return 0;
	    }
	    $optval{$optstr} = $value;
	} elsif ($type =~ /^sw_(.*)$/) { # add/remove char (for "-outcode")
	    my ($val) = $1;
	    if ($value eq "ON") {
		unless ($optval{$optstr} =~ /$val/) {
		    $optval{$optstr} .= $val;
		}
	    } elsif ($value eq "OFF") {
		$optval{$optstr} =~ s/$val//g;
	    } else {
		print_tell("400 invalid value $value\n");
		return 0;
	    }
	} elsif ($type =~ /^\{.*\}$/) {	# selection arg
	    if (grep(/^($value)$/, split(/[\{\}\|]/, $type)) == 0) {
		print_tell("400 invalid value $value\n");
		return 0;
	    }
	    $optval{$optstr} = $value;
	}
    } elsif ($slot eq "Run") {
	if($value eq "INIT"){ # prepare for service 
	    # does not "LIVE" before initialize success (2002/02/11 ri)
	    #$module_status = "LIVE";
	} elsif ($value eq "EXIT"){ # stop for service
	    &stop_julian;	# terminate julian process
	    $module_status = "DEAD";
	} elsif ($value eq "START") {
	    $module_status = "LIVE"; # ensure the module is alive
	    &start_julian;	# spawn julian
	} elsif ($value eq "PAUSE") {
	    &pause_julian;
	} elsif ($value eq "TERMINATE") {
	    &terminate_julian;
	} elsif ($value eq "RESUME") {
	    &resume_julian;
	} elsif ($value eq "STOP") {
	    &stop_julian;
	} else {		# invalid value
	    print_tell("400 invalid value $value\n");
	    return 0;
	}
#
# by nishi begin
#
#    } elsif ($slot eq "ConvertGrammar") {
#	if (&convertGrammar($value) != 0){
#	    print_tell("400 grammar conversion failed.\n");
#	    return 0;
#	}
#	print_tell("200 grammar conversion complete.\n");
#
    } elsif ($slot eq "ChangeGram") {
	_send_gram_julian("CHANGEGRAM", $value);

    } elsif ($slot eq "AddGram") {
	_send_gram_julian("ADDGRAM", $value);

    } elsif ($slot eq "DelGram") {
	if (send_data_julian("DELGRAM\n") == 0) {
	    print_tell("400 DELGRAM error\n");
	    return 0;
	}
	if (send_data_julian("$value\n") == 0) {
	    print_tell("400 DELGRAM error\n");
	    return 0;
	}
    } elsif ($slot eq "DeactivateGram") {
	if (send_data_julian("DEACTIVATEGRAM\n") == 0) {
	    print_tell("400 DEACTIVATEGRAM error\n");
	    return 0;
	}
	if (send_data_julian("$value\n") == 0) {
	    print_tell("400 DEACTIVATEGRAM error\n");
	    return 0;
	}
    } elsif ($slot eq "ActivateGram") {
	if (send_data_julian("ACTIVATEGRAM\n") == 0) {
	    print_tell("400 ACTIVATEGRAM error\n");
	    return 0;
	}
	if (send_data_julian("$value\n") == 0) {
	    print_tell("400 ACTIVATEGRAM error\n");
	    return 0;
	}
    } elsif ($slot eq "InputOnChange") {
	if (send_data_julian("INPUTONCHANGE\n") == 0) {
	    print_tell("400 INPUTONCHANGE error\n");
	    return 0;
	}
	if (send_data_julian("$value\n") == 0) {
	    print_tell("400 INPUTONCHANGE error\n");
	    return 0;
	}
#
# by nishi end
#
    } else {			# unknown slot
	print_tell("400 invalid slot $slot\n");
	return 0;
    }
}

#############################################################
#
# handle "inq" command
# 
# return value: result string, "" for error (unknown slot)
#
sub SubCall_Inq{
    my($slot) = @_;
    my($ret);

    # common inquery for all modules
    if ($slot eq "Run") {
	$ret = $module_status;
    } elsif ($commoninq{$slot} ne "") {
	$ret = $commoninq{$slot};
    # SRM-specific inq
    } elsif ($slot eq "Run.process") {
	if (defined($julian_socket)) { # julian is running
	    send_command_julian("STATUS"); # tell julian to respond
	    $ret = "";
	} else {		# julian is dead
	    $ret = "SLEEP";
	}
    } elsif ($slot eq "Options") { # undocumentd option (for debug)
	$ret = &optval2comarg;
    } elsif ($inq2opt{$slot} ne "") {
	if ($set2opt{$slot} eq "??") { # not implemented yet
	    print_tell("400 not implemented slot $slot\n");
	    $ret = "";
	} else {
	    # instead of real option value, return them on the slot
	    $ret = $SLOT{$slot};
	}
    } else {			# unknown slot
	print_tell("400 invalid slot $slot\n");
	$ret = "";
    }
    return($ret);
}

#############################################################
#############################################################
#
# control Julian
#
# communicate with recognition engine via socket
#
# command and response are handled asynchronously:
#   SRM_Julian.pl -> Julian: use "send_command_julian(COMMAND)"
#   Julian -> SRM_Julian.pl: handled in "SubCall_ProcessOutput()"
#            (output socket polled at process_input() in SRM_Main.pl)
# 
#############################################################
#############################################################

#############################################################
#
# process and re-form output of recognition engine
# (called from SRM_Main.pl)
#

sub SubCall_ProcessOutput {
    my($str, $allstr);
    my($sysinfo, $sysmes);
    # receive string (allow multiple commands)
    $allstr = "";

    # by nishi begin
    # $modlogfp->print("SubCall_ProcessOutput begin.\n");
    $modlogfp->flush();
    # by nishi end

    while ( $allstr !~ /\n\.\n/) {
	while(<$julian_socket>) {
	    $allstr .= $_;

	    # by nishi begin
	    $modlogfp->print("$_");
	    $modlogfp->flush();
	    # by nishi end
	}
    }
    foreach $str (split(/\n\.\n/, $allstr)) {
# modified by nishi 
	# process the output
# 	if ($str =~ /<SYSINFO PROCESS=\"(.*)\"( MESSAGE=\"(.*)\")?\/>/) { # status output
# 	    $sysinfo = $1; $sysmes = $3;
# 	    if ($sysinfo eq "ERREXIT") {
# 		print_tell("400 recognizer exited by error: $sysmes\n");
# 		&close_julian;
# 	    } else {
# 		print_rep("$sysinfo\n");
# 	    }
 	if ($str =~ /<SYSINFO PROCESS=\"ERREXIT\"/) {
	    print_tell("400 recognizer exited by error: $str\n");
	    &close_julian;
	} elsif ($str =~ /LISTEN/) {
	    $str =~ s/\n//g;
	    print_tell("201 $str\n");
	} else {			# recognition result and input status
	    $str =~ s/\n//g;
	    print_tell("100 $str\n");
# by nishi end
	}
    }
    
    # by nishi begin
    # $logfp->print("SubCall_ProcessOutput end.\n");
    $modlogfp->flush();
    # by nishi end

}
#############################################################
#
# return if the SRM sub-module is ready and running
# (called from SRM_Main.pl)
#
sub SubCall_OutputAlive {
    if (defined($julian_socket)) {
	return 1;
    }
    return 0;
}
#############################################################
#
# return the socket handler of SRM sub-module
# (called from SRM_Main.pl)
#
sub SubCall_OutputHandler {
    return($julian_socket);
}

#############################################################
#
# send command to Julian
#
sub send_command_julian {
# print $julian_socket "@_\n"; # commands should be separated with "\n"
# by nishi
    if (defined($julian_socket)) {
	print $julian_socket "@_\n"; # commands should be separated with "\n"
	return 1;
    }
    return 0;
}
sub send_data_julian {
#    print $julian_socket "@_"; # send raw data
# by nishi
    if (defined($julian_socket)) {
	print $julian_socket "@_"; # send raw data
	return 1;
    }
    return 0;
}
#############################################################
#
# startup julian sub-process
#
sub start_julian {
    my($comarg);
    my($oldfh);
    my($sockaddr);
    my($count);

    if (defined($julian_socket)) { # already started
	print_tell("400 recognizer already running\n");
    } else {
	# make command arguments from optval
	$comarg = &optval2comarg . "-module $jport";
	# start julian in module mode
	$comarg .= " > $logfile 2>&1" if ($debug != 1);
	$jpid = fork;
	if ($jpid == 0){
## by nishi begin
	    print_debbug("$julianbin $comarg\n");
## by nishi end
	    exec ("$julianbin $comarg");
	}
	# connect to the julian process
	$count = 0;
	while ($count < 100) {
## by nishi begin
	    print_debbug("connecting $count ...\n");
## by nishi end

	    $julian_socket = IO::Socket::INET->new(PeerAddr => "localhost",
						   PeerPort => $jport,
						   Proto     => 'tcp',
						   TimeOut   => '5',
						   Reuse     => 1);

## by nishi begin
	    print_debbug("connecting #2 ...\n");
## by nishi end
	    last if ($julian_socket);
	    #sleep(0.05);
	    select(undef,undef,undef,0.05);
	    $count ++;
	}
	if (! $julian_socket) {	# time out (0.05 x 100 = 5 sec)
	    print_tell("400 cannot connect, engine startup failed\n");
	    return;
	}
## by nishi begin
	print_debbug("connected.\n");
## by nishi end
	# set non-blocking
	$oldfh = select($julian_socket); $| = 1; select($oldfh);
	unless (fcntl($julian_socket, &F_SETFL, O_NONBLOCK)) {
	    die "can't set as nonblock\n";
	}
    }
}
#############################################################
#
# close connection
#
sub close_julian {    # clear socket handler
    close($julian_socket);
    undef($julian_socket);
}

#############################################################
#
# kill the julian sub-process
#
sub stop_julian {
    # kill julian
    if (defined($julian_socket)) {
	# send 'die' command to julian
	send_command_julian("DIE");
	close($julian_socket);
	undef($julian_socket);
    }
}
#############################################################
#
# julian command: pause recognition
# if recognition is running at that time, wait till the recognition finishes
#
sub pause_julian {
    send_command_julian("PAUSE");
}
#############################################################
#
# julian command: terminate recognition
# recognition will be paused as soon as this command is received
#
sub terminate_julian {
    send_command_julian("TERMINATE");
}
#############################################################
#
# julian command: resume recognition
# resume the paused/terminated recognition process
#
sub resume_julian {
    send_command_julian("RESUME");
}
#############################################################
#
# julian command: change grammar file
#
sub change_gram_julian {
    my($optstr, $type, $gram, $dic);

    ($optstr, $type) = split(/:/, $set2opt{"Grammar"});
    $gram = $optval{$optstr};
    ($optstr, $type) = split(/:/, $set2opt{"Dic"});
    $dic = $optval{$optstr};

    if ($modified{"grammar"} == 1 && $modified{"dict"} == 1) {
	print_tell("100 grammar/dict is now being sent to Julian...\n");
	if (! open(GRAM, "$gram")) {
	    print_tell("400 grammar file \"$gram\" not found\n");
	    return 0;
	}
	if (! open(DICT, "$dic")) {
	    print_tell("400 dict file \"$dic\" not found\n");
	    close(GRAM);
	    return 0;
	}
	send_command_julian("CHANGEGRAM");
	while(<GRAM>) {
	    send_data_julian($_);
	}
	send_data_julian("DFAEND\n");
	while(<DICT>) {
	    send_data_julian($_);
	}
	send_data_julian("DICEND\n");
	print_tell("100 grammar send complete.\n");
	$modified{"grammar"} = 0;
	$modified{"dict"}    = 0;
    }
}

#############################################################
#
# julian command: add grammar file (by nishi)
#
sub _send_gram_julian {
    my($command, $grmhead) = @_;
    my($gram, $dic);
    $gram = $grmhead . ".dfa";
    $dic = $grmhead . ".dict";
    if (! open(GRAM, "$gram")) {
	print_tell("400 grammar file \"$gram\" not found\n");
	return 0;
    }
    if (! open(DICT, "$dic")) {
	print_tell("400 dict file \"$dic\" not found\n");
	close(GRAM);
	return 0;
    }
    if (send_data_julian("$command\n") == 0) {
	print_tell("400 add_gram_julian error\n");
	return 0;
    }
    while(<GRAM>) {
	if (send_data_julian($_) == 0) {
	    print_tell("400 add_gram_julian error\n");
	    return 0;
	}
    }
    if (send_data_julian("DFAEND\n") == 0) {
	print_tell("400 add_gram_julian error\n");
	return 0;
    }
    while(<DICT>) {
	if (send_data_julian($_) == 0) {
	    print_tell("400 add_gram_julian error\n");
	    return 0;
	}
    }
    if (send_data_julian("DICEND\n") == 0) {
	print_tell("400 add_gram_julian error\n");
	return 0;
    }
    return 1;
}



############################################################
#
# make option argument from $optval{}
#
sub optval2comarg {
    my ($com);
    my ($opt);

    $com = "";
    foreach $opt (keys %optval) {
	if ($optval{$opt} eq "OFF") {next;}
	if ($optval{$opt} eq "ON") {
	    $com .= $opt . " ";
	} else {
	    $com .= $opt . " ". $optval{$opt} . " ";
	    # special: add same argument of "-n" to "-output"
	    if ($opt eq "-n") {
		$com .= "-output" . " ". $optval{$opt} . " ";
	    }
	}
    }
    return $com;
}

1;
## end of script ###########################################
