#!/usr/bin/perl

############################################################
#
# for GRM_Julian/Main.pl
#
# (2004/11/xx) modified by Takuya Nishimoto
#
############################################################
#
# XML(IPA-SRG-XML) grammar format converter
# for Julian SRM module.
#
# by Atsuhiko KAI, kai@sys.eng.shizuoka.ac.jp,
# speech recognition group, IPA agent project 
#
#  ver.0.0  (2002/02/08) initial version (Kai,saeda)
#
#  developed on perl version 5.005_03 built for i386-linux
#
############################################################

############################################################
#
# site configurations
#
# read in config variables
# require "config.pl";
require "GRM_Config.pl";
use vars qw ( %CONF );

# XSLT executable & stylesheet
my( $xsltprocessor ) = $CONF{"XSLT_PROCESSOR"};
my( $xslfile ) = $CONF{"XSL_STYLE"};

# Java runtime environment
my( $java ) = $CONF{"JAVA_BIN"};
my( $classpath ) = $CONF{"CLASSPATH"};

# Julian grammar compiler
my( $compiler ) = $CONF{"MKDFA"};

my( $xsltlog ) = $CONF{"LOG_XML2JULGRM"};
my( $compilelog ) = $CONF{"LOG_JULGRM2DFA"};

############################################################
#
# global variables
#

# grammar file ext. for XML & Julian format
my( $fileext_xml ) = ".xml";
my( $fileext_gram ) = ".grammar";
my( $fileext_voca ) = ".voca";
# for temporary output
my( $fileext_tmp ) = ".tmp$$";

## main ####################################################

#my( $fileprefix ) = $ARGV[0];
#
#if ($fileprefix eq "" || $fileprefix =~ /\.[^\/]*$/){
#  print "Usage: $0 <basename>\n";
#  exit 0;
#}
#
#if (convertGrammar( $fileprefix ) != 0){
#  exit 1;
#}
#
#exit 0;

sub convertGrammar{
  my( $fileprefix ) = @_;
  my( $xmlfile, $tmpfile, $gramfile, $vocaflie, $flg );

  $xmlfile = $fileprefix . $fileext_xml;
  $tmpfile = $fileprefix . $fileext_tmp;
  $gramfile = $fileprefix . $fileext_gram;
  $vocafile = $fileprefix . $fileext_voca;

  $ENV{"CLASSPATH"} = $classpath;
  
  if (system( "$java $xsltprocessor -IN $xmlfile -XSL $xslfile -OUT $tmpfile >& $xsltlog" ) != 0){

    if (! open(TMP, "$xsltlog")) {
      print_tell("100 cannot open compile log file: $xsltlog\n");
      return 1;
    }
    while( <TMP> ) {
      print_tell("100 " . $_);
    }
    close( TMP );

    print_tell("100 error in running XSLT processor: $xsltprocessor\n");
    unlink( $tmpfile );
    return 1;
  }

  if (! open(TMP, "$tmpfile")) {
    print_tell("100 cannot open temporary grammar file: $tmpfile\n");
    return 1;
  }
  if (! open(GRM, "> $gramfile")) {
    print_tell("100 cannot open .grammar file: $gramfile\n");
    unlink( $tmpfile );
    close( TMP );
    return 1;
  }
  if (! open(VOC, "> $vocafile")) {
    print_tell("100 cannot open .voca file: $vocafile\n");
    unlink( $tmpfile );
    close( TMP );
    close( GRM );
    return 1;
  }

  while( <TMP> ) {
    @token = split(/\s/);
    if ($token[1] eq ":"){
      print GRM $_;
    }
    elsif ($#token != -1 && $token[0] !~ /^#/){
      print VOC $_;
    }
  }

  close( TMP );
  close( GRM );
  close( VOC );
  unlink( $tmpfile );

  return compileGrammar($fileprefix);
}

sub compileGrammar{
  my( $fileprefix ) = @_;
  my( $ret );

  $ret = system( "$compiler $fileprefix >& $compilelog" );

  if (! open(TMP, "$compilelog")) {
    print_tell("100 cannot open compile log file: $compilelog\n");
    return 1;
  }
  while( <TMP> ) {
    if ($_ =~ /error/){
	print_tell("100 " . $_);
	return 1;
    }
  }
  close( TMP );

  return $ret;
}

## end of script ###########################################
1;
