/*
 * Decompiled with CFR 0.152.
 */
package galatea.agent;

import galatea.agent.Vector3D;

public class Agent {
    private String mask_;
    private String background_;
    private double clock_ = 0.0;
    private double clockHead_ = 0.0;
    private double headMoveNoSpeak_ = 1.0;
    private double headMoveSpeak_ = 0.9;
    private int agentSpeakState_;
    private Vector3D bodyTrans_;
    private Vector3D bodyTransBase_;
    private double bodyScale_;
    private double bodyScaleBase_;
    private Vector3D bodyRot_;
    private Vector3D bodyRotBase_;
    private Vector3D bodyRotTargetDelta_;
    private int bodyRotTargetCount_;
    private Vector3D headRot_;
    private Vector3D headRotBase_;
    private Vector3D headRotTargetDelta_;
    private int headRotTargetCount_;
    private Vector3D eyeRot_;
    private String expType_;
    private String expTypeTarget_;
    private double expLevel_;
    private double expLevelBase_;
    private double expLevelTarget_;
    private double expLevelMax_;
    private double expLevelRange_;
    private Vector3D headRotNodding_;
    private double noddingRange_;
    private int noddingCount_;
    private int noddingCountMax_;
    private double noddingStartClock_;
    private int noddingType_;

    private void _calcNodding() {
        if (this.noddingCount_ > 0) {
            double amp = (double)this.noddingCount_ / (double)this.noddingCountMax_;
            --this.noddingCount_;
            double t = this.clockHead_ - this.noddingStartClock_;
            switch (this.noddingType_) {
                case 1: {
                    double nx = Math.sin(t * 10.0) * this.noddingRange_ * amp;
                    this.headRotNodding_.set(nx, 0.0, 0.0);
                    break;
                }
                case 2: {
                    double nz = Math.sin(t * 10.0) * this.noddingRange_ * amp;
                    this.headRotNodding_.set(0.0, 0.0, nz);
                    break;
                }
            }
        }
    }

    private void _calcHeadMovement() {
        if (this.headRotTargetCount_ > 0) {
            this.headRotBase_.add(this.headRotTargetDelta_);
            --this.headRotTargetCount_;
        }
        this.headRot_.x = this.headRotBase_.x + Math.cos(this.clockHead_ * 0.4) * 0.3 + Math.cos(this.clockHead_ * 4.0) * 0.1;
        this.headRot_.y = this.headRotBase_.y + Math.cos(this.clockHead_ * 0.1) * 0.05 + Math.cos(this.clockHead_ * 4.0) * 0.02;
        this.headRot_.z = this.headRotBase_.z + Math.cos(this.clockHead_ * 0.9) * 0.15 + Math.cos(this.clockHead_ * 3.0) * 0.07;
        this._calcNodding();
        this.headRot_.add(this.headRotNodding_);
        this.headRot_.applyLimitter();
    }

    private void _calcBodyMovement() {
        if (this.bodyRotTargetCount_ > 0) {
            this.bodyRotBase_.add(this.bodyRotTargetDelta_);
            --this.bodyRotTargetCount_;
        }
        this.bodyRot_.x = this.bodyRotBase_.x + Math.cos(this.clock_ * 1.6) * 0.2;
        this.bodyRot_.y = this.bodyRotBase_.y + Math.cos(this.clock_ * 1.2) * 0.1;
        this.bodyTrans_.x = this.bodyTransBase_.x + Math.cos(this.clock_ * 2.5) * 0.001;
        this.bodyTrans_.y = this.bodyTransBase_.y + Math.cos(this.clock_ * 1.5) * 0.001;
        this.bodyScale_ = this.bodyScaleBase_ + Math.cos(this.clock_ * 0.2) * 0.005;
    }

    private void _calcEmotionChange() {
        if (!this.expType_.equals(this.expTypeTarget_)) {
            if (this.expLevelBase_ < 10.0) {
                this.expLevelBase_ = 0.0;
                this.expType_ = this.expTypeTarget_;
            } else {
                this.expLevelBase_ -= 20.0;
            }
        } else {
            this.expLevelBase_ += (this.expLevelTarget_ - this.expLevelBase_) * 0.05;
        }
        this.expLevel_ = this.expLevelBase_ - Math.cos(this.clock_ * 5.0) * this.expLevelRange_;
        if (this.expLevel_ > this.expLevelMax_) {
            this.expLevel_ = this.expLevelMax_;
        }
        if (this.expLevel_ < 0.0) {
            this.expLevel_ = 0.0;
        }
    }

    public Agent(String mask, String speaker, String bg, double scale) {
        this.mask_ = mask;
        this.bodyTransBase_ = new Vector3D(0.0, 0.0, 0.0);
        this.bodyTrans_ = new Vector3D(0.0, 0.0, 0.0);
        this.bodyScale_ = scale;
        this.bodyScaleBase_ = scale;
        this.bodyRot_ = new Vector3D(0.0, 0.0, 0.0);
        this.bodyRotBase_ = new Vector3D(0.0, 0.0, 0.0);
        this.bodyRotTargetDelta_ = new Vector3D(0.0, 0.0, 0.0);
        this.bodyRotTargetCount_ = 0;
        this.headRot_ = new Vector3D(0.0, 0.0, 0.0);
        this.headRot_.setLimitter(10.0, 10.0, 10.0);
        this.headRotBase_ = new Vector3D(0.0, 0.0, 0.0);
        this.headRotTargetDelta_ = new Vector3D(0.0, 0.0, 0.0);
        this.headRotTargetCount_ = 0;
        this.eyeRot_ = new Vector3D(0.0, 0.0, 0.0);
        this.eyeRot_.setLimitter(20.0, 10.0, 20.0);
        this.expLevel_ = 0.0;
        this.expLevelBase_ = 0.0;
        this.expLevelTarget_ = 0.0;
        this.expLevelMax_ = 100.0;
        this.expLevelRange_ = 10.0;
        this.expType_ = "NEUTRAL";
        this.expTypeTarget_ = "NEUTRAL";
        this.agentSpeakState_ = 0;
        this.noddingRange_ = 0.0;
        this.noddingCountMax_ = 20;
        this.noddingCount_ = 0;
        this.headRotNodding_ = new Vector3D(0.0, 0.0, 0.0);
    }

    public synchronized void calc() {
        this._calcEmotionChange();
        this._calcHeadMovement();
        this._calcBodyMovement();
    }

    public synchronized void setHeadMove(double headMoveNoSpeak, double headMoveSpeak) {
        this.headMoveNoSpeak_ = headMoveNoSpeak;
        this.headMoveSpeak_ = headMoveSpeak;
    }

    public synchronized void addClock(double delta) {
        this.clock_ += delta;
        this.clockHead_ = this.agentSpeakState_ == 2 ? (this.clockHead_ += delta * this.headMoveSpeak_) : (this.clockHead_ += delta * this.headMoveNoSpeak_);
    }

    public synchronized void setAgentSpeakState(int state) {
        this.agentSpeakState_ = state;
    }

    public synchronized void setBackground(String background) {
        this.background_ = background;
    }

    public synchronized String getBackground() {
        return this.background_;
    }

    public synchronized String getMask() {
        return this.mask_;
    }

    public synchronized void startNodding(double level) {
        this.noddingRange_ = level;
        this.noddingCount_ = this.noddingCountMax_;
        this.noddingStartClock_ = this.clockHead_;
        this.noddingType_ = 1;
    }

    public synchronized void startRefuse(double level) {
        this.noddingRange_ = level;
        this.noddingCount_ = this.noddingCountMax_;
        this.noddingStartClock_ = this.clockHead_;
        this.noddingType_ = 2;
    }

    public synchronized void setEmotionTarget(String emotion, double level) {
        this.expTypeTarget_ = emotion;
        this.expLevelTarget_ = level;
        this.expLevelMax_ = level;
    }

    public synchronized void setEmotionTarget(String emotion) {
        this.setEmotionTarget(emotion, 90.0);
    }

    public synchronized void setEmotionNow(String emotion, double level) {
        this.expType_ = emotion;
        this.expLevel_ = level;
        this.expTypeTarget_ = emotion;
        this.expLevelTarget_ = level;
        this.expLevelMax_ = level;
    }

    public synchronized void setEmotionNow(String emotion) {
        this.setEmotionNow(emotion, 90.0);
    }

    public synchronized void setEyeRotNow(double tx, double ty, double tz) {
        this.eyeRot_.set(tx, ty, tz);
        this.eyeRot_.applyLimitter();
    }

    public synchronized void setBodyRotTarget(double tx, double ty, double tz) {
        this.bodyRotTargetCount_ = 5;
        this.bodyRotTargetDelta_.x = (tx - this.bodyRotBase_.x) / (double)this.bodyRotTargetCount_;
        this.bodyRotTargetDelta_.y = (ty - this.bodyRotBase_.y) / (double)this.bodyRotTargetCount_;
        this.headRotTargetDelta_.z = 0.0;
    }

    public synchronized void setBodyRotNow(double tx, double ty, double tz) {
        this.bodyRot_.set(tx, ty, tz);
    }

    public synchronized void setHeadRotTarget(double tx, double ty, double tz) {
        this.headRotTargetCount_ = 3;
        this.headRotTargetDelta_.x = (tx - this.headRotBase_.x) / (double)this.headRotTargetCount_;
        this.headRotTargetDelta_.y = (ty - this.headRotBase_.y) / (double)this.headRotTargetCount_;
        this.headRotTargetDelta_.z = (tz - this.headRotBase_.z) / (double)this.headRotTargetCount_;
    }

    public synchronized void setHeadRotNow(double tx, double ty, double tz) {
        this.headRot_.set(tx, ty, tz);
    }

    public synchronized void setRotTarget(double tx, double ty, double tz) {
        this.setBodyRotTarget(tx, ty, tz);
        this.setHeadRotTarget(tx, ty, tz);
        this.setEyeRotNow(tx, ty, tz);
    }

    public synchronized void setRotNow(double tx, double ty, double tz) {
        this.setBodyRotNow(tx, ty, tz);
        this.setHeadRotNow(tx, ty, tz);
        this.setEyeRotNow(tx, ty, tz);
    }

    public synchronized Vector3D getEyeRot() {
        return this.eyeRot_;
    }

    public synchronized Vector3D getHeadRot() {
        return this.headRot_;
    }

    public synchronized Vector3D getBodyRot() {
        return this.bodyRot_;
    }

    public synchronized Vector3D getBodyTrans() {
        return this.bodyTrans_;
    }

    public synchronized double getBodyScale() {
        return this.bodyScale_;
    }

    public synchronized String getExpType() {
        return this.expType_;
    }

    public synchronized double getExpLevel() {
        return this.expLevel_;
    }

    public String getOutputText(String str) {
        return str;
    }
}

