/*
 * Decompiled with CFR 0.152.
 */
package galatea.dialog;

import galatea.command.Command;
import galatea.dialog.ControllerMode;
import galatea.dialog.ICommandContext;
import galatea.dialog.IControllerModeManager;
import galatea.dialog.IInteractionController;
import galatea.dialog.IInterpretedEventListener;
import galatea.dialog.InterpretedEvent;
import galatea.dialog.InterpretedEventQueueManager;
import galatea.dialog.RuntimeError;
import galatea.dialog.window.IDMWindowActionListener;
import galatea.document.ContentState;
import galatea.document.StateMap;
import galatea.httpserver.HttpAsyncResponse;
import galatea.httpserver.HttpRequestTask;
import galatea.httpserver.IHttpAsyncResponseListener;
import galatea.httpserver.IHttpResponseHtmlMaker;
import galatea.io.DeviceEvent;
import galatea.io.DeviceManager;
import galatea.io.IOutputEventListener;
import galatea.io.OutItemQueueManager;
import galatea.io.OutputEventQueueManager;
import galatea.logger.Logger;
import galatea.outitem.OutItem;
import galatea.outitem.VoiceOutItem;
import galatea.relaxer.event.EventEv;
import galatea.relaxer.event.EventInterpreted;
import galatea.relaxer.event.IEventEvChoice;
import galatea.scripting.ECMAScript;
import galatea.util.StringHashArray;
import galatea.util.Util;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class IC
implements IInteractionController,
ICommandContext,
IControllerModeManager,
IInterpretedEventListener,
IOutputEventListener,
IDMWindowActionListener,
IHttpResponseHtmlMaker {
    private Logger dbg = new Logger("IC");
    private String nextDocFile_ = "";
    private String postString_ = "";
    private ContentState currState_ = null;
    private OutItemQueueManager outQueueManager_ = null;
    private InterpretedEventQueueManager interpretedEventQueueManager_ = null;
    private OutputEventQueueManager outputEventQueueManager_ = null;
    private ECMAScript ecmascript_ = null;
    private DeviceManager deviceManager_;
    private StateMap stateMap_ = null;
    private ControllerMode imode_ = new ControllerMode();
    private ArrayList<Command> commands_ = null;
    private ArrayList<String> debuggerEvals_ = null;
    private ArrayList<IHttpAsyncResponseListener> httpAsyncResponseListeners_ = new ArrayList();
    private String nextStateName_ = null;
    private String evalAfterInputHandler_ = null;

    private void _updateDialogStateChange(String state) {
        this.deviceManager_.updateDialogStateChange(state);
    }

    @Override
    public void addHttpAsyncResponseListener(IHttpAsyncResponseListener listener) {
        this.httpAsyncResponseListeners_.add(listener);
    }

    @Override
    public synchronized void setNextState(String state) {
        this.dbg.print("IC: setNextState: " + state);
        this.nextStateName_ = state;
    }

    public synchronized void resetNextState() {
        this.dbg.print("resetNextState");
        this.nextStateName_ = null;
    }

    private synchronized void _resetEvalAfterInputHandler() {
        this.evalAfterInputHandler_ = null;
    }

    private synchronized void _appendEvalAfterInputHandler(String s) {
        this.evalAfterInputHandler_ = this.evalAfterInputHandler_ == null ? s : String.valueOf(this.evalAfterInputHandler_) + s;
    }

    private synchronized void _doEvalAfterInputHandler() {
        if (this.evalAfterInputHandler_ != null) {
            try {
                this.ecmascript_.evaluate(this.evalAfterInputHandler_);
            }
            catch (RuntimeError e) {
                this.dbg.print("IC: evaluate " + e.toString());
            }
            this.dbg.print("IC: afterInputHandler: " + this.evalAfterInputHandler_);
        }
    }

    public IC() {
        this.dbg.print("IC: constructor start");
        try {
            this.ecmascript_ = new ECMAScript();
        }
        catch (RuntimeError e) {
            this.dbg.print(e.toString());
        }
        this.interpretedEventQueueManager_ = new InterpretedEventQueueManager();
        this.outputEventQueueManager_ = new OutputEventQueueManager();
        this.deviceManager_ = new DeviceManager();
        this.outQueueManager_ = new OutItemQueueManager(this.deviceManager_);
        this.commands_ = new ArrayList();
        this.imode_ = new ControllerMode();
        this.debuggerEvals_ = new ArrayList();
        this.dbg.print("IC: constructor end");
    }

    public void start() {
        this.deviceManager_.start(this, this, this, this, this);
    }

    public String getScriptVersionAndCopyright() {
        return this.ecmascript_.getVersionAndCopyright();
    }

    @Override
    public boolean waitDevicesForReady() {
        return this.deviceManager_.waitDevicesForReady();
    }

    @Override
    public void setStateMap(StateMap stateMap) throws Exception {
        this.setEndFlag(false);
        this.setEndImm(false);
        this.stateMap_ = stateMap;
        this.currState_ = this.stateMap_.getFirstState();
        if (this.currState_ == null) {
            throw new RuntimeError("(setStateMap) State not found: " + this.currState_.getName());
        }
        this._updateDialogStateChange(this.currState_.getName());
    }

    private void _sleep() {
        try {
            Thread.sleep(1L, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _doEvents() throws RuntimeError {
        this._resetEvalAfterInputHandler();
        this.deviceManager_.doTimerTask();
        this._sleep();
        this._processOutputEventQueueItem();
        this._processInterpretedEventQueueItem();
        this._doEvalAfterInputHandler();
        this._doDebuggerEvals();
    }

    private void _execCurrentStateCommands() {
        if (this.currState_ == null) {
            return;
        }
        this.commands_.clear();
        this.commands_.addAll(this.currState_.getCommands());
        while (!this.commands_.isEmpty()) {
            Command cmd = this.commands_.remove(0);
            cmd.setContext(this, this.ecmascript_);
            try {
                cmd.execute();
            }
            catch (RuntimeError e) {
                this.dbg.print(e.toString());
            }
            this.dbg.print("IC: command done: " + cmd.toString(), 2);
        }
    }

    private boolean _processOutQueueIteration() {
        if (!this.outQueueManager_.getCurrOutQueueIsValid()) {
            this.outQueueManager_.removeDelayedOutputItems();
            this.outQueueManager_.setCurrOutQueueIsValid(true);
            return false;
        }
        if (!this.imode_.isPauseMode() && !this.outQueueManager_.doOutputIteration()) {
            return false;
        }
        if (this.imode_.isEndImm()) {
            this.outQueueManager_.discard();
            this.dbg.print("IC: iteration discard queue");
            this.currState_ = null;
            return false;
        }
        return true;
    }

    private void _processOutQueue() {
        this.outQueueManager_.setCurrOutQueueIsValid(true);
        do {
            this._handleHttpRequestTasks();
            try {
                this._doEvents();
            }
            catch (RuntimeError e) {
                this.setPauseMode(true);
                this.dbg.print(e.toString());
            }
        } while (this._processOutQueueIteration());
    }

    private void _gotoNextState() throws Exception {
        if (this.imode_.isEnd()) {
            this.dbg.print("IC: end");
            this.currState_ = null;
            return;
        }
        if (this.stateMap_ == null) {
            this.dbg.print("gotoNextState(): stateMap is null");
            this.imode_.setStatelessMode(true);
            return;
        }
        if (this.nextStateName_ == null) {
            this.currState_ = null;
            throw new RuntimeError("nextStateName is null");
        }
        this.dbg.print("IC: from " + this.currState_.getName() + " to " + this.nextStateName_);
        this.currState_ = this.stateMap_.get(this.nextStateName_);
        if (this.currState_ == null) {
            throw new RuntimeError("(gotoNextState) State not found: " + this.nextStateName_);
        }
        this._updateDialogStateChange(this.currState_.getName());
        this.resetNextState();
    }

    private void _handleHttpRequestTasks() {
        while (this.deviceManager_.sizeExternalTask() > 0) {
            HttpRequestTask task = this.deviceManager_.removeExternalTask();
            String arg = task.getArgument();
            String ev = task.getEvent();
            if (ev.equals("talk")) {
                VoiceOutItem oi = new VoiceOutItem("'" + arg + "'");
                oi.setECMAScript(this.ecmascript_);
                try {
                    ((OutItem)oi).doEvaluate();
                    this.enqueueOutItem(oi);
                }
                catch (RuntimeError e) {
                    this.dbg.print(e.toString());
                }
                continue;
            }
            if (ev.equals("talk-stop")) {
                this.dbg.print(ev.toString());
                continue;
            }
            if (ev.equals("start-doc")) {
                this.setNextDocFile(arg, "");
                this.dbg.print(ev.toString());
                continue;
            }
            if (ev.equals("quit-doc")) {
                this.terminateDialogAction();
                this.dbg.print(ev.toString());
                continue;
            }
            if (ev.equals("go-stateless")) {
                this.imode_.setStatelessMode(true);
                this.dbg.print(ev.toString());
                continue;
            }
            if (!ev.equals("go-state")) continue;
            this.imode_.setStatelessMode(false);
            this.dbg.print(ev.toString());
        }
    }

    @Override
    public void mainLoop() throws Exception {
        this.dbg.print("IC: mainLoop start");
        while (true) {
            if (this.imode_.isStatelessMode()) {
                this._processOutQueueIteration();
                this._handleHttpRequestTasks();
                this._doEvents();
                if (this.nextDocFile_.length() <= 0) continue;
                return;
            }
            this._execCurrentStateCommands();
            this._processOutQueue();
            this._gotoNextState();
            if (this.currState_ == null) break;
        }
    }

    private void _gotoNextStateByText(String text) {
        if (this.currState_ == null) {
            return;
        }
        this.dbg.print("IC: gotoNextStateByText(" + text + ") at state:" + this.currState_.getName());
        String next = this.currState_.getDefaultEventHandler();
        if (next == null) {
            this.dbg.print("findEventHandler() not found in " + this.currState_.getName());
            return;
        }
        this.dbg.print("findEventHandler() returns " + next);
        this.outQueueManager_.setCurrOutItemIsValid(false);
        this.outQueueManager_.setCurrOutQueueIsValid(false);
        this.setNextState(next);
    }

    private void _gotoDefaultNextState() {
        if (this.currState_ == null) {
            return;
        }
        String next = this.currState_.getDefaultEventHandler();
        if (next == null) {
            this.dbg.print("findEventHandler() not found in " + this.currState_.getName());
            return;
        }
        this.dbg.print("findEventHandler() returns " + next);
        this.outQueueManager_.setCurrOutItemIsValid(false);
        this.outQueueManager_.setCurrOutQueueIsValid(false);
        this.setNextState(next);
    }

    private void _sendAsHttpAsyncResponseEvent(InterpretedEvent evt) {
        int i = 0;
        while (i < this.httpAsyncResponseListeners_.size()) {
            HttpAsyncResponse h = HttpAsyncResponse.newInstance(evt.toString());
            this.httpAsyncResponseListeners_.get(i).enqueueHttpAsyncResponse(h);
            ++i;
        }
    }

    private void _processInterpretedEvent(InterpretedEvent evt) {
        EventEv ev;
        this._sendAsHttpAsyncResponseEvent(evt);
        try {
            ev = evt.getEv();
        }
        catch (Exception e) {
            this.dbg.print("IC: getEv() error.");
            return;
        }
        if (ev != null) {
            String type = ev.getType();
            if (!type.equals("INPUT") && !type.equals("COMMAND")) {
                this.dbg.print("IC: ignored: " + type);
                return;
            }
            IEventEvChoice c = ev.getContent();
            if (c instanceof EventInterpreted) {
                this.dbg.print("IC: EventInterpreted " + evt.toString());
                EventInterpreted ei = (EventInterpreted)c;
                if (ei.getScript() != null) {
                    this._appendEvalAfterInputHandler(ei.getScript());
                }
                this._gotoDefaultNextState();
            }
        }
    }

    @Override
    public void setNextDocumentAction(String uri) {
        if (uri != null && uri.length() > 0) {
            this.dbg.print("IC: setNextDocumentAction " + uri);
            this.setNextDocFile(uri, "");
        }
    }

    @Override
    public void terminateDialogAction() {
        this.dbg.print("IC: terminateDialogAction");
        if (this.outQueueManager_ != null) {
            this.outQueueManager_.setCurrOutItemIsValid(false);
        } else {
            System.err.println("Warning: no current outitem.");
        }
        this.outQueueManager_.setCurrOutQueueIsValid(false);
        this.resetNextState();
        this.setEndFlag(true);
        this.setEndImm(true);
    }

    @Override
    public void setPauseModeAction(boolean b) {
        this.imode_.setPauseMode(b);
    }

    @Override
    public void setPauseMode(boolean b) {
        this.imode_.setPauseMode(b);
    }

    @Override
    public boolean getPauseMode() {
        return this.imode_.isPauseMode();
    }

    @Override
    public void quitAction() {
        this.dbg.print("IC: quitAction");
        this.outQueueManager_.setCurrOutItemIsValid(false);
        this.outQueueManager_.setCurrOutQueueIsValid(false);
        this.resetNextState();
        this.setEndFlag(true);
        this.setEndImm(true);
        this.setNextDocFile("", "");
    }

    @Override
    public void enqueueOutputEvent(DeviceEvent evt) {
        this.outputEventQueueManager_.enqueue(evt);
    }

    @Override
    public void enqueueInterpretedEvent(InterpretedEvent evt) {
        this.interpretedEventQueueManager_.enqueue(evt);
    }

    private void _processOutputEventQueueItem() {
        DeviceEvent evt;
        while ((evt = this.outputEventQueueManager_.dequeue()) != null) {
            this.outQueueManager_.processDeviceEvent(evt);
        }
    }

    private void _processInterpretedEventQueueItem() {
        InterpretedEvent evt;
        while ((evt = this.interpretedEventQueueManager_.dequeue()) != null) {
            this._processInterpretedEvent(evt);
        }
    }

    @Override
    public void enqueueOutItem(OutItem oi) {
        this.dbg.print("IC: enqueueOutput " + oi.toString());
        this.outQueueManager_.enqueue(oi);
    }

    @Override
    public void insertCommandsTop(ArrayList<Command> v) {
        if (this.commands_ == null) {
            return;
        }
        this.dbg.print("IC: insertCommandsTop " + Util.removeNewLines(v.toString()));
        this.commands_.addAll(0, v);
    }

    @Override
    public void setEndFlag(boolean b) {
        this.dbg.print("IC: setEndFlag: " + b);
        this.imode_.setEndFlag(b);
    }

    @Override
    public void setNextDocFile(String nextfile, String post) {
        this.dbg.print("IC: setNextDocFile:" + nextfile + " post:" + post);
        this.nextDocFile_ = nextfile;
        this.postString_ = post;
    }

    @Override
    public String getNextDocFile() {
        return this.nextDocFile_;
    }

    @Override
    public String getPostString() {
        return this.postString_;
    }

    @Override
    public void resetNextDocFile() {
        this.nextDocFile_ = "";
        this.postString_ = "";
    }

    @Override
    public void gotoState(String state) {
        this.setNextState(state);
        this.commands_.clear();
    }

    @Override
    public void stopOutput() {
        this.outQueueManager_.setCurrOutItemIsValid(false);
        this.outQueueManager_.setCurrOutQueueIsValid(false);
    }

    @Override
    public void setEndImm(boolean b) {
        this.imode_.setEndImm(b);
    }

    @Override
    public boolean isStatelessMode() {
        return this.imode_.isStatelessMode();
    }

    @Override
    public void setStatelessMode(boolean statelessMode) {
        if (!this.imode_.isStatelessMode() && statelessMode) {
            this.outQueueManager_.removeDelayedOutputItems();
            this.outQueueManager_.stopCurrentOutput();
            this.outQueueManager_.setCurrOutQueueIsValid(false);
        }
        this.imode_.setStatelessMode(statelessMode);
        if (statelessMode) {
            this.dbg.print("IC: setStatelessMode = true");
        } else {
            this.dbg.print("IC: setStatelessMode = false");
        }
    }

    @Override
    public String getResourceAsString(String path) {
        InputStream is = this.getClass().getResourceAsStream(path);
        Charset cs = Charset.forName("UTF-8");
        return Util.readInputStream(is, cs);
    }

    @Override
    public String getDialogMonitorHtml() {
        boolean stateless = this.isStatelessMode();
        String statelessModeStr = stateless ? "stateless" : "state";
        OutItemQueueManager oqm = this.outQueueManager_;
        String res = "";
        if (stateless) {
            String html = this.getResourceAsString("/res/html/gdm.html");
            String script = this.getResourceAsString("/res/js/gdm.js");
            StringHashArray replaces = new StringHashArray();
            replaces.put("${script}", script);
            replaces.put("${currentStateName}", "N/A");
            replaces.put("${nextDocFile}", "N/A");
            replaces.put("${outputQueue}", Util.encodeXmlChars(oqm.toString()));
            replaces.put("${currentState}", "N/A");
            replaces.put("${statelessModeStr}", statelessModeStr);
            res = Util.getDocumentFromTemplate(html, replaces);
        } else {
            ContentState cs = this.currState_;
            String docFile = this.getNextDocFile();
            String html = this.getResourceAsString("/res/html/gdm.html");
            String script = this.getResourceAsString("/res/js/gdm.js");
            StringHashArray replaces = new StringHashArray();
            replaces.put("${script}", script);
            replaces.put("${currentStateName}", cs.getName());
            replaces.put("${nextDocFile}", docFile);
            replaces.put("${outputQueue}", Util.encodeXmlChars(oqm.toString()));
            replaces.put("${currentState}", Util.encodeXmlChars(cs.toString()));
            replaces.put("${statelessModeStr}", statelessModeStr);
            res = Util.getDocumentFromTemplate(html, replaces);
        }
        return res;
    }

    @Override
    public String getDemoAppHtml() {
        String html = this.getResourceAsString("/res/html/demo.html");
        StringHashArray replaces = new StringHashArray();
        replaces.put("${gdm_js}", this.getResourceAsString("/res/js/gdm.js"));
        replaces.put("${demo_js}", this.getResourceAsString("/res/js/demo.js"));
        String res = Util.getDocumentFromTemplate(html, replaces);
        return res;
    }

    @Override
    public void dispDocInfo(String file, String state, String src, String trans) {
        this.deviceManager_.dispDocInfo(file, state, src, trans);
    }

    @Override
    public void setDebuggerEvalAction(String str) {
        this.debuggerEvals_.add(str);
    }

    private void _doDebuggerEvals() {
        int i = 0;
        int n = this.debuggerEvals_.size();
        while (i < n) {
            String s = this.debuggerEvals_.get(i);
            String result = "";
            try {
                result = this.ecmascript_.evaluate(s);
            }
            catch (RuntimeError e) {
                result = "[Error] " + e.toString();
            }
            this.deviceManager_.dispDebuggerEvalResult(result);
            ++i;
        }
        this.debuggerEvals_.clear();
    }
}

