/*
 * Decompiled with CFR 0.152.
 */
package galatea.grammar;

import galatea.dialog.DialogManager;
import galatea.logger.Logger;
import galatea.util.Property;
import galatea.util.SubProcess;
import galatea.util.Util;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class GrammarTransformer {
    private Logger dbg = new Logger("GrammarTransformer");
    private static final String xslRes = "/res/grammar/xml2julgrm.xsl";
    private Transformer transformer_;
    private String grammar_ = "";
    private String voca_ = "";
    private String errors_ = "";
    private String outputs_ = "";
    private SubProcess subProcess_;
    private String mkdfaPerl_ = Property.getForPlatformAsStr("Grammar.Mkdfa.Perl", "perl");
    private String mkdfaExe_ = "./mkdfa.pl";
    private String mkdfaDir_ = Property.getForPlatformAsStr("Grammar.Mkdfa.Dir", "/data/istc-cdrom-2006-10/linux/bin/SRM/bin");
    private boolean running_ = false;
    private static int count_ = 0;

    public static void main(String[] argv) {
        String base;
        GrammarTransformer gt = new GrammarTransformer();
        String renrakuRes = "/res/grammar/renraku.xml";
        String str = DialogManager.getResourceAsString(renrakuRes);
        if (!gt.doTransform(str, base = String.valueOf(Util.getPlatformWorkDir()) + "/renraku")) {
            System.out.print("[error]\n");
            System.out.print("[E]\n" + gt.getErrors());
            System.out.print("[O]\n" + gt.getOutputs());
        } else {
            System.out.print("[ok]\n");
            System.out.print("[grammar]\n" + gt.getGrammar());
            System.out.print("[voca]\n" + gt.getVoca());
            System.out.print("[E]\n" + gt.getErrors());
            System.out.print("[O]\n" + gt.getOutputs());
        }
    }

    public GrammarTransformer() {
        this.mkdfaExe_ = Property.getForPlatformAsStr("Grammar.Mkdfa.Exe", "mkdfa.pl");
        if (count_ == 0) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    GrammarTransformer.this.dbg.print("Shutting down");
                    if (GrammarTransformer.this.subProcess_ != null) {
                        try {
                            GrammarTransformer.this.subProcess_.destroy();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            ++count_;
        }
    }

    public boolean doTransform(String str, String base) {
        if (!this._transform(str)) {
            return false;
        }
        if (!this._makeSrcFiles(base)) {
            return false;
        }
        return this._generate(base);
    }

    private boolean _generate_ORG(String base) {
        this.subProcess_ = new SubProcess(String.valueOf(this.mkdfaDir_) + "/" + this.mkdfaExe_ + " " + base);
        if (this.subProcess_ == null) {
            return false;
        }
        if (!this.subProcess_.run(this.mkdfaDir_)) {
            this.errors_ = this.subProcess_.getError();
            return false;
        }
        this.errors_ = "";
        this.outputs_ = "";
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean errEnd = false;
                boolean outEnd = false;
                while (!errEnd || !outEnd) {
                    while (true) {
                        String er;
                        if ((er = GrammarTransformer.this.subProcess_.receiveFromStderr()) == null) break;
                        GrammarTransformer grammarTransformer = GrammarTransformer.this;
                        grammarTransformer.errors_ = String.valueOf(grammarTransformer.errors_) + er + "\n";
                    }
                    errEnd = true;
                    while (true) {
                        String out;
                        if ((out = GrammarTransformer.this.subProcess_.receiveFromStdout()) == null) break;
                        GrammarTransformer grammarTransformer = GrammarTransformer.this;
                        grammarTransformer.outputs_ = String.valueOf(grammarTransformer.outputs_) + out + "\n";
                    }
                    outEnd = true;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                GrammarTransformer.this.subProcess_.destroy();
                GrammarTransformer.this.running_ = false;
            }
        });
        th.setName("GrammarTransformer(_generate thread)");
        this.running_ = true;
        th.start();
        while (this.running_) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.outputs_.indexOf("generated:") >= 0;
    }

    private boolean _generate(String base) {
        this.errors_ = "";
        this.outputs_ = "";
        String cmd = String.valueOf(this.mkdfaPerl_) + " " + this.mkdfaDir_ + "/" + this.mkdfaExe_ + " " + base;
        String dir = this.mkdfaDir_;
        base = Util.getPlatformFileName(base);
        cmd = Util.getPlatformFileName(cmd);
        dir = Util.getPlatformFileName(dir);
        this.errors_ = "generate SubProcess(dir:" + dir + ")\n" + cmd + "\n";
        this.subProcess_ = new SubProcess(cmd);
        if (this.subProcess_ == null) {
            return false;
        }
        if (!this.subProcess_.run(dir)) {
            this.errors_ = this.subProcess_.getError();
            return false;
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean working = true;
                while (working) {
                    String out;
                    String er = GrammarTransformer.this.subProcess_.receiveFromStderrNB();
                    if (er != null && er.length() > 0) {
                        GrammarTransformer grammarTransformer = GrammarTransformer.this;
                        grammarTransformer.errors_ = String.valueOf(grammarTransformer.errors_) + er + "\n";
                    }
                    if ((out = GrammarTransformer.this.subProcess_.receiveFromStdoutNB()) != null && out.length() > 0) {
                        GrammarTransformer grammarTransformer = GrammarTransformer.this;
                        grammarTransformer.outputs_ = String.valueOf(grammarTransformer.outputs_) + out + "\n";
                        if (out.indexOf("generated:") >= 0) {
                            working = false;
                        }
                        if (out.indexOf("no .dfa or .dict file generated") >= 0) {
                            working = false;
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                GrammarTransformer.this.subProcess_.destroy();
                GrammarTransformer.this.running_ = false;
            }
        });
        th.setName("GrammarTransformer(_generate thread)");
        this.running_ = true;
        th.start();
        while (this.running_) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.outputs_.indexOf("generated:") >= 0;
    }

    private boolean _makeSrcFiles(String base) {
        this.errors_ = "";
        this.outputs_ = "";
        try {
            Charset cs = Util.getSystemDefaultCharset();
            Util.writeToFile(String.valueOf(base) + ".grammar", this.getGrammar(), cs);
            Util.writeToFile(String.valueOf(base) + ".voca", this.getVoca(), cs);
        }
        catch (Exception e) {
            this.errors_ = "makeSrcFiles() " + e.toString();
            return false;
        }
        return true;
    }

    private boolean _transform(String s) {
        this.errors_ = "";
        this.outputs_ = "";
        TransformerFactory factory = TransformerFactory.newInstance();
        InputStream is = DialogManager.class.getResourceAsStream(xslRes);
        StreamSource xsl = new StreamSource(is);
        try {
            this.transformer_ = factory.newTransformer(xsl);
        }
        catch (TransformerConfigurationException e) {
            this.errors_ = "transform() " + e.toString();
            return false;
        }
        StringReader sr = new StringReader(s);
        StreamSource src = new StreamSource(sr);
        StringWriter writer = new StringWriter();
        StreamResult target = new StreamResult(writer);
        try {
            this.transformer_.transform(src, target);
        }
        catch (Exception e) {
            this.errors_ = "transform() " + e.toString();
            return false;
        }
        String ws = new String(writer.getBuffer());
        String[] lines = ws.replaceAll("\r", "").split("\n");
        Pattern pat = Pattern.compile("^[^\\s]+ :.*$");
        this.grammar_ = "";
        int i = 0;
        int n = lines.length;
        while (i < n) {
            Matcher mat = pat.matcher(lines[i]);
            if (mat.matches()) {
                this.grammar_ = String.valueOf(this.grammar_) + lines[i] + "\n";
            }
            ++i;
        }
        this.voca_ = "";
        Pattern pat2 = Pattern.compile("^\\s*$");
        int i2 = 0;
        int n2 = lines.length;
        while (i2 < n2) {
            Matcher mat = pat.matcher(lines[i2]);
            Matcher mat2 = pat2.matcher(lines[i2]);
            if (!mat.matches() && !mat2.matches() && lines[i2].length() > 0 && lines[i2].charAt(0) != '#') {
                this.voca_ = String.valueOf(this.voca_) + lines[i2] + "\n";
            }
            ++i2;
        }
        return true;
    }

    public String getGrammar() {
        return this.grammar_;
    }

    public String getVoca() {
        return this.voca_;
    }

    public String getErrors() {
        return this.errors_;
    }

    public String getOutputs() {
        return this.outputs_;
    }
}

