/*
 * Decompiled with CFR 0.152.
 */
package galatea.httpserver;

import galatea.httpserver.HttpServer;
import galatea.httpserver.IHttpServerResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;

class HttpServerProc
implements Runnable {
    private static final String SERVER_NAME = "Galatea HTTP Server";
    private static final int BUFFER = 1024;
    private static final int timeout = 10000;
    private static final int HTTP_METHOD_UNSET = -1;
    private static final int HTTP_METHOD_GET = 0;
    private static final int HTTP_METHOD_POST = 1;
    private static final int HTTP_METHOD_HEAD = 2;
    private static final int HTTP_METHOD_UNKNOWN = 99;
    private static final String[] METHODS = new String[]{"GET", "POST", "HEAD"};
    private static final int HTTP_ATTRIB_USERAGENT = 0;
    private static final int HTTP_ATTRIB_HOST = 1;
    private static final int HTTP_ATTRIB_CONTENTLENGTH = 2;
    private static final int HTTP_ATTRIB_CONTENTTYPE = 3;
    private static final String[] ATTRIBS = new String[]{"User-Agent", "Host", "Content-Length", "Content-Type"};
    private static final String STR_FORM_URLENC = "application/x-www-form-urlencoded";
    private static final String STR_FORM_MULTI = "multipart/form-data";
    private static final String STR_BOUNDARY = "boundary";
    private Socket sock;
    private InputStream in;
    private OutputStream out;
    private String remote_host;
    private int threadnumber;
    private IHttpServerResponse response;

    public HttpServerProc(Socket cl, int c, IHttpServerResponse r) {
        this.sock = cl;
        this.threadnumber = c;
        this.response = r;
        try {
            this.in = cl.getInputStream();
            this.out = cl.getOutputStream();
        }
        catch (IOException e) {
            HttpServer.addLogPrintLn(e.getMessage());
        }
        this.remote_host = this.sock.getInetAddress().getHostAddress();
        HttpServer.addLogPrintLn("Connect from: " + this.remote_host);
    }

    @Override
    public void run() {
        block46: {
            byte[] getbuff = new byte[1024];
            byte[] procbuff = new byte[2048];
            int method = -1;
            String request_file = null;
            Hashtable<String, String> attrib = new Hashtable<String, String>();
            try {
                try {
                    String answer;
                    int i;
                    int getpointer;
                    this.sock.setSoTimeout(10000);
                    int procpointer = 0;
                    int checkpoint = -1;
                    block11: while (true) {
                        if ((getpointer = this.in.read(getbuff)) < 0) {
                            HttpServer.addLogPrintLn("Detect getpointer < 0 : break header check.");
                            break;
                        }
                        if (getpointer > 0) {
                            HttpServer.addLogPrint(new String(getbuff, 0, getpointer));
                        }
                        int i2 = 0;
                        while (i2 < getpointer) {
                            procbuff[procpointer] = getbuff[i2];
                            if (++procpointer >= 2048) {
                                HttpServer.addLogPrintLn("Buffer over flow : break header check.");
                                break block11;
                            }
                            ++i2;
                        }
                        int startpoint = 0;
                        i = 0;
                        while (i < procpointer) {
                            if (procbuff[i] == 13) {
                                if (i == startpoint) {
                                    HttpServer.addLogPrintLn("Detect: \\r\\n\\r\\n");
                                    checkpoint = i;
                                    if (i + 1 >= procpointer || procbuff[i + 1] != 10) break block11;
                                    ++checkpoint;
                                    break block11;
                                }
                                checkpoint = i;
                                if (method == -1) {
                                    int j = startpoint;
                                    while (j < checkpoint) {
                                        if (procbuff[j] == 32) {
                                            String strTmp = new String(procbuff, startpoint, j - startpoint);
                                            int k = 0;
                                            while (k < METHODS.length) {
                                                if (strTmp.compareTo(METHODS[k]) == 0) {
                                                    method = k;
                                                    HttpServer.addLogPrintLn("Detect: Method = " + METHODS[method]);
                                                }
                                                ++k;
                                            }
                                            if (method == -1) {
                                                method = 99;
                                                HttpServer.addLogPrintLn("Detect: Method=UNKNOWN");
                                            }
                                            startpoint = j;
                                            break;
                                        }
                                        ++j;
                                    }
                                    j = checkpoint - 1;
                                    while (j > startpoint) {
                                        if (procbuff[j] == 32) {
                                            request_file = j - startpoint > 1 ? new String(procbuff, startpoint + 1, j - startpoint - 1) : null;
                                            startpoint = j + 1;
                                            HttpServer.addLogPrintLn("Detect: Request File = " + request_file);
                                            break;
                                        }
                                        --j;
                                    }
                                    String httpversion = checkpoint > startpoint ? new String(procbuff, startpoint, checkpoint - startpoint) : null;
                                    HttpServer.addLogPrintLn("Detect: HTTP Version = " + httpversion);
                                } else {
                                    String strK = null;
                                    String strV = null;
                                    int j = startpoint;
                                    while (j < checkpoint) {
                                        if (procbuff[j] == 58) {
                                            strK = new String(procbuff, startpoint, j - startpoint);
                                            strV = j + 2 < checkpoint ? (procbuff[j + 1] == 32 ? new String(procbuff, j + 2, checkpoint - j - 2) : new String(procbuff, j + 1, checkpoint - j - 1)) : null;
                                        }
                                        if (strK != null && strV != null) {
                                            attrib.put(strK, strV);
                                            break;
                                        }
                                        ++j;
                                    }
                                }
                                if (i + 1 < procpointer && procbuff[i + 1] == 10) {
                                    checkpoint = ++i;
                                }
                                startpoint = checkpoint + 1;
                            }
                            ++i;
                        }
                        if (checkpoint >= 0) {
                            int j = 0;
                            int i3 = checkpoint + 1;
                            while (i3 < procpointer) {
                                procbuff[j] = procbuff[i3];
                                ++i3;
                                ++j;
                            }
                            procpointer = j;
                        }
                        checkpoint = -1;
                    }
                    if (checkpoint >= 0) {
                        int j = 0;
                        i = checkpoint + 1;
                        while (i < procpointer) {
                            procbuff[j] = procbuff[i];
                            ++i;
                            ++j;
                        }
                        procpointer = j;
                    }
                    if (method == 1) {
                        long contentlength = 0L;
                        long contentlast = 0L;
                        Long objL = new Long((String)attrib.get(ATTRIBS[2]));
                        if (objL != null) {
                            contentlast = contentlength = objL.longValue();
                            HttpServer.addLogPrintLn("Detect: Content-Length: " + objL.toString());
                        }
                        block20: while (true) {
                            checkpoint = -1;
                            if (procpointer > 0) {
                                if ((contentlast -= (long)procpointer) < 1L) {
                                    HttpServer.addLogPrintLn("Content is complete.");
                                    break;
                                }
                                procpointer = 0;
                            }
                            if ((getpointer = this.in.read(getbuff)) < 0) {
                                HttpServer.addLogPrintLn("Detect getpointer < 0 : break body check.");
                                break;
                            }
                            if (getpointer > 0) {
                                HttpServer.addLogPrint(new String(getbuff, 0, getpointer));
                            }
                            int i4 = 0;
                            while (true) {
                                if (i4 >= getpointer) continue block20;
                                procbuff[procpointer] = getbuff[i4];
                                if (++procpointer >= 2048) {
                                    HttpServer.addLogPrintLn("Buffer over flow : break body check.");
                                    break block20;
                                }
                                ++i4;
                            }
                            break;
                        }
                    }
                    if ((answer = this.response.getResponse(request_file)) != null) {
                        String strret = "HTTP/1.0 200 OK\r\n";
                        strret = String.valueOf(strret) + "Server: Galatea HTTP Server\r\n";
                        strret = String.valueOf(strret) + "Connection: close\r\n";
                        strret = String.valueOf(strret) + "Cache-Control: no-cache\r\n";
                        strret = String.valueOf(strret) + "Content-Type: text/html\r\n";
                        strret = String.valueOf(strret) + "\r\n";
                        this.out.write(strret.getBytes());
                        this.out.write(answer.getBytes("UTF-8"));
                        this.out.flush();
                        break block46;
                    }
                    String strret = "HTTP/1.0 403 Forbidden\r\n";
                    strret = String.valueOf(strret) + "Server: Galatea HTTP Server\r\n";
                    strret = String.valueOf(strret) + "Connection: close\r\n";
                    strret = String.valueOf(strret) + "Content-Length: 11\r\n";
                    strret = String.valueOf(strret) + "Content-Type: text/html\r\n";
                    strret = String.valueOf(strret) + "\r\n";
                    strret = String.valueOf(strret) + "Forbidden\r\n";
                    this.out.write(strret.getBytes());
                    this.out.flush();
                }
                catch (IOException e) {
                    HttpServer.addLogPrintLn(String.valueOf(this.toString()) + e.getMessage());
                    try {
                        this.in.close();
                        this.out.close();
                        this.sock.close();
                        HttpServer.addLogPrintLn("Connection Close.");
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    this.in.close();
                    this.out.close();
                    this.sock.close();
                    HttpServer.addLogPrintLn("Connection Close.");
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return "Remote Host [" + this.remote_host + "] Thread Number [" + this.threadnumber + "]";
    }
}

