/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.relaxer.event.EventEv;
import java.io.StringReader;

public class DeviceEvent {
    private Type type_;
    private State state_;
    private String str_;
    private String str2_;

    private Type getDeviceType() {
        return this.type_;
    }

    private State getState() {
        return this.state_;
    }

    public String getString1() {
        return this.str_;
    }

    public String getString2() {
        return this.str2_;
    }

    protected DeviceEvent(Type t, State s, String str, String str2) {
        this.type_ = t;
        this.state_ = s;
        this.str_ = str;
        this.str2_ = str2;
    }

    public static DeviceEvent newOutputBusyInstance(String s1, String s2) {
        return new DeviceEvent(Type.OUTPUT, State.BUSY, s1, s2);
    }

    public static DeviceEvent newOutputBusyInstance(String s1) {
        return new DeviceEvent(Type.OUTPUT, State.BUSY, s1, null);
    }

    public static DeviceEvent newOutputReadyInstance(String s1, String s2) {
        return new DeviceEvent(Type.OUTPUT, State.READY, s1, s2);
    }

    public static DeviceEvent newOutputReadyInstance(String s1) {
        return new DeviceEvent(Type.OUTPUT, State.READY, s1, null);
    }

    public EventEv getEv() throws Exception {
        if (this.str2_ == null) {
            return null;
        }
        EventEv ev = null;
        String s = this.str2_;
        StringReader reader = new StringReader(s);
        try {
            ev = new EventEv(reader);
        }
        catch (Exception e) {
            System.err.println("[DM] DeviceEvent error: " + e.getMessage());
            System.err.println("[DM] " + s);
            ev = null;
        }
        return ev;
    }

    public String toString() {
        Type devtype = this.getDeviceType();
        State state = this.getState();
        StringBuffer sb = new StringBuffer();
        sb.append(state.toString());
        sb.append(" ");
        sb.append(this.getString1());
        sb.append(" ");
        sb.append(this.getString2());
        return sb.toString();
    }

    public boolean isOutputBusyEvent() {
        return this.type_ == Type.OUTPUT && this.state_ == State.BUSY;
    }

    public boolean isOutputReadyEvent() {
        return this.type_ == Type.OUTPUT && this.state_ == State.READY;
    }

    public static class State {
        private String type_;
        public static final State READY = new State("READY");
        public static final State BUSY = new State("BUSY");
        public static final State EVENT = new State("EVENT");

        protected State(String type) {
            this.type_ = type;
        }

        public String toString() {
            return this.type_;
        }
    }

    public static class Type {
        private String type_;
        public static final Type INPUT = new Type("INPUT");
        public static final Type OUTPUT = new Type("OUTPUT");

        private Type(String type) {
            this.type_ = type;
        }

        public String toString() {
            return this.type_;
        }
    }
}

