/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.io.DeviceEvent;
import galatea.io.DeviceManager;
import galatea.logger.Logger;
import galatea.outitem.OutItem;
import java.util.ArrayList;

public class OutItemQueueManager {
    private Logger dbg = new Logger("OQM", 0);
    private DeviceManager deviceManager_;
    private int outputState_ = 0;
    private int outputCount_ = 0;
    private int prevOutputCount_ = 0;
    private OutItem currOutItem_ = null;
    private ArrayList<OutItem> queue_;
    private boolean currOutItemIsValid_ = false;
    private boolean currOutQueueIsValid_ = false;
    private final int STATE_NOT_STARTED = 0;
    private final int STATE_WAIT_FOR_OUTPUT_BUSY = 1;
    private final int STATE_WAIT_FOR_OUTPUT_READY = 2;
    private final int STATE_WAIT_FOR_OUTPUT_STOPPED = 3;

    public OutItemQueueManager(DeviceManager d) {
        this.deviceManager_ = d;
        this.queue_ = new ArrayList();
    }

    public synchronized void setCurrOutQueueIsValid(boolean b) {
        this.currOutQueueIsValid_ = b;
        this.dbg.print("currOutQueueIsValid: " + b);
    }

    public synchronized boolean getCurrOutQueueIsValid() {
        return this.currOutQueueIsValid_;
    }

    public synchronized void setCurrOutItemIsValid(boolean b) {
        this.currOutItemIsValid_ = b;
    }

    public synchronized void processDeviceEvent(DeviceEvent evt) {
        this.dbg.print("processDeviceEvent " + evt.toString());
        if (evt.isOutputBusyEvent()) {
            this.incrementOutputCount();
        } else if (evt.isOutputReadyEvent()) {
            this.decrementOutputCount();
        }
    }

    private void incrementOutputCount() {
        ++this.outputCount_;
        this.dbg.print("OQM: (increment) outputCount=" + this.outputCount_);
    }

    private void decrementOutputCount() {
        --this.outputCount_;
        this.dbg.print("OQM: (decrement) outputCount=" + this.outputCount_);
    }

    public synchronized void discard() {
        this.dbg.print("OQM: queue discard");
        this.queue_.clear();
    }

    public synchronized void enqueue(OutItem o) {
        this.queue_.add(o);
        this.dbg.print("OQM: queue added (" + o.getClass().getName() + ") total:" + this.queue_.size());
    }

    private OutItem dequeue() {
        if (this.queue_.isEmpty()) {
            return null;
        }
        OutItem ret = this.queue_.remove(0);
        this.dbg.print("OQM: dequeue() removed (" + ret.getClass().getName() + ") total:" + this.queue_.size());
        return ret;
    }

    public synchronized void removeDelayedOutputItems() {
        ArrayList<OutItem> newvec = new ArrayList<OutItem>();
        int i = 0;
        while (i < this.queue_.size()) {
            OutItem o = this.queue_.get(i);
            if (o.isInstant() || o.isImportant()) {
                newvec.add(o);
            }
            ++i;
        }
        this.queue_ = newvec;
        this.dbg.print("OQM: removeDelayedOutputItems() total:" + this.queue_.size());
    }

    public synchronized boolean doOutputIteration() {
        switch (this.getOutputState()) {
            case 0: {
                if (this.queue_.isEmpty()) {
                    return false;
                }
                OutItem item = this.dequeue();
                if (item == null) {
                    this.dbg.print("OQM: doOutputIteration() dequeue item is null");
                    return false;
                }
                if (item.isInstant()) {
                    this.dbg.print("OQM: output instant: " + item.toString());
                    boolean success = this.deviceManager_.doOutput(item);
                    if (success) break;
                    return false;
                }
                this.dbg.print("OQM: output non-instant: " + item.toString());
                boolean success = this.deviceManager_.doOutput(item);
                if (!success) {
                    return false;
                }
                this.setCurrOutItemIsValid(true);
                this.setOutputState(1);
                this.setCurrOutItem(item);
                this.setPrevOutputCount(this.outputCount_);
                break;
            }
            case 1: {
                if (!this.currOutItemIsValid_) {
                    this.deviceManager_.doStop(this.getCurrOutItem());
                    this.setOutputState(3);
                    break;
                }
                if (this.outputCount_ != this.getPrevOutputCount() + 1) break;
                this.setOutputState(2);
                break;
            }
            case 2: {
                if (!this.currOutItemIsValid_) {
                    this.deviceManager_.doStop(this.getCurrOutItem());
                    this.setOutputState(3);
                    break;
                }
                if (this.outputCount_ != this.getPrevOutputCount()) break;
                this.setOutputState(0);
                break;
            }
            case 3: {
                if (this.outputCount_ != this.getPrevOutputCount()) break;
                this.setOutputState(0);
                break;
            }
        }
        return true;
    }

    private void setOutputState(int outputState) {
        this.outputState_ = outputState;
        switch (this.outputState_) {
            case 0: {
                this.dbg.print("OQM: [outputState 0] starting output");
                break;
            }
            case 1: {
                this.dbg.print("OQM: [outputState 1] waiting for output busy");
                break;
            }
            case 2: {
                this.dbg.print("OQM: [outputState 2] waiting for output ready");
                break;
            }
            case 3: {
                this.dbg.print("OQM: [outputState 3] waiting for output stop done");
                break;
            }
        }
    }

    public synchronized OutItem getCurrOutItem() {
        return this.currOutItem_;
    }

    private void setCurrOutItem(OutItem currOutItem) {
        this.currOutItem_ = currOutItem;
    }

    private synchronized int getOutputState() {
        return this.outputState_;
    }

    private int getPrevOutputCount() {
        return this.prevOutputCount_;
    }

    private void setPrevOutputCount(int prevOutputCount) {
        this.prevOutputCount_ = prevOutputCount;
    }

    public synchronized void stopCurrentOutput() {
        if (this.getCurrOutItem() != null) {
            this.deviceManager_.doStop(this.getCurrOutItem());
            this.setOutputState(3);
        }
    }

    public synchronized String toString() {
        String result = "";
        result = String.valueOf(result) + "count: " + this.queue_.size() + "\n";
        int i = 0;
        while (i < this.queue_.size()) {
            result = String.valueOf(result) + "[item " + i + "] ";
            result = String.valueOf(result) + this.queue_.get(i).toString() + "\n";
            ++i;
        }
        return result;
    }
}

