/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.plugins;

import galatea.logger.Logger;
import galatea.outitem.AudioOutItem;
import galatea.outitem.OutItem;
import galatea.submodule.AbstractSubModule;
import galatea.util.Util;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioPlayerSubModule
extends AbstractSubModule {
    private Logger dbg = new Logger("SND", 0);
    private boolean active = false;
    private File file = null;
    private String id;

    @Override
    public boolean startOutput(OutItem item) {
        if (!(item instanceof AudioOutItem)) {
            return false;
        }
        String src = ((AudioOutItem)item).getArg();
        String filename = "";
        if (src.startsWith("http:")) {
            String suffix = Util.getSuffix(src);
            filename = Util.mktemp(suffix);
            Util.saveUrlAsBinary(src, filename);
        } else {
            filename = src.startsWith("file:") ? src.replaceFirst("^file:", "") : src;
        }
        this.file = new File(filename);
        this.id = String.valueOf(src) + " " + filename;
        Thread th = new Thread(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                AudioInputStream ais = null;
                Line line = null;
                AudioPlayerSubModule.this.active = true;
                try {
                    try {
                        int len;
                        ais = AudioSystem.getAudioInputStream(AudioPlayerSubModule.this.file);
                        line = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, ais.getFormat()));
                        line.open();
                        line.flush();
                        AudioFormat format = ais.getFormat();
                        int frameSize = format.getFrameSize();
                        long frameLength = ais.getFrameLength();
                        byte[] buffer = new byte[512];
                        int pos = 0;
                        int prevPos = 0;
                        while (AudioPlayerSubModule.this.active && (len = ais.read(buffer)) > 0) {
                            int off = 0;
                            while (AudioPlayerSubModule.this.active && len > 0) {
                                int l = line.write(buffer, off, len);
                                if (!line.isRunning()) {
                                    line.start();
                                }
                                off += l;
                                len -= l;
                                prevPos = pos;
                                pos += l;
                            }
                        }
                        if (AudioPlayerSubModule.this.active) {
                            line.drain();
                        }
                    }
                    catch (UnsupportedAudioFileException e) {
                        e.printStackTrace();
                        if (Util.isLinux()) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                        }
                        try {
                            if (ais != null) {
                                ais.close();
                            }
                            if (line != null) {
                                line.close();
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        AudioPlayerSubModule.this.receiver_.receiveOutputReady("audio", AudioPlayerSubModule.this.id);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (Util.isLinux()) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                        }
                        try {
                            if (ais != null) {
                                ais.close();
                            }
                            if (line != null) {
                                line.close();
                            }
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                        AudioPlayerSubModule.this.receiver_.receiveOutputReady("audio", AudioPlayerSubModule.this.id);
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        if (Util.isLinux()) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                        }
                        try {
                            if (ais != null) {
                                ais.close();
                            }
                            if (line != null) {
                                line.close();
                            }
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                        AudioPlayerSubModule.this.receiver_.receiveOutputReady("audio", AudioPlayerSubModule.this.id);
                    }
                }
                finally {
                    if (Util.isLinux()) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    try {
                        if (ais != null) {
                            ais.close();
                        }
                        if (line != null) {
                            line.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    AudioPlayerSubModule.this.receiver_.receiveOutputReady("audio", AudioPlayerSubModule.this.id);
                }
            }
        });
        th.start();
        this.receiver_.receiveOutputBusy("audio", this.id);
        return true;
    }

    @Override
    public boolean stopOutput(OutItem item) {
        if (item instanceof AudioOutItem) {
            this.active = false;
            return true;
        }
        return false;
    }
}

