/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.plugins;

import galatea.logger.Logger;
import galatea.outitem.OutItem;
import galatea.outitem.VoiceOutItem;
import galatea.submodule.AbstractSubModule;
import galatea.util.Property;
import galatea.util.SubProcess;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GalateaTalkSubModule
extends AbstractSubModule {
    private Logger dbg = new Logger("SSM");
    private String speakLen_ = "";
    private String speakUtt_ = "";
    private String errors_ = "";
    private String outputs_ = "";
    private String exception_ = "";
    private String engineExe_ = "gtalk.exe";
    private String engineDir_ = ".";
    private String engineArg_ = "-C ssm-win.conf";
    private SubProcess subProcess_;
    private Pattern pSSMSpeakLen = Pattern.compile("rep Speak.len = (.*)$");
    private Pattern pSSMSpeakUtt = Pattern.compile("rep Speak.utt = (.*)$");
    private Pattern pSSMSpeakStat = Pattern.compile("rep Speak.stat = (.*)$");
    private Pattern pToSSM = Pattern.compile("^to @SSM (.*)$");

    public GalateaTalkSubModule() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                GalateaTalkSubModule.this.dbg.print("Shutting down");
                if (GalateaTalkSubModule.this.subProcess_ != null) {
                    GalateaTalkSubModule.this.subProcess_.sendToStdin("set Run = EXIT");
                    GalateaTalkSubModule.this.subProcess_.destroy();
                }
            }
        });
    }

    @Override
    public void setTargetRunLevel(int level) {
        if (level == 2) {
            this._setup();
            this.receiver_.receiveRunLevel(2, this);
        }
    }

    private void _setup() {
        this.errors_ = "";
        this.outputs_ = "";
        this.exception_ = "";
        this.engineDir_ = Property.getForPlatformAsStr("GalateaTalk.Dir", "/data/istc-cdrom-2006-10/linux/bin/SSM/gtalk");
        this.engineExe_ = Property.getForPlatformAsStr("GalateaTalk.Exe", "gtalk");
        this.engineArg_ = Property.getForPlatformAsStr("GalateaTalk.Arg", "-C ssm.conf");
        this.subProcess_ = new SubProcess(String.valueOf(this.engineDir_) + "/" + this.engineExe_ + " " + this.engineArg_);
        if (this.subProcess_ == null) {
            this.logger_.fatalError(this.subProcess_.getError());
            return;
        }
        if (!this.subProcess_.run(this.engineDir_)) {
            this.errors_ = this.subProcess_.getError();
            this.logger_.fatalError(this.subProcess_.getError());
            return;
        }
        this.exception_ = "";
        this.errors_ = "";
        this.outputs_ = "";
        this.dbg.print("GalateaTalkSubModule setup done");
    }

    @Override
    public void doTimerTask() {
        String str;
        String er;
        while ((er = this.subProcess_.receiveFromStderrNB()).length() != 0) {
            this.dbg.print("E: " + er);
        }
        while ((str = this.subProcess_.receiveFromStdoutNB()).length() != 0) {
            this.dbg.print("O: " + str);
            Matcher mSSMSpeakLen = this.pSSMSpeakLen.matcher(str);
            if (mSSMSpeakLen.matches()) {
                this.speakLen_ = mSSMSpeakLen.group(1);
                break;
            }
            Matcher mSSMSpeakUtt = this.pSSMSpeakUtt.matcher(str);
            if (mSSMSpeakUtt.matches()) {
                this.speakUtt_ = mSSMSpeakUtt.group(1);
                break;
            }
            Matcher mSSMSpeakStat = this.pSSMSpeakStat.matcher(str);
            if (!mSSMSpeakStat.matches()) continue;
            String g1 = mSSMSpeakStat.group(1);
            if (g1.equals("IDLE")) {
                this.dbg.print("checkFromSSM IDLE");
                this.receiver_.receiveOutputReady("voice", String.valueOf(this.speakLen_) + " " + this.speakUtt_);
                this.logger_.outputVoiceStarted("");
                break;
            }
            if (g1.equals("ERROR")) {
                this.dbg.print("checkFromSSM ERROR");
                this.receiver_.receiveOutputReady("voice", "ERROR");
                break;
            }
            if (g1.equals("SPEAKING")) {
                this.dbg.print("checkFromSSM SPEAKING");
                this.receiver_.receiveOutputBusy("voice", "");
                break;
            }
            if (g1.equals("PROCESSING")) {
                this.dbg.print("checkFromSSM PROCESSING");
                break;
            }
            if (!g1.equals("READY")) continue;
            this.dbg.print("checkFromSSM READY");
            this.subProcess_.sendToStdin("set Speak = NOW");
            break;
        }
    }

    @Override
    public boolean filterOutputNative(String str) {
        Matcher m = this.pToSSM.matcher(str);
        if (m.matches()) {
            this.subProcess_.sendToStdin(m.group(1));
            return true;
        }
        return false;
    }

    @Override
    public boolean startOutput(OutItem item) {
        if (!(item instanceof VoiceOutItem)) {
            return false;
        }
        String str = ((VoiceOutItem)item).getArg();
        if (str.length() == 0) {
            this.dbg.print("doOutput() speak empty *** ignored ***");
            return false;
        }
        this.subProcess_.sendToStdin("set Text = " + str);
        this.logger_.outputVoiceStarted(str);
        this.dbg.print("start(" + str + ")");
        return true;
    }

    @Override
    public boolean stopOutput(OutItem item) {
        if (item instanceof VoiceOutItem) {
            this.subProcess_.sendToStdin("set Speak = STOP");
            this.logger_.outputVoiceStarted("");
            return true;
        }
        return false;
    }
}

