/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.wrapper;

import galatea.logger.Logger;
import galatea.outitem.GrammarOutItem;
import galatea.outitem.OutItem;
import galatea.submodule.AbstractSubModule;
import galatea.util.Property;
import galatea.util.Util;
import java.nio.charset.Charset;

public class GRMSubModule
extends AbstractSubModule {
    private final String XML_ENCODING = "EUC-JP";
    private Logger dbg = new Logger("GRM", 0);
    private Charset charset_ = Util.getSystemDefaultCharset();
    private Charset xmlCharset_ = Charset.forName("EUC-JP");
    private boolean dummyMode_ = Property.getAsBoolean("GRM.DummyMode", false);
    private long lastOutputWhen_;
    private boolean waitingForReady_;

    @Override
    public void doTimerTask() {
        long curr;
        if (this.dummyMode_ && this.waitingForReady_ && (curr = Util.getCurrentTimeInMillis()) - this.lastOutputWhen_ > 2000L) {
            this.dbg.print("checkFromSSM IDLE (dummy)");
            this.receiver_.receiveOutputReady("grammar", "(dummy output done)");
            this.waitingForReady_ = false;
        }
    }

    @Override
    public boolean receiveFromDevice(String str) {
        if (str.startsWith("From @GRM tell 200")) {
            this.logger_.inputEventReceived(str.replaceAll("From @", ""));
            this.receiver_.receiveOutputReady("grammar", "");
            return true;
        }
        if (str.startsWith("From @GRM tell 4")) {
            this.logger_.inputEventReceived(str.replaceAll("From @", ""));
            return true;
        }
        return false;
    }

    @Override
    public boolean startOutput(OutItem item) {
        if (!(item instanceof GrammarOutItem)) {
            return false;
        }
        GrammarOutItem g = (GrammarOutItem)item;
        String doc = "<?xml version=\"1.0\" encoding=\"EUC-JP\"?>" + g.getDocument();
        String location = g.getLocation();
        try {
            Util.writeToFile(String.valueOf(location) + ".xml", doc, this.xmlCharset_);
        }
        catch (Exception e) {
            this.dbg.print(e.toString());
            return false;
        }
        String cmd = "to @GRM set ConvertGrammar = " + location;
        this.dbg.print("convertGrammar: " + cmd);
        this.sender_.send(cmd);
        this.receiver_.receiveOutputBusy("grammar", "");
        if (this.dummyMode_) {
            this.lastOutputWhen_ = Util.getCurrentTimeInMillis();
            this.waitingForReady_ = true;
        }
        return true;
    }

    @Override
    public boolean stopOutput(OutItem item) {
        return item instanceof GrammarOutItem;
    }
}

