/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.wrapper;

import galatea.logger.Logger;
import galatea.outitem.OutItem;
import galatea.outitem.VoiceOutItem;
import galatea.submodule.AbstractSubModule;
import galatea.util.Property;
import galatea.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SSMSubModule
extends AbstractSubModule {
    private Logger dbg = new Logger("SSM", 0);
    private boolean dummyMode_ = Property.getAsBoolean("DM.UseWrapper.SSM.Dummy", false);
    private long lastOutputWhen_;
    private boolean waitingForReady_;
    private String speakLen_ = "";
    private String speakUtt_ = "";

    @Override
    public void doTimerTask() {
        long curr;
        if (this.dummyMode_ && this.waitingForReady_ && (curr = Util.getCurrentTimeInMillis()) - this.lastOutputWhen_ > 2000L) {
            this.dbg.print("checkFromSSM IDLE (dummy)");
            this.receiver_.receiveOutputReady("voice", "(dummy output done)");
            this.waitingForReady_ = false;
        }
    }

    @Override
    public boolean receiveFromDevice(String str) {
        Pattern pSSMSpeakLen = Pattern.compile("From @SSM rep Speak.len = (.*)$");
        Matcher mSSMSpeakLen = pSSMSpeakLen.matcher(str);
        if (mSSMSpeakLen.matches()) {
            this.speakLen_ = mSSMSpeakLen.group(1);
            return true;
        }
        Pattern pSSMSpeakUtt = Pattern.compile("From @SSM rep Speak.utt = (.*)$");
        Matcher mSSMSpeakUtt = pSSMSpeakUtt.matcher(str);
        if (mSSMSpeakUtt.matches()) {
            this.speakUtt_ = mSSMSpeakUtt.group(1);
            return true;
        }
        Pattern pSSMSpeakStat = Pattern.compile("From @SSM rep Speak.stat = (.*)$");
        Matcher mSSMSpeakStat = pSSMSpeakStat.matcher(str);
        if (mSSMSpeakStat.matches()) {
            String g1 = mSSMSpeakStat.group(1);
            if (g1.equals("IDLE")) {
                this.dbg.print("checkFromSSM IDLE");
                this.receiver_.receiveOutputReady("voice", String.valueOf(this.speakLen_) + " " + this.speakUtt_);
                return true;
            }
            if (g1.equals("ERROR")) {
                this.dbg.print("checkFromSSM ERROR");
                this.receiver_.receiveOutputReady("voice", "ERROR");
                return true;
            }
            if (g1.equals("SPEAKING")) {
                this.dbg.print("checkFromSSM SPEAKING");
                this.receiver_.receiveOutputBusy("voice", "");
                return true;
            }
            if (g1.equals("PROCESSING")) {
                this.dbg.print("checkFromSSM PROCESSING");
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean startOutput(OutItem item) {
        if (!(item instanceof VoiceOutItem)) {
            return false;
        }
        String str = ((VoiceOutItem)item).getArg();
        if (str.length() == 0) {
            this.dbg.print("doOutput() speak empty *** ignored ***");
            return false;
        }
        this.sender_.send("to @AM-MCL set Speak = " + str);
        this.logger_.outputVoiceStarted("set Speak = " + str);
        this.dbg.print("doOutput() speak (" + str + ")");
        if (this.dummyMode_) {
            this.receiver_.receiveOutputBusy("voice", "");
            this.lastOutputWhen_ = Util.getCurrentTimeInMillis();
            this.waitingForReady_ = true;
        }
        return true;
    }

    @Override
    public boolean stopOutput(OutItem item) {
        if (item instanceof VoiceOutItem) {
            this.sender_.send("to @AM-MCL set Speak = STOP");
            return true;
        }
        return false;
    }
}

