/*
 * Decompiled with CFR 0.152.
 */
package galatea.recogman;

import galatea.dialog.RuntimeError;
import galatea.logger.Logger;
import galatea.recogman.RecogInterpreterListener;
import galatea.relaxer.event.EventEv;
import galatea.relaxer.event.EventGRAMINFO;
import galatea.relaxer.event.EventINPUT;
import galatea.relaxer.event.EventINPUTPARAM;
import galatea.relaxer.event.EventPHYPO;
import galatea.relaxer.event.EventRECOGFAIL;
import galatea.relaxer.event.EventRECOGOUT;
import galatea.relaxer.event.EventRECOGOUTRef;
import galatea.relaxer.event.EventSHYPO;
import galatea.relaxer.event.EventWHYPO;
import galatea.relaxer.event.IEventEvChoice;
import galatea.relaxer.event.IEventRECOGOUTChoice;
import galatea.scripting.ECMAScript;
import galatea.util.HashArray;
import galatea.util.Util;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecogInterpreter {
    private Logger dbg = new Logger("RecogInterpreter", 0);
    private String script_ = new String();
    private String text_ = new String();
    private boolean accepted_ = false;
    private String dialogName_ = "";
    private HashArray slotAliases_ = new HashArray();
    private RecogInterpreterListener recogListener_;
    private ECMAScript ecmascript_ = null;
    private int frames_ = 0;
    private int msec_ = 0;
    private Pattern pattern1_ = Pattern.compile("([^:]*):(.*)");
    private Pattern pattern2_ = Pattern.compile("(.*)@(.*)=(.*)");
    private Pattern pattern3_ = Pattern.compile("(.*)@(.*)");
    private Pattern pattern4_ = Pattern.compile("(\\S+) (.*)");
    private String _parsedString = "";
    private String _parsedSlot = "";
    private String _parsedValue = "";
    private String _eventHandler = "";

    public RecogInterpreter() {
        try {
            this.ecmascript_ = new ECMAScript();
        }
        catch (RuntimeError e) {
            this.dbg.print(e.toString());
        }
    }

    public void setListener(RecogInterpreterListener listener) {
        this.recogListener_ = listener;
    }

    public void reset() {
        this._resetShypo();
        this.frames_ = 0;
        this.msec_ = 0;
        if (this._eventHandler.length() > 0) {
            String sc = String.valueOf(this._eventHandler) + "('reset')";
            this.dbg.print(sc);
            try {
                this.ecmascript_.evaluate(sc);
            }
            catch (RuntimeError e) {
                this.dbg.print(e.toString());
            }
        }
    }

    private void _resetShypo() {
        this.text_ = "";
        this.script_ = "";
    }

    public void setDialogName(String dialogName) {
        this.dialogName_ = dialogName;
    }

    public void resetSlotAlias() {
        this.slotAliases_ = new HashArray();
    }

    public void setSlotAlias(String arg) {
        Matcher m = this.pattern4_.matcher(arg);
        if (m.matches()) {
            this.slotAliases_.put(m.group(1), m.group(2));
        }
    }

    private String _makeAssignCommand(String dialog, String slot, String value) {
        String arg;
        String d = dialog;
        String s = slot;
        String v = value;
        String key = String.valueOf(slot) + ":" + value;
        if (this.slotAliases_.has(key)) {
            arg = (String)this.slotAliases_.get(key);
            Matcher m = this.pattern1_.matcher(arg);
            if (m.matches()) {
                s = m.group(1);
                v = m.group(2);
            }
        } else if (this.slotAliases_.has(slot)) {
            s = arg = (String)this.slotAliases_.get(slot);
        }
        String script = "";
        script = String.valueOf(script) + d + "." + s + "='" + v + "';";
        script = String.valueOf(script) + d + "." + s + "$.justfilled=true;";
        return script;
    }

    public String getText() {
        return this.text_;
    }

    public String getScript() {
        return this.script_;
    }

    private void _parsePhypo(EventPHYPO phypo) {
        String text = "";
        int i = 0;
        int n = phypo.sizeWHYPO();
        while (i < n) {
            EventWHYPO whypo = phypo.getWHYPO(i);
            String word = whypo.getWORD();
            this._parseToScript(word);
            if (this._eventHandler.length() > 0 && this._parsedSlot.length() > 0) {
                String sc = String.valueOf(this._eventHandler) + "('assign','" + this._parsedSlot + "=" + this._parsedValue + "')";
                this.dbg.print(sc);
                try {
                    this.ecmascript_.evaluate(sc);
                }
                catch (RuntimeError e) {
                    this.dbg.print(e.toString());
                }
            }
            text = String.valueOf(text) + this._parsedString;
            ++i;
        }
        if (this._eventHandler.length() > 0 && text.length() > 0) {
            String sc = String.valueOf(this._eventHandler) + "('phypo','" + text + "')";
            this.dbg.print("phypo " + phypo.getSCORE() + " " + phypo.getFRAME());
            this.dbg.print(sc);
            try {
                this.ecmascript_.evaluate(sc);
            }
            catch (RuntimeError e) {
                this.dbg.print(e.toString());
            }
        }
    }

    private void _parseShypo(EventSHYPO shypo) {
        this._resetShypo();
        String text = "";
        String items = "";
        int i = 0;
        int n = shypo.sizeWHYPO();
        while (i < n) {
            EventWHYPO whypo = shypo.getWHYPO(i);
            String word = whypo.getWORD();
            items = String.valueOf(items) + this._parseToScript(word);
            text = String.valueOf(text) + this._parsedString;
            ++i;
        }
        this.script_ = "$utterance='" + text + "';";
        this.script_ = String.valueOf(this.script_) + items;
        this.text_ = text;
    }

    private String _parseToScript(String word) {
        this._parsedString = "";
        this._parsedSlot = "";
        this._parsedValue = "";
        if (word == null) {
            return "";
        }
        String label = "";
        String slot = "";
        String val = "";
        String item = "";
        String wd = "";
        Matcher m1 = this.pattern1_.matcher(word);
        if (m1.matches()) {
            label = m1.group(1);
            wd = m1.group(2);
        } else {
            Matcher m2 = this.pattern2_.matcher(word);
            if (m2.matches()) {
                this.dbg.print("WHYPO match2 " + word);
                label = m2.group(1);
                wd = m2.group(1);
                slot = m2.group(2);
                val = m2.group(3);
                item = this._makeAssignCommand(this.dialogName_, slot, val);
            } else {
                Matcher m3 = this.pattern3_.matcher(word);
                if (m3.matches()) {
                    this.dbg.print("WHYPO match3 " + word);
                    label = m3.group(1);
                    wd = m3.group(1);
                    slot = m3.group(2);
                    val = m3.group(1);
                    item = this._makeAssignCommand(this.dialogName_, slot, val);
                } else {
                    label = word;
                    wd = word;
                }
            }
        }
        this._parsedString = wd;
        this._parsedSlot = slot;
        this._parsedValue = val;
        return item;
    }

    public void receiveInputParam(EventINPUTPARAM ei) {
        this.frames_ = ei.getFRAMES();
        this.msec_ = ei.getMSEC();
    }

    public void receiveRecogout(EventRECOGOUT ro) {
        IEventRECOGOUTChoice rc = ro.getContent();
        if (rc instanceof EventPHYPO) {
            this._parsePhypo((EventPHYPO)rc);
        } else if (rc instanceof EventRECOGOUTRef) {
            EventRECOGOUTRef rr = (EventRECOGOUTRef)rc;
            int i = 0;
            int n = rr.sizeSHYPO();
            while (i < n) {
                EventSHYPO shypo = rr.getSHYPO(i);
                if (shypo.getPASS() == 1) {
                    this.recogListener_.recogPass1Finished();
                } else if (shypo.getRANK() == 1) {
                    this._parseShypo(shypo);
                    this.recogListener_.recogPass2Finished();
                }
                ++i;
            }
        }
    }

    public void receiveRecogMessage(String body) {
        String evstr = "<ev src=\"SRM\" type=\"INPUT\">" + body + "</ev>";
        StringReader reader = new StringReader(evstr);
        try {
            EventEv ev = new EventEv(reader);
            IEventEvChoice evc = ev.getContent();
            if (evc instanceof EventRECOGOUT) {
                this.receiveRecogout((EventRECOGOUT)evc);
            } else if (evc instanceof EventINPUT) {
                EventINPUT input = (EventINPUT)evc;
                String status = input.getSTATUS();
                if (status.equals("LISTEN")) {
                    this.recogListener_.recogListenStarted();
                    this.reset();
                } else if (status.equals("STARTREC")) {
                    this.recogListener_.recogRecordStarted();
                } else if (status.equals("ENDREC")) {
                    this.recogListener_.recogRecordFinished();
                }
            } else if (evc instanceof EventRECOGFAIL) {
                this.recogListener_.recogFailed();
            } else if (evc instanceof EventINPUTPARAM) {
                this.receiveInputParam((EventINPUTPARAM)ev.getContent());
            } else {
                boolean cfr_ignored_0 = evc instanceof EventGRAMINFO;
            }
        }
        catch (Exception e) {
            this.recogListener_.recogException(e, body);
        }
    }

    public void setScript(String file) {
        try {
            Charset cs = Util.getSystemDefaultCharset();
            String sc = Util.loadFromFile(file, cs);
            this.ecmascript_.evaluate(sc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEventHandler(String func) {
        this._eventHandler = func;
    }
}

