/*
 * Decompiled with CFR 0.152.
 */
package galatea.recogman;

import galatea.recogman.RecogInterpreter;
import galatea.recogman.RecogInterpreterListener;
import galatea.util.AMBuffer;
import galatea.util.Getopt;
import galatea.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecogManager
implements RecogInterpreterListener {
    private AMBuffer ambuf_;
    private RecogInterpreter recogInterpreter_;
    static String xmlContent_ = "";
    private static boolean debugMode = false;
    public static final String COPYRIGHT = "(c)2003-2006 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)\n";

    private void _debugPrint(String str) {
        if (debugMode) {
            System.err.println(str);
        }
    }

    public void run() {
        this.recogInterpreter_ = new RecogInterpreter();
        this.recogInterpreter_.setListener(this);
        this.ambuf_ = new AMBuffer(Util.getSystemDefaultCharset());
        Pattern pattern1 = Pattern.compile("^From @SRM tell [1-9][0-9][0-9] (<.*)$");
        Pattern pattern2 = Pattern.compile("^From @SRM tell (<.*)$");
        boolean multiLineMessage = false;
        while (true) {
            String str;
            if ((str = this.ambuf_.receive()).length() > 0) {
                String s;
                if (multiLineMessage) {
                    s = str.replaceAll("From @SRM ", "");
                    this._fromSRMtell(s);
                } else if (str.startsWith("From @SRM tell << EOM")) {
                    multiLineMessage = true;
                    this._debugPrint("[SIM] multiLine Start ");
                } else if (str.startsWith("From @SRM EOM")) {
                    multiLineMessage = false;
                    this._debugPrint("[SIM] multiLine End");
                } else {
                    Matcher matcher2;
                    Matcher matcher1 = pattern1.matcher(str);
                    if (matcher1.matches()) {
                        this._fromSRMtell(matcher1.group(1));
                    }
                    if ((matcher2 = pattern2.matcher(str)).matches()) {
                        this._fromSRMtell(matcher2.group(1));
                    }
                }
                this._debugPrint(str);
                s = Util.getFirstGroup("set DialogName = (.*)$", str);
                if (s != null) {
                    this.recogInterpreter_.setDialogName(s);
                } else {
                    s = Util.getFirstGroup("set SlotAlias = (.*)$", str);
                    if (s != null) {
                        if (s.equals("RESET")) {
                            this.recogInterpreter_.resetSlotAlias();
                        } else {
                            this.recogInterpreter_.setSlotAlias(s);
                        }
                    } else {
                        s = Util.getFirstGroup("set Script = (.*)$", str);
                        if (s != null) {
                            this.recogInterpreter_.setScript(s);
                        } else {
                            s = Util.getFirstGroup("set EventHandler = (.*)$", str);
                            if (s != null) {
                                this.recogInterpreter_.setEventHandler(s);
                            }
                        }
                    }
                }
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void _send(String str) {
        this.ambuf_.send(str);
    }

    private void _sendRecogState(int s) {
        this._send("to @DIM set RecogState = " + s);
    }

    private void _sendUserSpeakState(int s) {
        this._send("to @DIM set UserSpeakState = " + s);
    }

    @Override
    public void recogListenStarted() {
        this._sendUserSpeakState(0);
    }

    @Override
    public void recogRecordStarted() {
        this._sendUserSpeakState(1);
    }

    @Override
    public void recogRecordFinished() {
        this._sendUserSpeakState(0);
    }

    @Override
    public void recogPass1Finished() {
    }

    @Override
    public void recogPass2Finished() {
        String sc = this.recogInterpreter_.getScript();
        String text = this.recogInterpreter_.getText();
        this._speechRecognized(text, sc);
    }

    @Override
    public void recogFailed() {
    }

    @Override
    public void recogException(Exception e, String str) {
        this._debugPrint("[SIM] recogException(" + str + ")");
        e.printStackTrace();
    }

    private void _fromSRMtell(String s) {
        this._debugPrint("[SIM] [" + xmlContent_ + "] [" + s + "]");
        if (s.startsWith("<STARTPROC/>")) {
            this._debugPrint("[SIM] ignored " + s);
            return;
        }
        if (s.startsWith("<GMM ")) {
            this._debugPrint("[SIM] ignored " + s);
            return;
        }
        s = s.replaceAll("<GRAMMAR STATUS=\"RECEIVED\"/>", "");
        if ((xmlContent_.length() > 0 || s.startsWith("<")) && ((xmlContent_ = String.valueOf(xmlContent_) + s).endsWith("</RECOGOUT>") || xmlContent_.endsWith("</GRAMINFO>"))) {
            block5: {
                try {
                    this.recogInterpreter_.receiveRecogMessage(xmlContent_);
                }
                catch (Exception e) {
                    if (!debugMode) break block5;
                    e.printStackTrace();
                }
            }
            xmlContent_ = "";
        }
    }

    private void _speechRecognized(String text, String script) {
        this._send("to @DM From @SIM tell 300 <ev src=\"SRM\" type=\"INPUT\"><interpreted><text>" + text + "</text>" + "<script>" + script + "</script></interpreted></ev>");
    }

    public static void main(String[] argv) {
        int c;
        Getopt g = new Getopt("", argv, "vd");
        g.setOpterr(false);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 118: {
                    RecogManager.showVersion();
                    break;
                }
                case 100: {
                    debugMode = true;
                }
            }
        }
        RecogManager recogManager = new RecogManager();
        recogManager.run();
    }

    public static void showVersion() {
        System.err.println("RecogManager");
        System.err.println("Galatea Dialog Studio 2.2.1 (080216)");
        System.err.print(COPYRIGHT);
        System.err.println();
    }

    public static void showUsage() {
    }
}

