/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import galatea.util.Util;
import java.util.Enumeration;

public class Property {
    public static boolean getAsBoolean(String name, boolean defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return Integer.parseInt(s) != 0;
    }

    public static double getAsDouble(String name, double defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return Double.parseDouble(s);
    }

    public static int getAsInt(String name, int defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return Integer.parseInt(s);
    }

    public static String getAsStr(String name, String defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return s;
    }

    public static String getConfigStrings() {
        String config = "";
        Enumeration<Object> en = System.getProperties().keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = System.getProperty(key);
            config = String.valueOf(config) + key + "=" + val + "\n";
        }
        return config;
    }

    public static String getForPlatformAsStr(String name, String defval) {
        if (Util.isWindows()) {
            return Property.getAsStr(String.valueOf(name) + ".Windows", defval);
        }
        return Property.getAsStr(name, defval);
    }
}

