/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import galatea.logger.Logger;
import galatea.util.Property;
import galatea.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class SubProcess {
    private Logger dbg = new Logger("SubProcess");
    private String module_command;
    private Runtime rt;
    private Process child;
    private InputStream out;
    private InputStream err;
    private OutputStream in;
    private PrintStream stdin;
    private BufferedReader stdout;
    private BufferedReader stderr;
    private boolean running = false;
    private String error_ = "";

    public SubProcess() {
    }

    public SubProcess(String com) {
        this();
        this.module_command = com;
    }

    public void setCommand(String com) {
        this.module_command = com;
    }

    public boolean runWithShell() {
        if (this.module_command.length() == 0) {
            this.dbg.err("SubProcess.Run(): 'module_command' is undefined.");
            return false;
        }
        String[] com = Util.isWindows() ? new String[]{"cmd", "/C", this.module_command} : new String[]{Property.getAsStr("SubProcess.shell", "/bin/sh"), "-c", this.module_command};
        this.rt = Runtime.getRuntime();
        if (this.rt == null) {
            this.error_ = String.valueOf(this.error_) + "SubProcess.Run(): getRuntime() failed.";
            this.dbg.err("SubProcess.Run(): getRuntime() failed.");
            return false;
        }
        try {
            this.child = this.rt.exec(com);
        }
        catch (IOException e) {
            this.error_ = String.valueOf(this.error_) + e.toString();
            this.dbg.err("SubProcess.Run(): Runtime.exec() failed.");
            return false;
        }
        this.in = this.child.getOutputStream();
        this.out = this.child.getInputStream();
        this.err = this.child.getErrorStream();
        this.stdin = new PrintStream(this.in);
        this.stdout = new BufferedReader(new InputStreamReader(this.out));
        this.stderr = new BufferedReader(new InputStreamReader(this.err));
        this.running = true;
        return true;
    }

    public boolean run(String dirpath) {
        if (this.module_command.length() == 0) {
            String s = "SubProcess.run(): 'module_command' is undefined.";
            this.dbg.err(s);
            this.error_ = String.valueOf(this.error_) + s;
            return false;
        }
        if (Util.isWindows() && this.module_command.length() > 64) {
            String s = "SubProcess.run(): command too long for Windows:" + this.module_command;
            this.dbg.err(s);
            this.error_ = String.valueOf(this.error_) + s;
            return false;
        }
        this.rt = Runtime.getRuntime();
        if (this.rt == null) {
            this.dbg.err("SubProcess.run(): getRuntime() failed.");
            this.error_ = String.valueOf(this.error_) + "SubProcess.run(): getRuntime() failed.";
            return false;
        }
        File dir = new File(dirpath);
        String[] com = this.module_command.split(" ");
        try {
            this.child = this.rt.exec(com, null, dir);
        }
        catch (IOException e) {
            this.error_ = String.valueOf(this.error_) + "SubProcess.run(): Runtime.exec() failed.\n";
            this.error_ = String.valueOf(this.error_) + "dir=" + dir.toString() + "\n";
            this.error_ = String.valueOf(this.error_) + e.toString();
            this.dbg.err("SubProcess.run(): Runtime.exec() failed.");
            return false;
        }
        this.in = this.child.getOutputStream();
        this.out = this.child.getInputStream();
        this.err = this.child.getErrorStream();
        this.stdin = new PrintStream(this.in);
        this.stdout = new BufferedReader(new InputStreamReader(this.out));
        this.stderr = new BufferedReader(new InputStreamReader(this.err));
        this.running = true;
        return true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void sendToStdin(String str) {
        this.dbg.print("ToStdin: " + str, 9);
        this.stdin.println(str);
        this.stdin.flush();
    }

    public String receiveFromStdout() {
        String s;
        if (this.stdout == null) {
            return "";
        }
        try {
            s = this.stdout.readLine();
            this.dbg.print("FromStdout: " + s, 9);
        }
        catch (IOException e) {
            this.error_ = String.valueOf(this.error_) + e.toString();
            this.dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.", 8);
            return null;
        }
        return s;
    }

    public String receiveFromStdoutNB() {
        String s;
        try {
            if (this.stdout != null && this.stdout.ready()) {
                s = this.stdout.readLine();
                this.dbg.print("FromStdoutNB: " + s, 9);
            } else {
                s = "";
            }
        }
        catch (IOException e) {
            this.error_ = String.valueOf(this.error_) + e.toString();
            this.dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.");
            return null;
        }
        return s;
    }

    public String receiveFromStderr() {
        String s;
        if (this.stderr == null) {
            return "";
        }
        try {
            s = this.stderr.readLine();
        }
        catch (IOException e) {
            this.error_ = String.valueOf(this.error_) + e.toString();
            this.dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
            return null;
        }
        return s;
    }

    public String receiveFromStderrNB() {
        String s;
        try {
            s = this.stderr != null && this.stderr.ready() ? this.stderr.readLine() : "";
        }
        catch (IOException e) {
            this.error_ = String.valueOf(this.error_) + e.toString();
            this.dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
            return null;
        }
        return s;
    }

    public void waitFor() throws InterruptedException {
        this.child.waitFor();
        this.running = false;
    }

    public void destroy() {
        this.child.destroy();
        this.running = false;
    }

    public int exitValue() throws IllegalThreadStateException {
        return this.child.exitValue();
    }

    public String getError() {
        return this.error_;
    }

    public void clearError() {
        this.error_ = "";
    }
}

