#!/usr/bin/ruby
#
# (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
# $Id: GUI.rb,v 1.2 2006/11/13 02:32:50 nishi Exp $
#
# GUI for end-user
#
# based on Thread sample:
# http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/5321
#
# to @GUI set Text = message
# to @GUI set F1 = ５分 ゴフン
#
#  F1 F2 F3 F4
#  F5 F6 F7 F8
#

$tk_thread_safe = TRUE
require 'tk'

# -------------

class FuncButton 
  def initialize(parent, lbl, ev)
    @label = lbl
    @event = ev
    @button = TkButton.new(parent) {
      pack('side' => 'left')
    }
    @button.configure('text', @label)
    @button.bind("Button-1", proc { send_button_pressed(@event) })
  end
  def setLabel(str)
    @label = str
    @button.configure('text', @label)
  end
  def setEvent(str)
    @event = str
  end
end

# -------------
def send_button_pressed(name)
  puts "to \@SIM set ButtonPressed = " + name
  puts "to \@MON set AppLogText = pressed " + name
  STDOUT.flush
end

# -------------
def set_button(name, label, event) 
  if name == 'F1' then
    $f1.setLabel label
    $f1.setEvent event
  end
  if name == 'F2' then
    $f2.setLabel label
    $f2.setEvent event
  end
  if name == 'F3' then
    $f3.setLabel label
    $f3.setEvent event
  end
  if name == 'F4' then
    $f4.setLabel label
    $f4.setEvent event
  end
  if name == 'F5' then
    $f5.setLabel label
    $f5.setEvent event
  end
  if name == 'F6' then
    $f6.setLabel label
    $f6.setEvent event
  end
  if name == 'F7' then
    $f7.setLabel label
    $f7.setEvent event
  end
  if name == 'F8' then
    $f8.setLabel label
    $f8.setEvent event
  end
end

# -------------

tktext = nil

Thread.start {
  while gets
    if /^set\s+Text\s+=\s+(.*)$/ =~ $_ then
      str = $1
      unless tktext.nil? then
	tktext.text str
      end
    end 

    if /^set\s+([^\s]+)\s+=\s+([^\s]+)\s+([^\s]+)$/ =~ $_ then
      set_button $1,$2,$3
    end

    if /^set\s+Run\s+=\s+EXIT$/ then
      Process.exit!(0)
    end
  end
}

# -------------

tktext = TkLabel.new {
  relief 'sunken'
  width 35
  pady 10
  borderwidth 3
  pack
}

# -------------

$frame_num1 = TkFrame.new {
  pack
}

$n1 = FuncButton.new($frame_num1, '1', '1')
$n2 = FuncButton.new($frame_num1, '2', '2')
$n3 = FuncButton.new($frame_num1, '3', '3')

# -------------

$frame_num2 = TkFrame.new {
  pack
}

$n4 = FuncButton.new($frame_num2, '4', '4')
$n5 = FuncButton.new($frame_num2, '5', '5')
$n6 = FuncButton.new($frame_num2, '6', '6')

# -------------

$frame_num3 = TkFrame.new {
  pack
}

$n7 = FuncButton.new($frame_num3, '7', '7')
$n8 = FuncButton.new($frame_num3, '8', '8')
$n9 = FuncButton.new($frame_num3, '9', '9')

# -------------

$frame_num4 = TkFrame.new {
  pack
}

$nstar  = FuncButton.new($frame_num4, '*', 'star-key')
$nzero  = FuncButton.new($frame_num4, '0', '0')
$nsharp = FuncButton.new($frame_num4, '#', 'sharp-key')

# -------------

$frame_f1 = TkFrame.new {
  pack
}

$f1 = FuncButton.new($frame_f1, 'はい', 'はい')
$f2 = FuncButton.new($frame_f1, 'いいえ', 'いいえ')
$f3 = FuncButton.new($frame_f1, '戻る', '戻る')
$f4 = FuncButton.new($frame_f1, 'ヘルプ', 'HELP')

# -------------

$frame_f2 = TkFrame.new {
  pack
}

$f5 = FuncButton.new($frame_f2, 'F5', 'F5')
$f6 = FuncButton.new($frame_f2, 'F6', 'F6')
$f7 = FuncButton.new($frame_f2, 'F7', 'F7')
$f8 = FuncButton.new($frame_f2, 'F8', 'F8')

# -------------

Tk.root.title("Galatea GUI")
Tk.mainloop

# end of file
