<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml"/>

<!--
<xsl:template match="list">
<table>
<tbody>
<xsl:apply-templates/>
</tbody>
</table>
</xsl:template>

<xsl:template match="account">
<tr> 
<xsl:apply-templates/>
</tr>
</xsl:template>
-->

<xsl:template match="list">
<div><xsl:apply-templates/></div>
</xsl:template>

<xsl:template match="/list/element">
<section>
<title>&lt;<xsl:value-of select="@name"/>&gt; : <xsl:value-of select="./desc"/>
</title>

<index><xsl:value-of select="@name"/></index>要素は，
<xsl:value-of select="./desc"/>．

<ul>
<li> 実装：
<xsl:choose>
<xsl:when test="@supported = 'true'">対応済</xsl:when>
<xsl:otherwise>未対応</xsl:otherwise>
</xsl:choose> 
</li>
<li> 制約：<xsl:value-of select="./limitation"/> </li>
<li> 起源：<xsl:value-of select="@origin"/> </li>
</ul>

<xsl:value-of select="./note"/> 

<xsl:for-each select="./usage">
<program title="{../@name}要素の使用例"><xsl:value-of select="."/></program>
</xsl:for-each>

<xsl:for-each select="./ref">
詳細は，<xsl:value-of select="."/>要素を参照すること．
</xsl:for-each>

<xsl:apply-templates/>
</section>
</xsl:template>

<xsl:template match="desc"/>
<xsl:template match="note"/>
<xsl:template match="limitation"/>
<xsl:template match="usage"/>
<xsl:template match="ref"/>

<xsl:template match="attributes">
<dl>
<xsl:apply-templates/>
</dl>
</xsl:template>

<xsl:template match="attribute">

<dt> <xsl:value-of select="@name"/> 属性 </dt>
<dd>
<ul>
<li>実装：
<xsl:choose>
<xsl:when test="@supported = 'true'">対応済</xsl:when>
<xsl:otherwise>未対応</xsl:otherwise>
</xsl:choose> 
</li>
<li>用途：<xsl:value-of select="./desc"/></li>
<li>省略時：<xsl:value-of select="./default"/> </li>
<li>備考：<xsl:value-of select="./note"/></li>
</ul>
</dd>

</xsl:template>

<xsl:template match="child-of">
<dl>
<dt><xsl:value-of select="../@name"/>要素の使用環境</dt>
<dd>
<ul>
<xsl:apply-templates/>
</ul>
</dd>
</dl>
</xsl:template>

<xsl:template match="//child-of/element">
<li><xsl:value-of select="text()"/></li>
</xsl:template>

<xsl:template match="parent-of">
<dl>
<dt><xsl:value-of select="../@name"/>要素に格納される要素</dt>
<dd>
<ul>
<xsl:apply-templates/>
</ul>
</dd>
</dl>
</xsl:template>

<xsl:template match="//parent-of/element">
<li><xsl:value-of select="text()"/></li>
</xsl:template>

</xsl:stylesheet>
