/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AddOutItemCommand.java,v 1.5 2008/02/13 03:47:26 nishi Exp $
 */

package galatea.command;
import galatea.dialog.RuntimeError;
import galatea.outitem.*;

import java.util.*;

public class AddOutItemCommand extends Command
{
	
	private ArrayList<OutItem> items_;
	
	public AddOutItemCommand(OutItem oi)
	{
		items_ = new ArrayList<OutItem>();
		items_.add(oi);
		// setCondition = "true"
	}
	
	public AddOutItemCommand(OutItem oi, String cond)
	{
		items_ = new ArrayList<OutItem>();
		items_.add(oi);
		setCondition(cond);
	}
	
	public AddOutItemCommand(ArrayList<OutItem> items)
	{
		items_ = items;
	}
	
	public AddOutItemCommand(ArrayList<OutItem> items, String cond)
	{
		items_ = items;
		setCondition(cond);
	}
	
	public String toString()
	{
		String s = "  <add";
		if ( hasCondition() ) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += ">";
		for (int i = 0; i < items_.size(); i++) {
//			s += "   ";
			s += items_.get(i).toString();
//			s += "\n";
		}
		s += "</add>";
		return s;
	}
	
	
	public void execute() throws RuntimeError
	{
		if ( evaluateCondition() == true ) {
			for (int i = 0; i < items_.size(); i++) {
				OutItem oi = (OutItem)items_.get(i);
				oi.setECMAScript(ecmascript_);
				oi.doEvaluate(); 
				// TODO: dequeue したときに eval すべき？
				interpreterContext_.enqueueOutItem(oi);
			}
		}
	}
	
}
