/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: ContentState.java,v 1.5 2008/02/13 03:47:25 nishi Exp $
 */

package galatea.document;

import galatea.command.Command;
import galatea.util.HashArray;

import java.util.ArrayList;
import java.util.Iterator;


public class ContentState
{
	
	private String name_;
	//private boolean isExecOnly_; // イベントをとらない状態か
	private ArrayList<Command> commands_;    // ArrayList<Command>
	private HashArray evtHandler_;     // Map<String, String> (暫定)
	
	/*
	 private String nomatch_;
	 */
	
	public ContentState()
	{
		commands_ = new ArrayList<Command>();
		evtHandler_ = new HashArray(); 
		//evtHandler_ = new Hashtable();
		//isExecOnly_ = true;
		//isExecOnly_ = false;
	}
	
	public ArrayList<Command> getCommands()
	{
		return commands_;
	}
	
	public void addCommand(Command c)
	{
		commands_.add(c);
	}
	
	public void addCommandOnTop(Command c)
	{
		// [0] の直後に insert するために添字 1 を指定
		commands_.add(1,c);
	}
	
	/*
	 public HashArray getEventHandlers()
	 {
	 return evtHandler_;
	 }
	 */ 
	
	public String getEventHandler(String name)
	{
		return (String)evtHandler_.get(name);
	}
	
	// TODO:
	public String getDefaultEventHandler() {
		for ( int k = 0; k < evtHandler_.size(); k++ ) {
			String key = evtHandler_.getKey(k);
			if (key.equals(".*")) {
				return (String)evtHandler_.get(key);
			}
		}
		return null;
	}
	
//	public String findEventHandler(String input)
//	{
//		if (input == null) 
//			return null;
//		// matches を実現する
//		for ( int k = 0; k < evtHandler_.size(); k++ ) {
//			String regex = evtHandler_.getKey(k);
//			if (input.matches(regex)) {
//				return (String)evtHandler_.get(regex);
//			}
//		}
//		return null;
//	}
	
	public String putEventHandler(String name, String next)
	{
		// 失敗したら null
		return (String)evtHandler_.put(name, (Object)next);
	}
	
	public String toString()
	{
		StringBuffer s = new StringBuffer("");
		s.append("<state id=\""+name_+"\"");
		
		/*
		 if ( evtHandler_.has("<next>") ) {
		 s.append(" next=\"" + evtHandler_.get("<next>") + "\"");
		 }
		 */
		
		/*	
		 if (nomatch_ != null) {
		 s.append(" nomatch=\"" + nomatch_ + "\"");
		 }
		 */
		
		s.append(">\n");
		
		//
		// <weather>
		//  <when>今日</when>
		// </weather>
		//
		// <catch object="//weather/when">
		//  <assign var="form_weather.field_when" path="./when">
		//  <script>weather.when$.justfilled = true</script>
		//  <goto>'@weather.@process'</goto>
		// </catch>
		//
		for ( int k = 0; k < evtHandler_.size(); k++ ) {
			String s1 = evtHandler_.getKey(k);
			String s2 = (String)evtHandler_.get(k);
			if (s1.equals(".*")) {
				s.append(" <catch next=\"" + s2 + "\"/>\n");
			} else {
				s.append(" <catch event=\""+ s1 +"\" next=\"" + s2 + "\"/>\n");
			}
			/*
			 if (s1.equals("<next>")) 
			 continue;
			 String s1x = Util.encodeXmlChars(s1);
			 if (s1.equals("<nomatch>")) {
			 s.append(" <nomatch><goto>'"+s2+"'</goto></nomatch>\n");
			 } else {
			 s.append(" <catch text=\""+s1x+"\">\n");
			 s.append("  <goto>'"+s2+"'</goto>\n");
			 s.append(" </catch>\n");
			 }
			 */
		}
		
		//
		// <command>
		//
		s.append(" <cmd>\n");
		Iterator<Command> j = commands_.iterator();
		while ( j.hasNext() ) {
			Command c = (Command) j.next();
			s.append(c.toString());
			s.append("\n");
		}
		s.append(" </cmd>\n");
		
		s.append("</state>\n");
		return s.toString();
	}
	
	
	/*
	 public void setNomatch(String nomatch)
	 {
	 nomatch_ = nomatch;
	 }
	 */
	
	
	public String getName()
	{
		return name_;
	}
	
	public void setName(String s)
	{
		name_ = s;
	}
	
	/*
	 public boolean isExecOnly()
	 {
	 return isExecOnly_;
	 }
	 
	 public void setExecOnly(boolean b)
	 {
	 isExecOnly_ = b;
	 }
	 */
	
	
	public static void main(String args[]) throws Exception
	{
		String s1, regex;
		
		s1 = "赤にして下さい";
		regex = "赤.*";
		System.out.println("match:"+ s1.matches(regex));
		
		s1 = "終了します";
		regex = "(終了します|やめます)";
		System.out.println("match:"+ s1.matches(regex));
	}
}
