/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: GrammarOutItem.java,v 1.7 2008/02/14 02:00:07 nishi Exp $
 */

package galatea.outitem;

import galatea.util.Property;
import galatea.util.Util;

public class GrammarOutItem extends OutItem
{
	private String grammar_;
	private String name_;
	private String dir_;
	
	public GrammarOutItem(String grammar, String name)
	{
		isInstant_ = false;
		isImportant_ = true;
		grammar_ = grammar;
		name_ = name;
		dir_ = Property.getForPlatformAsStr("Grammar.WorkDir", "/tmp");
	}
	
	public String toString()
	{
		return "<grammarout name=\"" + name_ + "\" dir=\"" + dir_ + "\"><![CDATA[" + grammar_ + "]]></grammarout>";
	}
	
	public String getDocument()
	{
		return grammar_;
	}
	
	public String getLocation()
	{
		return dir_ + "/" + name_;
	}
	
}
