/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.event;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>EventEvent</b> is generated from event.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="event">
 *       <oneOrMore>
 *         <ref name="ev"/>
 *       </oneOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="event"&gt;
 *       &lt;oneOrMore&gt;
 *         &lt;ref name="ev"/&gt;
 *       &lt;/oneOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version event.rng (Tue Jul 06 15:45:52 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class EventEvent implements java.io.Serializable, Cloneable {
    // List<EventEv>
    private java.util.List ev_ = new java.util.ArrayList();

    /**
     * Creates a <code>EventEvent</code>.
     *
     */
    public EventEvent() {
    }

    /**
     * Creates a <code>EventEvent</code>.
     *
     * @param source
     */
    public EventEvent(EventEvent source) {
        setup(source);
    }

    /**
     * Creates a <code>EventEvent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EventEvent(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EventEvent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EventEvent(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EventEvent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EventEvent(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EventEvent</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventEvent(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EventEvent</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventEvent(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EventEvent</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventEvent(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EventEvent</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventEvent(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EventEvent</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventEvent(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EventEvent</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventEvent(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EventEvent</code> by the EventEvent <code>source</code>.
     *
     * @param source
     */
    public void setup(EventEvent source) {
        int size;
        this.ev_.clear();
        size = source.ev_.size();
        for (int i = 0;i < size;i++) {
            addEv((EventEv)source.getEv(i).clone());
        }
    }

    /**
     * Initializes the <code>EventEvent</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EventEvent</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EventEvent</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        ev_.clear();
        while (true) {
            if (EventEv.isMatch(stack)) {
                addEv(new EventEv(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new EventEvent((EventEvent)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("event");
        int size;
        size = this.ev_.size();
        for (int i = 0;i < size;i++) {
            EventEv value = (EventEv)this.ev_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EventEvent</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EventEvent</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventEvent</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventEvent</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventEvent</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventEvent</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the EventEv property <b>ev</b>.
     *
     * @return EventEv[]
     */
    public EventEv[] getEv() {
        EventEv[] array = new EventEv[ev_.size()];
        return ((EventEv[])ev_.toArray(array));
    }

    /**
     * Sets the EventEv property <b>ev</b>.
     *
     * @param ev
     */
    public void setEv(EventEv[] ev) {
        this.ev_.clear();
        for (int i = 0;i < ev.length;i++) {
            addEv(ev[i]);
        }
    }

    /**
     * Sets the EventEv property <b>ev</b>.
     *
     * @param ev
     */
    public void setEv(EventEv ev) {
        this.ev_.clear();
        addEv(ev);
    }

    /**
     * Adds the EventEv property <b>ev</b>.
     *
     * @param ev
     */
    public void addEv(EventEv ev) {
        this.ev_.add(ev);
    }

    /**
     * Adds the EventEv property <b>ev</b>.
     *
     * @param ev
     */
    public void addEv(EventEv[] ev) {
        for (int i = 0;i < ev.length;i++) {
            addEv(ev[i]);
        }
    }

    /**
     * Gets number of the EventEv property <b>ev</b>.
     *
     * @return int
     */
    public int sizeEv() {
        return (ev_.size());
    }

    /**
     * Gets the EventEv property <b>ev</b> by index.
     *
     * @param index
     * @return EventEv
     */
    public EventEv getEv(int index) {
        return ((EventEv)ev_.get(index));
    }

    /**
     * Sets the EventEv property <b>ev</b> by index.
     *
     * @param index
     * @param ev
     */
    public void setEv(int index, EventEv ev) {
        this.ev_.set(index, ev);
    }

    /**
     * Adds the EventEv property <b>ev</b> by index.
     *
     * @param index
     * @param ev
     */
    public void addEv(int index, EventEv ev) {
        this.ev_.add(index, ev);
    }

    /**
     * Remove the EventEv property <b>ev</b> by index.
     *
     * @param index
     */
    public void removeEv(int index) {
        this.ev_.remove(index);
    }

    /**
     * Remove the EventEv property <b>ev</b> by object.
     *
     * @param ev
     */
    public void removeEv(EventEv ev) {
        this.ev_.remove(ev);
    }

    /**
     * Clear the EventEv property <b>ev</b>.
     *
     */
    public void clearEv() {
        this.ev_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<event");
        buffer.append(">");
        size = this.ev_.size();
        for (int i = 0;i < size;i++) {
            EventEv value = (EventEv)this.ev_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</event>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<event");
        buffer.write(">");
        size = this.ev_.size();
        for (int i = 0;i < size;i++) {
            EventEv value = (EventEv)this.ev_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</event>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<event");
        buffer.print(">");
        size = this.ev_.size();
        for (int i = 0;i < size;i++) {
            EventEv value = (EventEv)this.ev_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</event>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EventEvent</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "event")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!EventEv.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!EventEv.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventEvent</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventEvent</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
