/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

/**
 * @version vxml20.rng 1.0 (Wed Jul 07 07:19:14 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public interface IRVisitor {
    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlAlias visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlAlias visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlMetaSrgs visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlMetaSrgs visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlRuleref visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlRuleref visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlToken visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlToken visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlOneOf visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlOneOf visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlTag visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlTag visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlItem visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlItem visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlExample visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlExample visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlRule visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlRule visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlLexicon visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlLexicon visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlGrammar visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlGrammar visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlLink visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlLink visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlScript visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlScript visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlREGWORD visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlREGWORD visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlBreak visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlBreak visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlPhoneme visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlPhoneme visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlSayAs visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlSayAs visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlValue visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlValue visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlMark visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlMark visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlBOOKMARK visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlBOOKMARK visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlSILENCE visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlSILENCE visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlRESET visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlRESET visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlEnumerate visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlEnumerate visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlEMPH visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlEMPH visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlSPEECH visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlSPEECH visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlSPELL visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlSPELL visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlRATE visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlRATE visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlEmphasis visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlEmphasis visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlPARTOFSP visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlPARTOFSP visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlLANG visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlLANG visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlS visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlS visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlVOLUME visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlVOLUME visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlSentence visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlSentence visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlP visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlP visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlPRON visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlPRON visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlParagraph visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlParagraph visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlPITCH visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlPITCH visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlJVOICE visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlJVOICE visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlCONTEXT visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlCONTEXT visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlEmotion visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlEmotion visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlVoice visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlVoice visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlAudio visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlAudio visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlProsody visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlProsody visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlChoice visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlChoice visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlNative visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlNative visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlLog visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlLog visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlMedia visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlMedia visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlAllOf visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlAllOf visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlPrompt visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlPrompt visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlSubmit visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlSubmit visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlGoto visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlGoto visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlThrow visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlThrow visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlAssign visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlAssign visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlExit visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlExit visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlReturn visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlReturn visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlVar visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlVar visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlClear visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlClear visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlElseif visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlElseif visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlDisconnect visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlDisconnect visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlReprompt visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlReprompt visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlElse visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlElse visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlIf visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlIf visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlCatch visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlCatch visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlNoinput visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlNoinput visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlHelp visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlHelp visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlNomatch visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlNomatch visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlError visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlError visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlProperty visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlProperty visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlMenu visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlMenu visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlMeta visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlMeta visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlParam visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlParam visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlFilled visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlFilled visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlObject visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlObject visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlSubdialog visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlSubdialog visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlRecord visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlRecord visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlTransfer visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlTransfer visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlOption visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlOption visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlField visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlField visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlBlock visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlBlock visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlInitial visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlInitial visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlForm visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlForm visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlVxml visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlVxml visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlMediaRef visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlMediaRef visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(VxmlMediaMixed visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(VxmlMediaMixed visitable);

    /**
     * Visits this node for enter behavior.
     *
     * @param visitable
     * @return boolean
     */
    boolean enter(RString visitable);

    /**
     * Visits this node for leave behavior.
     *
     * @param visitable
     */
    void leave(RString visitable);
}
