/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlTransfer</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="transfer">
 *       <optional>
 *         <attribute name="name">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="cond">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="expr">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="dest">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="destexpr">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="bridge">
 *           <choice>
 *             <value type="NMTOKEN">true</value>
 *             <value type="NMTOKEN">false</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="connecttimeout">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxtime">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="transferaudio">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <mixed>
 *         <zeroOrMore>
 *           <choice>
 *             <zeroOrMore>
 *               <ref name="grammar"/>
 *             </zeroOrMore>
 *             <ref name="audio"/>
 *             <ref name="prompt"/>
 *             <ref name="catch"/>
 *             <ref name="help"/>
 *             <ref name="noinput"/>
 *             <ref name="error"/>
 *             <ref name="filled"/>
 *             <ref name="nomatch"/>
 *             <ref name="property"/>
 *             <ref name="enumerate"/>
 *             <ref name="value"/>
 *           </choice>
 *         </zeroOrMore>
 *       </mixed>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="transfer"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="name"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="cond"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="expr"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="dest"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="destexpr"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="bridge"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;true&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;false&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="connecttimeout"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxtime"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="transferaudio"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;mixed&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;choice&gt;
 *             &lt;zeroOrMore&gt;
 *               &lt;ref name="grammar"/&gt;
 *             &lt;/zeroOrMore&gt;
 *             &lt;ref name="audio"/&gt;
 *             &lt;ref name="prompt"/&gt;
 *             &lt;ref name="catch"/&gt;
 *             &lt;ref name="help"/&gt;
 *             &lt;ref name="noinput"/&gt;
 *             &lt;ref name="error"/&gt;
 *             &lt;ref name="filled"/&gt;
 *             &lt;ref name="nomatch"/&gt;
 *             &lt;ref name="property"/&gt;
 *             &lt;ref name="enumerate"/&gt;
 *             &lt;ref name="value"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/mixed&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:11 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlTransfer implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlFormChoice {
    public static final String BRIDGE_TRUE = "true";
    public static final String BRIDGE_FALSE = "false";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String name_;
    private String cond_;
    private String expr_;
    private String dest_;
    private String destexpr_;
    private String bridge_;
    private String connecttimeout_;
    private String maxtime_;
    private String transferaudio_;
    // List<IVxmlTransferMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlTransfer</code>.
     *
     */
    public VxmlTransfer() {
    }

    /**
     * Creates a <code>VxmlTransfer</code>.
     *
     * @param source
     */
    public VxmlTransfer(VxmlTransfer source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlTransfer(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlTransfer(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlTransfer(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlTransfer</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the VxmlTransfer <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlTransfer source) {
        int size;
        name_ = source.name_;
        cond_ = source.cond_;
        expr_ = source.expr_;
        dest_ = source.dest_;
        destexpr_ = source.destexpr_;
        bridge_ = source.bridge_;
        connecttimeout_ = source.connecttimeout_;
        maxtime_ = source.maxtime_;
        transferaudio_ = source.transferaudio_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlTransferMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        expr_ = URelaxer.getAttributePropertyAsString(element, "expr");
        dest_ = URelaxer.getAttributePropertyAsString(element, "dest");
        destexpr_ = URelaxer.getAttributePropertyAsString(element, "destexpr");
        bridge_ = URelaxer.getAttributePropertyAsString(element, "bridge");
        connecttimeout_ = URelaxer.getAttributePropertyAsString(element, "connecttimeout");
        maxtime_ = URelaxer.getAttributePropertyAsString(element, "maxtime");
        transferaudio_ = URelaxer.getAttributePropertyAsString(element, "transferaudio");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlGrammar.isMatch(stack)) {
                addContent(new VxmlGrammar(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlPrompt.isMatch(stack)) {
                addContent(new VxmlPrompt(stack));
            } else if (VxmlCatch.isMatch(stack)) {
                addContent(new VxmlCatch(stack));
            } else if (VxmlError.isMatch(stack)) {
                addContent(new VxmlError(stack));
            } else if (VxmlHelp.isMatch(stack)) {
                addContent(new VxmlHelp(stack));
            } else if (VxmlNoinput.isMatch(stack)) {
                addContent(new VxmlNoinput(stack));
            } else if (VxmlFilled.isMatch(stack)) {
                addContent(new VxmlFilled(stack));
            } else if (VxmlNomatch.isMatch(stack)) {
                addContent(new VxmlNomatch(stack));
            } else if (VxmlProperty.isMatch(stack)) {
                addContent(new VxmlProperty(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlTransfer((VxmlTransfer)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "transfer");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        if (this.expr_ != null) {
            URelaxer.setAttributePropertyByString(element, "expr", this.expr_);
        }
        if (this.dest_ != null) {
            URelaxer.setAttributePropertyByString(element, "dest", this.dest_);
        }
        if (this.destexpr_ != null) {
            URelaxer.setAttributePropertyByString(element, "destexpr", this.destexpr_);
        }
        if (this.bridge_ != null) {
            URelaxer.setAttributePropertyByString(element, "bridge", this.bridge_);
        }
        if (this.connecttimeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "connecttimeout", this.connecttimeout_);
        }
        if (this.maxtime_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxtime", this.maxtime_);
        }
        if (this.transferaudio_ != null) {
            URelaxer.setAttributePropertyByString(element, "transferaudio", this.transferaudio_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlTransfer</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the String property <b>expr</b>.
     *
     * @return String
     */
    public String getExpr() {
        return (expr_);
    }

    /**
     * Sets the String property <b>expr</b>.
     *
     * @param expr
     */
    public void setExpr(String expr) {
        this.expr_ = expr;
    }

    /**
     * Gets the String property <b>dest</b>.
     *
     * @return String
     */
    public String getDest() {
        return (dest_);
    }

    /**
     * Sets the String property <b>dest</b>.
     *
     * @param dest
     */
    public void setDest(String dest) {
        this.dest_ = dest;
    }

    /**
     * Gets the String property <b>destexpr</b>.
     *
     * @return String
     */
    public String getDestexpr() {
        return (destexpr_);
    }

    /**
     * Sets the String property <b>destexpr</b>.
     *
     * @param destexpr
     */
    public void setDestexpr(String destexpr) {
        this.destexpr_ = destexpr;
    }

    /**
     * Gets the String property <b>bridge</b>.
     *
     * @return String
     */
    public String getBridge() {
        return (bridge_);
    }

    /**
     * Sets the String property <b>bridge</b>.
     *
     * @param bridge
     */
    public void setBridge(String bridge) {
        this.bridge_ = bridge;
    }

    /**
     * Gets the String property <b>connecttimeout</b>.
     *
     * @return String
     */
    public String getConnecttimeout() {
        return (connecttimeout_);
    }

    /**
     * Sets the String property <b>connecttimeout</b>.
     *
     * @param connecttimeout
     */
    public void setConnecttimeout(String connecttimeout) {
        this.connecttimeout_ = connecttimeout;
    }

    /**
     * Gets the String property <b>maxtime</b>.
     *
     * @return String
     */
    public String getMaxtime() {
        return (maxtime_);
    }

    /**
     * Sets the String property <b>maxtime</b>.
     *
     * @param maxtime
     */
    public void setMaxtime(String maxtime) {
        this.maxtime_ = maxtime;
    }

    /**
     * Gets the String property <b>transferaudio</b>.
     *
     * @return String
     */
    public String getTransferaudio() {
        return (transferaudio_);
    }

    /**
     * Sets the String property <b>transferaudio</b>.
     *
     * @param transferaudio
     */
    public void setTransferaudio(String transferaudio) {
        this.transferaudio_ = transferaudio;
    }

    /**
     * Gets the IVxmlTransferMixed property <b>content</b>.
     *
     * @return IVxmlTransferMixed[]
     */
    public IVxmlTransferMixed[] getContent() {
        IVxmlTransferMixed[] array = new IVxmlTransferMixed[content_.size()];
        return ((IVxmlTransferMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlTransferMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlTransferMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlTransferMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlTransferMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlTransferMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlTransferMixed
     */
    public IVxmlTransferMixed getContent(int index) {
        return ((IVxmlTransferMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlTransferMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlTransferMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlTransferMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlTransferMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlTransferMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "transfer", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.append(" ");
            buffer.append("name");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        if (cond_ != null) {
            buffer.append(" ");
            buffer.append("cond");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        if (expr_ != null) {
            buffer.append(" ");
            buffer.append("expr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.append("\"");
        }
        if (dest_ != null) {
            buffer.append(" ");
            buffer.append("dest");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDest())));
            buffer.append("\"");
        }
        if (destexpr_ != null) {
            buffer.append(" ");
            buffer.append("destexpr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDestexpr())));
            buffer.append("\"");
        }
        if (bridge_ != null) {
            buffer.append(" ");
            buffer.append("bridge");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getBridge())));
            buffer.append("\"");
        }
        if (connecttimeout_ != null) {
            buffer.append(" ");
            buffer.append("connecttimeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getConnecttimeout())));
            buffer.append("\"");
        }
        if (maxtime_ != null) {
            buffer.append(" ");
            buffer.append("maxtime");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxtime())));
            buffer.append("\"");
        }
        if (transferaudio_ != null) {
            buffer.append(" ");
            buffer.append("transferaudio");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getTransferaudio())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "transfer", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "transfer", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.write(" ");
            buffer.write("name");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        if (cond_ != null) {
            buffer.write(" ");
            buffer.write("cond");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        if (expr_ != null) {
            buffer.write(" ");
            buffer.write("expr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.write("\"");
        }
        if (dest_ != null) {
            buffer.write(" ");
            buffer.write("dest");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDest())));
            buffer.write("\"");
        }
        if (destexpr_ != null) {
            buffer.write(" ");
            buffer.write("destexpr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDestexpr())));
            buffer.write("\"");
        }
        if (bridge_ != null) {
            buffer.write(" ");
            buffer.write("bridge");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getBridge())));
            buffer.write("\"");
        }
        if (connecttimeout_ != null) {
            buffer.write(" ");
            buffer.write("connecttimeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getConnecttimeout())));
            buffer.write("\"");
        }
        if (maxtime_ != null) {
            buffer.write(" ");
            buffer.write("maxtime");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxtime())));
            buffer.write("\"");
        }
        if (transferaudio_ != null) {
            buffer.write(" ");
            buffer.write("transferaudio");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getTransferaudio())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "transfer", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "transfer", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.print(" ");
            buffer.print("name");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        if (cond_ != null) {
            buffer.print(" ");
            buffer.print("cond");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        if (expr_ != null) {
            buffer.print(" ");
            buffer.print("expr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.print("\"");
        }
        if (dest_ != null) {
            buffer.print(" ");
            buffer.print("dest");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDest())));
            buffer.print("\"");
        }
        if (destexpr_ != null) {
            buffer.print(" ");
            buffer.print("destexpr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDestexpr())));
            buffer.print("\"");
        }
        if (bridge_ != null) {
            buffer.print(" ");
            buffer.print("bridge");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getBridge())));
            buffer.print("\"");
        }
        if (connecttimeout_ != null) {
            buffer.print(" ");
            buffer.print("connecttimeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getConnecttimeout())));
            buffer.print("\"");
        }
        if (maxtime_ != null) {
            buffer.print(" ");
            buffer.print("maxtime");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxtime())));
            buffer.print("\"");
        }
        if (transferaudio_ != null) {
            buffer.print(" ");
            buffer.print("transferaudio");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getTransferaudio())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "transfer", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getExprAsString() {
        return (URelaxer.getString(getExpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDestAsString() {
        return (URelaxer.getString(getDest()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDestexprAsString() {
        return (URelaxer.getString(getDestexpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getBridgeAsString() {
        return (URelaxer.getString(getBridge()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getConnecttimeoutAsString() {
        return (URelaxer.getString(getConnecttimeout()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxtimeAsString() {
        return (URelaxer.getString(getMaxtime()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTransferaudioAsString() {
        return (URelaxer.getString(getTransferaudio()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setExprByString(String string) {
        setExpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDestByString(String string) {
        setDest(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDestexprByString(String string) {
        setDestexpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setBridgeByString(String string) {
        setBridge(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setConnecttimeoutByString(String string) {
        setConnecttimeout(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxtimeByString(String string) {
        setMaxtime(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTransferaudioByString(String string) {
        setTransferaudio(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlTransfer</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "transfer")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlGrammar.isMatchHungry(target)) {
                $match$ = true;
                while (VxmlGrammar.isMatchHungry(target)) {
                }
            } else if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPrompt.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlError.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlHelp.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNoinput.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlFilled.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNomatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProperty.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlTransfer</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlTransfer</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
