/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlVxml</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="vxml">
 *       <optional>
 *         <attribute name="application">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="base">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="lang">
 *           <data type="language"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="space">
 *           <choice>
 *             <value>default</value>
 *             <value>preserve</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <attribute name="version">
 *         <text/>
 *       </attribute>
 *       <oneOrMore>
 *         <choice>
 *           <ref name="link"/>
 *           <oneOrMore>
 *             <ref name="grammar"/>
 *           </oneOrMore>
 *           <ref name="script"/>
 *           <ref name="menu"/>
 *           <ref name="catch"/>
 *           <ref name="help"/>
 *           <ref name="noinput"/>
 *           <ref name="error"/>
 *           <ref name="meta"/>
 *           <ref name="nomatch"/>
 *           <ref name="form"/>
 *           <ref name="property"/>
 *           <ref name="var"/>
 *         </choice>
 *       </oneOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="vxml"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="application"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="base"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="lang"&gt;
 *           &lt;data type="language"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="space"&gt;
 *           &lt;choice&gt;
 *             &lt;value&gt;default&lt;/value&gt;
 *             &lt;value&gt;preserve&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;attribute name="version"&gt;
 *         &lt;text/&gt;
 *       &lt;/attribute&gt;
 *       &lt;oneOrMore&gt;
 *         &lt;choice&gt;
 *           &lt;ref name="link"/&gt;
 *           &lt;oneOrMore&gt;
 *             &lt;ref name="grammar"/&gt;
 *           &lt;/oneOrMore&gt;
 *           &lt;ref name="script"/&gt;
 *           &lt;ref name="menu"/&gt;
 *           &lt;ref name="catch"/&gt;
 *           &lt;ref name="help"/&gt;
 *           &lt;ref name="noinput"/&gt;
 *           &lt;ref name="error"/&gt;
 *           &lt;ref name="meta"/&gt;
 *           &lt;ref name="nomatch"/&gt;
 *           &lt;ref name="form"/&gt;
 *           &lt;ref name="property"/&gt;
 *           &lt;ref name="var"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/oneOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:10 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlVxml implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode {
    public static final String SPACE_DEFAULT = "default";
    public static final String SPACE_PRESERVE = "preserve";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String application_;
    private String base_;
    private java.util.Locale lang_;
    private String space_;
    private String version_;
    // List<IVxmlVxmlChoice>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlVxml</code>.
     *
     */
    public VxmlVxml() {
        version_ = "";
    }

    /**
     * Creates a <code>VxmlVxml</code>.
     *
     * @param source
     */
    public VxmlVxml(VxmlVxml source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlVxml</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlVxml(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlVxml</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlVxml(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlVxml</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlVxml(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlVxml</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlVxml(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlVxml</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlVxml(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlVxml</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlVxml(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlVxml</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlVxml(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlVxml</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlVxml(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlVxml</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlVxml(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the VxmlVxml <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlVxml source) {
        int size;
        application_ = source.application_;
        base_ = source.base_;
        lang_ = source.lang_;
        space_ = source.space_;
        version_ = source.version_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlVxmlChoice)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        application_ = URelaxer.getAttributePropertyAsString(element, "application");
        base_ = URelaxer.getAttributePropertyAsString(element, "base");
        lang_ = URelaxer.getAttributePropertyAsLocale(element, "lang");
        space_ = URelaxer.getAttributePropertyAsString(element, "space");
        version_ = URelaxer.getAttributePropertyAsString(element, "version");
        content_.clear();
        while (true) {
            if (VxmlLink.isMatch(stack)) {
                addContent(new VxmlLink(stack));
            } else if (VxmlGrammar.isMatch(stack)) {
                addContent(new VxmlGrammar(stack));
            } else if (VxmlScript.isMatch(stack)) {
                addContent(new VxmlScript(stack));
            } else if (VxmlMenu.isMatch(stack)) {
                addContent(new VxmlMenu(stack));
            } else if (VxmlCatch.isMatch(stack)) {
                addContent(new VxmlCatch(stack));
            } else if (VxmlHelp.isMatch(stack)) {
                addContent(new VxmlHelp(stack));
            } else if (VxmlError.isMatch(stack)) {
                addContent(new VxmlError(stack));
            } else if (VxmlMeta.isMatch(stack)) {
                addContent(new VxmlMeta(stack));
            } else if (VxmlNomatch.isMatch(stack)) {
                addContent(new VxmlNomatch(stack));
            } else if (VxmlForm.isMatch(stack)) {
                addContent(new VxmlForm(stack));
            } else if (VxmlNoinput.isMatch(stack)) {
                addContent(new VxmlNoinput(stack));
            } else if (VxmlProperty.isMatch(stack)) {
                addContent(new VxmlProperty(stack));
            } else if (VxmlVar.isMatch(stack)) {
                addContent(new VxmlVar(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlVxml((VxmlVxml)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "vxml");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.application_ != null) {
            URelaxer.setAttributePropertyByString(element, "application", this.application_);
        }
        if (this.base_ != null) {
            URelaxer.setAttributePropertyByString(element, "base", this.base_);
        }
        if (this.lang_ != null) {
            URelaxer.setAttributePropertyByLocale(element, "lang", this.lang_);
        }
        if (this.space_ != null) {
            URelaxer.setAttributePropertyByString(element, "space", this.space_);
        }
        if (this.version_ != null) {
            URelaxer.setAttributePropertyByString(element, "version", this.version_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlVxmlChoice value = (IVxmlVxmlChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlVxml</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlVxml</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>application</b>.
     *
     * @return String
     */
    public String getApplication() {
        return (application_);
    }

    /**
     * Sets the String property <b>application</b>.
     *
     * @param application
     */
    public void setApplication(String application) {
        this.application_ = application;
    }

    /**
     * Gets the String property <b>base</b>.
     *
     * @return String
     */
    public String getBase() {
        return (base_);
    }

    /**
     * Sets the String property <b>base</b>.
     *
     * @param base
     */
    public void setBase(String base) {
        this.base_ = base;
    }

    /**
     * Gets the java.util.Locale property <b>lang</b>.
     *
     * @return java.util.Locale
     */
    public java.util.Locale getLang() {
        return (lang_);
    }

    /**
     * Sets the java.util.Locale property <b>lang</b>.
     *
     * @param lang
     */
    public void setLang(java.util.Locale lang) {
        this.lang_ = lang;
    }

    /**
     * Gets the String property <b>space</b>.
     *
     * @return String
     */
    public String getSpace() {
        return (space_);
    }

    /**
     * Sets the String property <b>space</b>.
     *
     * @param space
     */
    public void setSpace(String space) {
        this.space_ = space;
    }

    /**
     * Gets the String property <b>version</b>.
     *
     * @return String
     */
    public String getVersion() {
        return (version_);
    }

    /**
     * Sets the String property <b>version</b>.
     *
     * @param version
     */
    public void setVersion(String version) {
        this.version_ = version;
    }

    /**
     * Gets the IVxmlVxmlChoice property <b>content</b>.
     *
     * @return IVxmlVxmlChoice[]
     */
    public IVxmlVxmlChoice[] getContent() {
        IVxmlVxmlChoice[] array = new IVxmlVxmlChoice[content_.size()];
        return ((IVxmlVxmlChoice[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlVxmlChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlVxmlChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlVxmlChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlVxmlChoice content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlVxmlChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlVxmlChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlVxmlChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlVxmlChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlVxmlChoice property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlVxmlChoice property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlVxmlChoice
     */
    public IVxmlVxmlChoice getContent(int index) {
        return ((IVxmlVxmlChoice)content_.get(index));
    }

    /**
     * Sets the IVxmlVxmlChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlVxmlChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlVxmlChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlVxmlChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlVxmlChoice property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlVxmlChoice property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlVxmlChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlVxmlChoice property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "vxml", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (application_ != null) {
            buffer.append(" ");
            buffer.append("application");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getApplication())));
            buffer.append("\"");
        }
        if (base_ != null) {
            buffer.append(" ");
            buffer.append("base");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getBase())));
            buffer.append("\"");
        }
        if (lang_ != null) {
            buffer.append(" ");
            buffer.append("lang");
            buffer.append("=\"");
            buffer.append(URelaxer.getString(getLang()));
            buffer.append("\"");
        }
        if (space_ != null) {
            buffer.append(" ");
            buffer.append("space");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getSpace())));
            buffer.append("\"");
        }
        if (version_ != null) {
            buffer.append(" ");
            buffer.append("version");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getVersion())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlVxmlChoice value = (IVxmlVxmlChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlVxmlChoice value = (IVxmlVxmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "vxml", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "vxml", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (application_ != null) {
            buffer.write(" ");
            buffer.write("application");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getApplication())));
            buffer.write("\"");
        }
        if (base_ != null) {
            buffer.write(" ");
            buffer.write("base");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getBase())));
            buffer.write("\"");
        }
        if (lang_ != null) {
            buffer.write(" ");
            buffer.write("lang");
            buffer.write("=\"");
            buffer.write(URelaxer.getString(getLang()));
            buffer.write("\"");
        }
        if (space_ != null) {
            buffer.write(" ");
            buffer.write("space");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getSpace())));
            buffer.write("\"");
        }
        if (version_ != null) {
            buffer.write(" ");
            buffer.write("version");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getVersion())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlVxmlChoice value = (IVxmlVxmlChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlVxmlChoice value = (IVxmlVxmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "vxml", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "vxml", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (application_ != null) {
            buffer.print(" ");
            buffer.print("application");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getApplication())));
            buffer.print("\"");
        }
        if (base_ != null) {
            buffer.print(" ");
            buffer.print("base");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getBase())));
            buffer.print("\"");
        }
        if (lang_ != null) {
            buffer.print(" ");
            buffer.print("lang");
            buffer.print("=\"");
            buffer.print(URelaxer.getString(getLang()));
            buffer.print("\"");
        }
        if (space_ != null) {
            buffer.print(" ");
            buffer.print("space");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getSpace())));
            buffer.print("\"");
        }
        if (version_ != null) {
            buffer.print(" ");
            buffer.print("version");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getVersion())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlVxmlChoice value = (IVxmlVxmlChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlVxmlChoice value = (IVxmlVxmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "vxml", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getApplicationAsString() {
        return (URelaxer.getString(getApplication()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getBaseAsString() {
        return (URelaxer.getString(getBase()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLangAsString() {
        return (URelaxer.getString(getLang()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSpaceAsString() {
        return (URelaxer.getString(getSpace()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getVersionAsString() {
        return (URelaxer.getString(getVersion()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setApplicationByString(String string) {
        setApplication(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setBaseByString(String string) {
        setBase(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLangByString(String string) {
        setLang(URelaxer.getLocale(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSpaceByString(String string) {
        setSpace(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setVersionByString(String string) {
        setVersion(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlVxml</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "vxml")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "version")) {
            return (false);
        }
        $match$ = true;
        if (VxmlLink.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlGrammar.isMatchHungry(target)) {
            $match$ = true;
            while (VxmlGrammar.isMatchHungry(target)) {
            }
        } else if (VxmlScript.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlMenu.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlCatch.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlHelp.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlError.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlMeta.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlNomatch.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlForm.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlNoinput.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlProperty.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlVar.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (true) {
            if (VxmlLink.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlGrammar.isMatchHungry(target)) {
                    $match$ = true;
            while (VxmlGrammar.isMatchHungry(target)) {
                }
            } else if (VxmlScript.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMenu.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlHelp.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlError.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMeta.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNomatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlForm.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNoinput.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProperty.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVar.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlVxml</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlVxml</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
