/**
 * $Id: AbstractSubModule.java,v 1.8 2006/12/18 00:55:17 nishi Exp $
 */
package galatea.submodule;

import galatea.dialog.ISystemEventLogger;
import galatea.dialog.RuntimeError;
import galatea.io.ISenderToDevice;
import galatea.outitem.OutItem;

public class AbstractSubModule implements ISubModule {

	protected ISenderToDevice sender_;
	protected IReceiverFromSubModule receiver_;
	protected ISystemEventLogger logger_;
	private String name_ = "";
	
	public ISubModule setLogger(ISystemEventLogger logger) {
		logger_ = logger;
		return this;
	}

	public ISubModule setSender(ISenderToDevice sender) {
		this.sender_ = sender;
		return this;
	}
	
	public ISubModule setReceiver(IReceiverFromSubModule receiver) {
		this.receiver_ = receiver;
		return this;
	}
	
	public boolean receiveFromDevice(String str) {
		return false;
	}

	public boolean filterOutputNative(String str) {
		return false;
	}

	public void doTimerTask() throws RuntimeError {
		// do nothing
	}

	public String getName() {
		return name_;
	}

	public void setName(String s) {
		this.name_ = s;
	}
	
	public boolean startOutput(OutItem item) {
		// do nothing
		return false;
	}

	public boolean stopOutput(OutItem item) {
		// do nothing
		return false;
	}

	public void setTargetRunLevel(int i) {
		this.receiver_.receiveRunLevel(i, this);
	}

}
