/*
 * $Id: Property.java,v 1.4 2008/02/14 03:36:08 nishi Exp $
 */
package galatea.util;

import java.util.Enumeration;

public class Property 
{
	public static boolean getAsBoolean(String name, boolean defval) {
		String s = System.getProperty(name, null);
		if ( s == null ) 
			return defval;
		return (Integer.parseInt(s) != 0);
	}

	public static double getAsDouble(String name, double defval) {
		String s = System.getProperty(name, null);
		if ( s == null ) 
			return defval;
		return Double.parseDouble(s);
	}

	public static int getAsInt(String name, int defval)
	{
		String s = System.getProperty(name, null);
		if ( s == null ) 
			return defval;
		return Integer.parseInt(s);
	}

	public static String getAsStr(String name, String defval)
	{
		String s = System.getProperty(name, null);
		if ( s == null ) 
			return defval;
		return s;
	}

	// TODO: sort by keys
	public static String getConfigStrings() {
		String config = "";
		for (Enumeration<Object> en = System.getProperties().keys(); en.hasMoreElements(); ) {
			String key = (String)(en.nextElement());
			String val = System.getProperty(key);
			// System.err.printf("%s=%s\n", key, val);
			config += key + "=" + val + "\n";
		}
		return config;
	}

	/**
	 * introduced to avoid "if Util.isWindows() / else" 
	 * @param name
	 * @param defval
	 * @return
	 */
	public static String getForPlatformAsStr(String name, String defval)
	{
		if (Util.isWindows()) {
			return Property.getAsStr( name + ".Windows", defval );
		}
		return Property.getAsStr(name, defval);
	}

}
