/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: StrQueue.java,v 1.4 2008/02/12 06:15:29 nishi Exp $
 */
package galatea.util;

import java.util.ArrayList;

public class StrQueue
{
	private ArrayList<String> queue_ = null;
	
	public StrQueue()
	{
		queue_ = new ArrayList<String>();
	}
	
	public void enqueue(String str)
	{
		synchronized(queue_) {
			queue_.add(str);
		}
	}
	
	public String dequeue()
	{
		String str = "";
		if (queue_.isEmpty()) {
			return "";
		} else {
			synchronized(queue_) {
				str = (String)queue_.remove(0);
			}
		}
		return str;
	}
	
}
