
;;------------------------------------------------------------
;;	mode3 font demo
;;
;;	note : r13=sp, r14=lr, r15=pc, r16=cpsr
;;------------------------------------------------------------

@arm
@fsize	32
	b		agb_main

@dup	dcb 0xba, 0x00			; vOwb_[̈

agb_main:
	mov		r0, #0x4000000
	mov		r1, #0x400
	add		r1, r1, #0x3
	str		r1, [r0]			; mode3ɐݒ

	bl		wait_vbk			; A҂

;	mov		r0, #40
;	mov		r1, #50
;	mov		r2, #'C'
;	stm		sp!, {r0-r2}
;	bl		putchar

	mov		r0, #80
	mov		r1, #60
	mov		r2, data_str
	stm		sp!, {r0-r2}
	bl		print

;;------------------------------------------------------------
;;	[v
;;	
;;------------------------------------------------------------
:forever
	b		forever

;;------------------------------------------------------------
;;	A҂
;;	
;;------------------------------------------------------------
wait_vbk:
	mov		r0, #0x06
	add		r0, r0, #0x04000000
	ldr		r1, [r0]
	mov		r2, #160			; X^[160ȏ̎
	cmp		r1, r2
	bhi		wait_vbk
	
	mov		pc, r14
	movs	pc, r14				; return

;;------------------------------------------------------------
;;	̕\
;;	putchar(u32 x, u32 y, char c)
;;------------------------------------------------------------

putchar:
	ldm		sp!, {r0-r2}
	mov		r12, #0x06000000	; vram address
	sub		r9, r2, '!'-3

	cmp		r2, '!'-1			; `
	movls	pc, r14

	cmp		r2, '}'
	movhi	pc, r14

	mov		r7, r9
while_font_x:					; r7 % 7
	cmp		r7, #6
	bls		end_font_x
	sub		r7, r7, #7
	b		while_font_x
end_font_x:

	mov		r7, r7, lsl#3		; r7 *= 8;
	eor		r8, r8, r8
while_font_y:					; r9 / 7
	cmp		r9, #6
	bls		end_font_y
	add		r8, r8, #10
	sub		r9, r9, #7
	b		while_font_y
end_font_y:

	add		r5, r7, #8
	add		r6, r8, #10

	mov		r4, r8
for_rect_y:

	mov		r3, r7
for_rect_x:
	mov		r10, #56
	mul		r11, r4, r10
	add		r11, r11, r3
	mov		r10, font_data
	add		r11, r11, r10
	ldrb	r11, [r11]
	cmp		r11, #0
	bne		end_for_rect_x		; !font_data[r3+r4*56]?

	add		r11, r1, r4
	sub		r11, r11, r8
	mov		r10, #240
	mul		r11, r11, r10		; (r1 + r4 - r8) * 240
	add		r11, r11, r0
	add		r11, r11, r3
	sub		r11, r11, r7		; r11 + (r0 + r3 - r7)
	mov		r11, r11, lsl#1		; r11 *= 2(16rbg|C^)

	mov		r10, #0xFF
	add		r10, r10, #0xFF00	; color

	strh	r10, [r12, r11]		; [dest] = 0xFFFF

end_for_rect_x:
	add		r3, r3, #1
	cmp		r5, r3
	bhi		for_rect_x

	add		r4, r4, #1
	cmp		r6, r4
	bhi		for_rect_y

	mov		pc, r14
	movs	pc, r14				; return

;;------------------------------------------------------------
;;	̕\
;;	print(u32 x, u32 y, char *str)
;;------------------------------------------------------------

print:
	ldm		sp!, {r0-r2}
	mov		r12, #0x06000000	; vram address

while_str:
	ldrb	r3, [r2]
	cmp		r3, #0x00			; *r2!='\0'
	beq		end_str
	stm		sp!, {r0-r2}		; prinẗۑ
	stm		sp!, {r0-r1,r3}
	bl		putchar
	ldm		sp!, {r0-r2}
	add		r0, r0, #8
	add		r2, r2, #1			; str++
	b		while_str
end_str:

	mov		pc, r14
	movs	pc, r14				; return

;;-------------------------------------------------------------
;;	includes
;;
;;-------------------------------------------------------------

@pool

@include 	fontdata.inc

data_str:
@dcb	"Hello World!",0

null_str:
@dcb	0,0

