
;;------------------------------------------------------------
;;	mode3 image demo
;;
;;	note : r13=sp, r14=lr, r15=pc, r16=cpsr
;;------------------------------------------------------------

@arm
;@fsize	32
	b		agb_main

@dup	dcb 0xba, 0x00			; vOwb_[̈

agb_main:
	mov		r0, #0x4000000
	mov		r1, #0x400
	add		r1, r1, #0x1000		; XvCgL
	add		r1, r1, #0x40		; 1d}bsO
	add		r1, r1, #0x3
	str		r1, [r0]			; mode3ɐݒ

	bl		wait_vbk			; A҂

	mov		r0, image_data
	stm		sp!, {r0}
	bl		showimage			; C[W̕`

	mov		r0, sprite_data
	mov		r1, sprite_palette
	stm		sp!, {r0-r1}
	bl		setsprite			; XvCg̐ݒ

	mov		r0, #0x0			; CfbNX0
	mov		r1, #0x2000			; 256F
	add		r1, r1, #100		; yW
	mov		r2, #0x0
	add		r2, r2, #100		; xW
	mov		r3, #0x0
	stm		sp!, {r0-r3}
	bl		setoam				; XvCg̐ݒ

;;------------------------------------------------------------
;;	[v
;;	
;;------------------------------------------------------------
:forever
	b		forever

;;------------------------------------------------------------
;;	A҂
;;	
;;------------------------------------------------------------
wait_vbk:
	mov		r0, #0x06
	add		r0, r0, #0x04000000
	ldr		r1, [r0]
	mov		r2, #160			; X^[160ȏ̎
	cmp		r1, r2
	bhi		wait_vbk

	mov		pc, r14
	movs	pc, r14				; return

;;------------------------------------------------------------
;;	XvCg̐ݒ
;;	setoam(u32 index, u16 oam0, u16 oam1, u16 oam2)
;;------------------------------------------------------------
setoam:
	ldm		sp!, {r0-r3}
	mov		r12, #0x07000000
	mov		r4, #6
	mul		r0, r0, r4
	add		r12, r12, r0

	strh	r1, [r12]
	strh	r2, [r12, #2]
	strh	r3, [r12, #4]

	mov		pc, r14
	movs	pc, r14				; return

;;------------------------------------------------------------
;;	XvCg̐ݒ
;;	setsprite(u8 *data, u16 *palette)
;;------------------------------------------------------------
setsprite:
	ldm		sp!, {r11}			; XvCgpbg̓]
	mov		r12, #0x05000000
	add		r12, r12, #0x200

	mov		r10, #256			; pbg̃TCY
	eor		r0, r0, r0			; ]ItZbg

for_sprite_palette:
	ldrh	r8, [r11, r0]
	strh	r8, [r12, r0]

	add		r0, r0, #2
	cmp		r10, r0
	bhi		for_sprite_palette

	ldm		sp!, {r11}			; XvCgf[^̓]
	mov		r12, #0x06000000
	add		r12, r12, #0x14000

	mov		r10, #64			; XvCg̃TCY
	eor		r0, r0, r0			; ]ItZbg

for_sprite_data:
	add		r0, r0, #1
	ldrb	r8, [r11, r0]
	sub		r0, r0, #1
	strb	r8, [r12, r0]

	ldrb	r8, [r11, r0]
	add		r0, r0, #1
	strb	r8, [r12, r0]
	sub		r0, r0, #1

	add		r0, r0, #2
;	ldr		r8, [r11, r0]
;	str		r8, [r12, r0]

;	add		r0, r0, #4
	cmp		r10, r0
	bhi		for_sprite_data

	mov		pc, r14
	movs	pc, r14				; return

;;------------------------------------------------------------
;;	C[W̕\
;;	showimage(u16 *image)
;;------------------------------------------------------------
showimage:
	ldm		sp!, {r11}
	mov		r12, #0x06000000	; vram address

	mov		r9, #240			; lcd̉
	mov		r10, #160			; lcd̏c

	eor		r2, r2, r2			; ]Ƃ̃ItZbg

	eor		r1, r1, r1			; yW

for_image_y:
	eor		r0, r0, r0			; xW

for_image_x:
	mul		r3, r1, r9
	add		r3, r3, r0
	mov		r3, r3, lsl#1		; ]ItZbg
	ldrh	r8, [r11, r2]
	strh	r8, [r12, r3]
	add		r2, r2, #2

	add		r0, r0, #1
	cmp		r9, r0
	bhi		for_image_x

	add		r1, r1, #1
	cmp		r10, r1
	bhi		for_image_y

	mov		pc, r14
	movs	pc, r14				; return

;;-------------------------------------------------------------
;;	includes
;;
;;-------------------------------------------------------------
@pool

@include 	image.inc
@include 	sprite.inc

