// OamDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "OamDlg.h"

#include "../include/defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern u8	PalRam[0x400];
extern u8	VRam[0x18000];
extern u8	Oam[0x400];
extern BOOL fOamDlg;
extern DWORD dwSize;
LPBITMAPINFO oam_info;

u8	size_sprite[16][2]={
	8, 8,
	16, 16,
	32, 32,
	64, 64,
	16, 8,
	32, 8,
	32, 16,
	64, 32,
	8, 16,
	8, 32,
	16, 32,
	32, 64,
	0, 0,
	0, 0,
	0, 0,
	0, 0,
};


/////////////////////////////////////////////////////////////////////////////
// COamDlg _CAO


COamDlg::COamDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COamDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COamDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void COamDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COamDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COamDlg, CDialog)
	//{{AFX_MSG_MAP(COamDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTON_NEXT, OnButtonNext)
	ON_BN_CLICKED(IDC_BUTTON_RETURN, OnButtonReturn)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COamDlg bZ[W nh

void COamDlg::OnOK()
{

}

void COamDlg::OnCancel()
{
	OnClose();
}

void COamDlg::ShowOam()
{
	int i, index_offset;
	u16 OamBuffer[64*64];
	u16 palette[256];
	char str[50];

	sprintf(str, "%d", m_index);
	SetDlgItemText(IDC_EDIT_INDEX, str);

	size_sprite[0][0];

	memset(OamBuffer, 0, 64*64*2);
	
	for(i=0x200; i<0x200+256*2; i+=2){
		palette[(i-0x200)/2] = (u16)((PalRam[i]>>8)|PalRam[i+1]);
	}

	index_offset = 0x10000 + (m_index * 64 * 64);
	sprintf(str, "%08Xh", 0x06000000 + index_offset);
	SetDlgItemText(IDC_EDIT_ADDRESS, str);
	for(i=0; i<32*32; i++){
		OamBuffer[i] = palette[(VRam[i + index_offset])];
	}

	CDC* pODC = GetDlgItem(IDC_IMAGE_OAM)->GetDC();

	HDC	hMemDC	= ::CreateCompatibleDC(pODC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pODC->m_hDC, &oam_info->bmiHeader, CBM_INIT, OamBuffer, oam_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);
	::StretchBlt(pODC->m_hDC, 0, 0, 80, 80, hMemDC, 0, 0, 64, 64, SRCCOPY);
	::DeleteObject(hBitmap);
	
	ReleaseDC(pODC);
}

void COamDlg::OnClose() 
{
	fOamDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

BOOL COamDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_IMAGE_OAM), 0, 160, 15, 80, 80, SWP_NOACTIVATE|SWP_NOZORDER);

	m_index = 0;

	oam_info = (LPBITMAPINFO)new char[dwSize];

	memset(oam_info, 0, sizeof(BITMAPINFOHEADER));
	oam_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	oam_info->bmiHeader.biWidth		= 64;
	oam_info->bmiHeader.biHeight	= -64;
	oam_info->bmiHeader.biPlanes	= 1;
	oam_info->bmiHeader.biBitCount	= 16;

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void COamDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	ShowOam();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void COamDlg::OnButtonNext() 
{
	m_index++;
	ShowOam();
}

void COamDlg::OnButtonReturn() 
{
	if(m_index)m_index--;
	ShowOam();
}

BOOL COamDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN==pMsg->message){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return TRUE;
		case VK_LEFT:
			OnButtonReturn();
			break;
		case VK_RIGHT:
			OnButtonNext();
			break;
		default:
			break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void COamDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	delete[] oam_info;
}
