
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#include <stdio.h>
#include <string.h>
#include "../include/defines.h"


int ShowHeaderInfo(unsigned char* pRom, char* str)
{
	char temp[64];
	int	i;
	
	if(pRom==NULL){
		strcpy(str, "please load cartridge.");
		return 1;
	}

	for(i=0; i<12; i++){
		temp[i] = pRom[0xA0 + i];
		if(!pRom[0xA0 + i])break;
	}
	temp[i]='\0';	/*őPQ*/

	strcpy(str, "Title: ");
	strcat(str, temp);

	strcat(str, "\nRegion code: ");
	switch(pRom[0x4A]){
	case 'J':
		strcat(str, "Japanese");
		break;
	case 'E':
		strcat(str, "USA");
		break;
	case 'P':
		strcat(str, "Europe");
		break;
	default:
		strcat(str, "unknow");
		break;
	}

	sprintf(temp, "\nMaker code: %02Xh", pRom[0xB0]);
	strcat(str, temp);

	strcat(str, "\nis 96h: ");
	if(pRom[0xB2]==0x96){
		strcat(str, "ok");
	}else{
		strcat(str, "bat");
	}

	sprintf(temp, "\nUnit code: %02Xh", pRom[0xB3]);
	strcat(str, temp);

	sprintf(temp, "\nDevice type: %02Xh", pRom[0xB4]);
	strcat(str, temp);

	sprintf(temp, "\nVersion: %02Xh", pRom[0xBC]);
	strcat(str, temp);
/*
	strcat(str, "\nChecksum: ");
	sum = 25;
	for(i=0x134; i<=0x14D; i++)sum+=pRom[i];
	if(sum==0){
		sprintf(temp, "ok");
	}else{
		sprintf(temp, "error (%02Xh -> %02Xh)", pRom[0x14D], (unsigned int)(256-sum));
	}
	strcat(str, temp);
*/
	
	strcat(str, "\n");

	return 0;
}
