
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#define	IRQ_VBLANK	0x0001
#define	IRQ_HBLANK	0x0002
#define	IRQ_VCOUNT	0x0004
#define	IRQ_TIMER0	0x0008
#define	IRQ_TIMER1	0x0010
#define	IRQ_TIMER2	0x0020
#define	IRQ_TIMER3	0x0040
#define	IRQ_SERIAL	0x0080
#define	IRQ_DMA0	0x0100
#define	IRQ_DMA1	0x0200
#define	IRQ_DMA2	0x0400
#define	IRQ_DMA3	0x0800
#define	IRQ_KEYPAD	0x1000
#define	IRQ_GAMEPAK	0x2000

_inline u32 agb_interrupt(u32 irq)
{
	if(!(io_irq->ime & BIT_0_))return 1;
	if(!(io_irq->ie & irq))return 1;

#ifdef	WIN32_MAIN
	char str[128];
	sprintf(str, "Interrupt %Xh.", irq);
	console_print(str);
#endif	/*WIN32_MAIN*/

	agb_write_mem32(SP, PC);
	SP += 4;
	PC = agb_read_mem32(0x03007F00);

	return 0;
}

