
unsigned int iotype_offset_table[8] = {
0x000,
0x060,
0x0B0,
0x100,
0x120,
0x130,
0x134,
0x200,
};

char *ioname_table[8] = {
"LCD I/O Registers",
"Sound Registers",
"DMA Transfer Channels",
"Timer Registers",
"Serial Communication (1)",
"Keypad Input",
"Serial Communication (2)",
"Interrupt, Waitstate, and Power-Down Control",
};

char *lcd_ioname_table[43] = {
"LCD Control",
"Undocumented - Green Swap",
"General LCD Status",
"Vertical Counter",
"BG0 Control",
"BG1 Control",
"BG2 Control",
"BG3 Control",
"BG0 X-Offset",
"BG0 Y-Offset",
"BG1 X-Offset",
"BG1 Y-Offset",
"BG2 X-Offset",
"BG2 Y-Offset",
"BG3 X-Offset",
"BG3 Y-Offset",
"BG2 Rotation/Scaling Parameter A (dx)",
"BG2 Rotation/Scaling Parameter B (dmx)",
"BG2 Rotation/Scaling Parameter C (dy)",
"BG2 Rotation/Scaling Parameter D (dmy)",
"BG2 Reference Point X-Coordinate",
"-",
"BG2 Reference Point Y-Coordinate",
"-",
"BG3 Rotation/Scaling Parameter A (dx)",
"BG3 Rotation/Scaling Parameter B (dmx)",
"BG3 Rotation/Scaling Parameter C (dy)",
"BG3 Rotation/Scaling Parameter D (dmy)",
"BG3 Reference Point X-Coordinate",
"-",
"BG3 Reference Point Y-Coordinate",
"-",
"Window 0 Horizontal Dimensions",
"Window 1 Horizontal Dimensions",
"Window 0 Vertical Dimensions",
"Window 1 Vertical Dimensions",
"Control Inside of Window(s)",
"Control Outside of Windows & Inside of OBJ Window",
"Mosaic Size",
"Not used",
"Color Special Effects Selection",
"Alpha Blending Coefficients",
"Brightness (Fade-In/Out) Coefficient",
};

char *_lcd_ioname_table[43] = {
"DISPCNT",
"Not used",
"DISPSTAT",
"VCOUNT",
"BG0CNT",
"BG1CNT",
"BG2CNT",
"BG3CNT",
"BG0HOFS",
"BG0VOFS",
"BG1HOFS",
"BG1VOFS",
"BG2HOFS",
"BG2VOFS",
"BG3HOFS",
"BG3VOFS",
"BG2PA",
"BG2PB",
"BG2PC",
"BG2PD",
"BG2PX",
"-",
"BG2PY",
"-",
"BG3PA",
"BG3PB",
"BG3PC",
"BG3PD",
"BG3PX",
"-",
"BG3PY",
"-",
"WIN0H",
"WIN1H",
"WIN0V",
"WIN1V",
"WININ",
"WINOUT",
"MOSAIC",
"Not used",
"BLDCNT",
"BLDALPHA",
"BLDY",
};


char *sound_ioname_table[36] = {
"Channel 1 Sweep register",
"Channel 1 Duty/Length/Envelope",
"Channel 1 Frequency/Control",
"Not used",
"Channel 2 Duty/Length/Envelope",
"Not used",
"Channel 2 Frequency/Control",
"Not used",
"Channel 3 Stop/Wave RAM select",
"Channel 3 Length/Volume",
"Channel 3 Frequency/Control",
"Not used",
"Channel 4 Length/Envelope",
"Not used",
"Channel 4 Frequency/Control",
"Not used",
"Control Stereo/Volume/Enable",
"Control Mixing/DMA Control",
"Control Sound on/off",
"Not used",
"Sound PWM Control",
"Not used",
"Not used",
"Not used",
"Channel 3 Wave Pattern RAM",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Channel A FIFO, Data 0-3",
"-",
"Channel B FIFO, Data 0-3",
"-",
};

char *_sound_ioname_table[36] = {
"SOUND1CNT_L",
"SOUND1CNT_H",
"SOUND1CNT_X",
"Not used",
"SOUND2CNT_L",
"Not used",
"SOUND2CNT_H",
"Not used",
"SOUND3CNT_L",
"SOUND3CNT_H",
"SOUND3CNT_X",
"Not used",
"SOUND4CNT_L",
"Not used",
"SOUND4CNT_H",
"Not used",
"SOUNDCNT_L",
"SOUNDCNT_H",
"SOUNDCNT_X",
"Not used",
"SOUNDBIAS",
"Not used",
"Not used",
"Not used",
"WAVE_RAM",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"FIFO_A",
"-",
"FIFO_B",
"-",
};


char *dma_ioname_table[24] = {
"DMA 0 Source Address",
"-",
"DMA 0 Destination Address",
"-",
"DMA 0 Word Count",
"DMA 0 Control",
"DMA 1 Source Address",
"-",
"DMA 1 Destination Address",
"-",
"DMA 1 Word Count",
"DMA 1 Control",
"DMA 2 Source Address",
"-",
"DMA 2 Destination Address",
"-",
"DMA 2 Word Count",
"DMA 2 Control",
"DMA 3 Source Address",
"-",
"DMA 3 Destination Address",
"-",
"DMA 3 Word Count",
"DMA 3 Control",
};

char *_dma_ioname_table[24] = {
"DMA0SAD",
"-",
"DMA0DAD",
"-",
"DMA0CNT_L",
"DMA0CNT_H",
"DMA1SAD",
"-",
"DMA1DAD",
"-",
"DMA1CNT_L",
"DMA1CNT_H ",
"DMA2SAD",
"-",
"DMA2DAD",
"-",
"DMA2CNT_L",
"DMA2CNT_H",
"DMA3SAD",
"-",
"DMA3DAD",
"-",
"DMA3CNT_L",
"DMA3CNT_H",
};


char *timer_ioname_table[8] = {
"Timer 0 Counter/Reload",
"Timer 0 Control",
"Timer 1 Counter/Reload",
"Timer 1 Control",
"Timer 2 Counter/Reload",
"Timer 2 Control",
"Timer 3 Counter/Reload",
"Timer 3 Control",
};

char *_timer_ioname_table[8] = {
"TM0CNT_L",
"TM0CNT_H",
"TM1CNT_L",
"TM1CNT_H",
"TM2CNT_L",
"TM2CNT_H",
"TM3CNT_L",
"TM3CNT_H",
};


char *sio1_ioname_table[6] = {
"SIO Data 0 (Parent)",
"SIO Data 1 (1st Child)",
"SIO Data 2 (2nd Child)",
"SIO Data 3 (3rd Child)",
"SIO Control Register",
"SIO Data",
};

char *_sio1_ioname_table[6] = {
"SIODATA32",
"SIOMULTI1",
"SIOMULTI2",
"SIOMULTI3",
"SIOCNT",
"SIOMLT_SEND",
};


char *key_ioname_table[2] = {
"Key Status",
"Key Interrupt Control",
};

char *_key_ioname_table[2] = {
"KEYINPUT",
"KEYCNT",
};


char *sio2_ioname_table[19] = {
"SIO Mode Select/General Purpose Data",
"Ancient - Infrared Register",
"Not used",
"Not used",
"Not used",
"Not used",
"SIO JOY Bus Control",
"Not used",
"Not used",
"Not used",
"Not used",
"Not used",
"Not used",
"Not used",
"SIO JOY Bus Receive Data",
"-",
"SIO JOY Bus Transmit Data",
"-",
"SIO JOY Bus Receive Status",
};

char *_sio2_ioname_table[19] = {
"RCNT",
"IR",
"Not used",
"Not used",
"Not used",
"Not used",
"JOYCNT",
"Not used",
"Not used",
"Not used",
"Not used",
"Not used",
"Not used",
"Not used",
"JOY_RECV",
"-",
"JOY_TRANS",
"-",
"JOYSTAT",
};


char *irq_ioname_table[5] = {
"Interrupt Enable Register",
"Interrupt Request Flags / IRQ Acknowledge",
"Game Pak Waitstate Control",
"Not used",
"Interrupt Master Enable Register",
};

char *_irq_ioname_table[5] = {
"IE",
"IF",
"WAITCNT",
"Not used",
"IME",
};

char *lcd_dispcntflag_table[16] = {
"BG Mode",
"-",
"-",
"Reserved for BIOS",
"Display Frame Select",
"H-Blank Interval Free",
"OBJ Character VRAM Mapping",
"Forced Blank",
"Screen Display BG0",
"Screen Display BG1",
"Screen Display BG2",
"Screen Display BG3",
"Screen Display OBJ",
"Window 0 Display Flag",
"Window 1 Display Flag",
"OBJ Window Display Flag",
};

char *lcd_dispstatflag_table[16] = {
"V-Blank flag",
"H-Blank flag",
"V-Counter flag",
"V-Blank IRQ Enable",
"H-Blank IRQ Enable",
"V-Counter IRQ Enable",
"",
"",
"V-Count Setting",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_vcountflag_table[16] = {
"Current scanline",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
};

char *lcd_bgcntflag_table[16] = {
"BG Priority",
"-",
"Character Base Block",
"-",
"Not used (must be zero)",
"-",
"Mosaic",
"Colors/Palettes",
"Screen Base Block",
"-",
"-",
"-",
"-",
"Display Area Overflow",
"Screen Size (0-3)",
"-",
};

char *lcd_bgscrflag_table[16] = {
"Offset (0-511)",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
};

char *lcd_bgparamflag_table[16] = {
"Fractional portion",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Integer portion",
"-",
"-",
"-",
"-",
"-",
"Sign",
};

char *lcd_bgpointlflag_table[16] = {
"Fractional portion",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Integer portion",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_bgpointhflag_table[16] = {
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Sign",
"",
"",
"",
"",
};

char *lcd_winhflag_table[16] = {
"X2, Rightmost coordinate of window, plus 1",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"X1, Leftmost coordinate of window",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_winvflag_table[16] = {
"Y2, Bottom-most coordinate of window, plus 1",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
"Y1, Top-most coordinate of window",
"-",
"-",
"-",
"-",
"-",
"-",
"-",
};

char *lcd_wininflag_table[16] = {
"Window 0 BG0-BG3 Enable Bits",
"-",
"-",
"-",
"Window 0 OBJ Enable Bit",
"Window 0 Color Special Effect",
"",
"",
"Window 1 BG0-BG3 Enable Bits",
"-",
"-",
"-",
"Window 1 OBJ Enable Bit",
"Window 1 Color Special Effect",
"",
"",
};

char *lcd_winoutflag_table[16] = {
"Outside BG0-BG3 Enable Bits",
"-",
"-",
"-",
"Outside OBJ Enable Bit",
"Outside Color Special Effect",
"",
"",
"OBJ Window BG0-BG3 Enable Bits",
"-",
"-",
"-",
"OBJ Window OBJ Enable Bit",
"OBJ Window Color Special Effect",
"",
"",
};

char *lcd_mosaicflag_table[16] = {
"BG Mosaic H-Size  (minus 1)",
"-",
"-",
"-",
"BG Mosaic V-Size  (minus 1)",
"-",
"-",
"-",
"OBJ Mosaic H-Size (minus 1)",
"-",
"-",
"-",
"OBJ Mosaic V-Size (minus 1)",
"-",
"-",
"-",
};

char *lcd_bldcntflag_table[16] = {
"BG0 1st Target Pixel",
"BG1 1st Target Pixel",
"BG2 1st Target Pixel",
"BG3 1st Target Pixel",
"OBJ 1st Target Pixel",
"BD  1st Target Pixel",
"Color Special Effect",
"-",
"BG0 2nd Target Pixel",
"BG1 2nd Target Pixel",
"BG2 2nd Target Pixel",
"BG3 2nd Target Pixel",
"OBJ 2nd Target Pixel",
"BD  2nd Target Pixel",
"-",
"-",
};

char *lcd_bldalphaflag_table[16] = {
"EVA Coefficient (1st Target)",
"-",
"-",
"-",
"",
"",
"",
"",
"EVB Coefficient (2nd Target)",
"-",
"-",
"-",
"",
"",
"",
"",
};

char *lcd_bldyflag_table[16] = {
"EVY Coefficient (Brightness)",
"-",
"-",
"-",
"-",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};


char *lcd_notusedflag_table[16] = {
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
"",
};

char **lcd_flagname_table[43] = {
lcd_dispcntflag_table,
lcd_notusedflag_table,
lcd_dispstatflag_table,
lcd_vcountflag_table,

lcd_bgcntflag_table,
lcd_bgcntflag_table,
lcd_bgcntflag_table,
lcd_bgcntflag_table,

lcd_bgscrflag_table,
lcd_bgscrflag_table,
lcd_bgscrflag_table,
lcd_bgscrflag_table,
lcd_bgscrflag_table,
lcd_bgscrflag_table,
lcd_bgscrflag_table,
lcd_bgscrflag_table,

lcd_bgparamflag_table,
lcd_bgparamflag_table,
lcd_bgparamflag_table,
lcd_bgparamflag_table,

lcd_bgpointlflag_table,
lcd_bgpointhflag_table,
lcd_bgpointlflag_table,
lcd_bgpointhflag_table,

lcd_bgparamflag_table,
lcd_bgparamflag_table,
lcd_bgparamflag_table,
lcd_bgparamflag_table,

lcd_bgpointlflag_table,
lcd_bgpointhflag_table,
lcd_bgpointlflag_table,
lcd_bgpointhflag_table,

lcd_winhflag_table,
lcd_winhflag_table,

lcd_winvflag_table,
lcd_winvflag_table,

lcd_wininflag_table,
lcd_winoutflag_table,

lcd_mosaicflag_table,
lcd_notusedflag_table,
lcd_bldcntflag_table,
lcd_bldalphaflag_table,
lcd_bldyflag_table,
};
