
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

void CMainFrame::agb_mainloop()
{
	static u16	vcount;
	static u32 WaitTime = timeGetTime() + 17;

	fTMain = TRUE;

	do{

		vcount = io_lcd->vcount;

		if(CPSR & T_){
			exec_thumb_state();
		}else{
			exec_arm_state();
		}

		//agb_timer(arm.cycle);
		agb_dma_transfer();

#ifdef	WIN32_MAIN
		if(fBreak){	/*u[N|Cg*/
			if(BreakPoint1==PC || BreakPoint2==PC || BreakPoint3==PC || BreakPoint4==PC){
				CPUIsRunning = FALSE;
				SetWindowText(_TITLE_" - Break!!!!!!!!!!!!!");
				char str[128];
				sprintf(str, "Stop at break point \"%Xh\".", PC);
				console_print(str);
			}
		}
#endif	/*WIN32_MAIN*/

		htime -= arm.cycle;
		if(htime <= 272){	/*A*/
			if(!(io_lcd->dispstat & BIT_1_)){
				io_lcd->dispstat |= BIT_1_;
				if(io_lcd->dispstat & BIT_4_)agb_interrupt(IRQ_HBLANK);
			}
			if(htime <= 0){	/* (16.78MHz/59.73)/228line */
				htime += 1232;
				//if(vcount < 160)agb_draw_line();
				if(vcount >= 228){	/* 16.78MHz/59.73  */
					vcount = 0;
					m_wndView.agb_draw_lcd();
					FrameCount++;
#ifdef	WIN32_MAIN
					if(fFps)ShowFps();
					if(fAutoUpdate)UpdateDebugger();
#endif	/*WIN32_MAIN*/
					while(WaitTime > timeGetTime() && fVsync)Sleep(1);
					WaitTime = timeGetTime() + 17;
				}else{
					vcount++;
					if((io_lcd->dispstat>>8)==vcount){	/*LYC*/
						if(!(io_lcd->dispstat & BIT_2_)){
							io_lcd->dispstat |= BIT_2_;
							if(io_lcd->dispstat & BIT_5_)agb_interrupt(IRQ_VCOUNT);
						}
					}else{
						if(io_lcd->dispstat & BIT_2_)io_lcd->dispstat &= ~BIT_2_;		
					}
				}
				if(vcount >= 160){	/*A (228-160=68lines)*/
					if(!(io_lcd->dispstat & BIT_0_)){
						io_lcd->dispstat |= BIT_0_;	/*AJn*/
						if(io_lcd->dispstat & BIT_3_)agb_interrupt(IRQ_VBLANK);
					}
				}else{
					if(io_lcd->dispstat & BIT_0_)io_lcd->dispstat &= ~BIT_0_;		
				}
			}
		}else{
			if(io_lcd->dispstat & BIT_1_)io_lcd->dispstat &= ~BIT_1_;
		}

		io_lcd->vcount = vcount;

	}while(CPUIsRunning);

	fTMain = FALSE;

	if(fAutoUpdate)UpdateDebugger();
	m_wndView.agb_draw_lcd();
}

void agb_initialize_register()
{
	console_print("Initializing registers.");

	R0	=	0x00000000;
	R1	=	0x00000000;
	R2	=	0x00000000;
	R3	=	0x00000000;
	R4	=	0x00000000;
	R5	=	0x00000000;
	R6	=	0x00000000;
	R7	=	0x00000000;
	R8	=	0x00000000;
	R9	=	0x00000000;
	R10	=	0x00000000;
	R11	=	0x00000000;
	R12	=	0x00000000;
	SP	=	0x03007F00;	/*R13==SR X^bN|C^*/
	R14	=	0x00000000;	/*R14==LR NWX^*/
	PC	=	fEnableBios?0x00000000:0x08000000;	/*R15==PC vO|C^*/
	CPSR=	0x0000001F;	/*R16==CPSR Xe[^XWX^*/
}
