
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


#ifdef	__cplusplus
//extern "C" {
#endif	/*__cplusplus*/

u8	agb_read_mem8(u32 adr);
u16	agb_read_mem16(u32 adr);
u32	agb_read_mem32(u32 adr);

#ifdef	__cplusplus
//}
#endif	/*__cplusplus*/


void agb_initialize_memory()
{
	console_print("Initializing memory.");

	memset(VRam, 0, SIZE_VRAM);
	memset(InWRam, 0, SIZE_INWRAM);

	io_lcd = (AGBIOLCD*)&IoRam[0x000];
	io_dma = (AGBIODMA*)&IoRam[0x0B0];
	io_tm  = (AGBIOTM*)&IoRam[0x100];
	io_key = (AGBIOKEY*)&IoRam[0x130];
	io_irq = (AGBIOIRQ*)&IoRam[0x200];

	IoRam[R_P1]		=	0xFF;
	IoRam[R_P1+1]	=	0xFF;
}

u8 agb_read_mem8(u32 adr)
{
	if(/*0x00000000 <= adr && */adr < 0x00004000)return SysRom[adr];
	if(0x02000000 <= adr && adr < 0x02040000)return ExWRam[adr - 0x02000000];
	if(0x03000000 <= adr && adr < 0x03008000)return InWRam[adr - 0x03000000];
	if(0x04000000 <= adr && adr < 0x04000400)return IoRam[adr - 0x04000000];
	if(0x05000000 <= adr && adr < 0x05000400)return PalRam[adr - 0x05000000];
	if(0x06000000 <= adr && adr < 0x06018000)return VRam[adr - 0x06000000];
	if(0x07000000 <= adr && adr < 0x07000400)return Oam[adr - 0x07000000];
	if(0x08000000 <= adr && adr < (0x08000000 + filesize))return Rom[adr - 0x08000000];

	return 0;
}

u16 agb_read_mem16(u32 adr)
{
	u16	*word_ptr;

	if(/*0x00000000 <= adr && */adr < 0x00004000)
	{
		word_ptr = (u16*)&SysRom[adr];
		return *word_ptr;
	}
	if(0x02000000 <= adr && adr < 0x02040000)
	{
		adr -= 0x02000000;
		word_ptr = (u16*)&ExWRam[adr];
		return *word_ptr;
	}
	if(0x03000000 <= adr && adr < 0x03008000)
	{
		adr -= 0x03000000;
		word_ptr = (u16*)&InWRam[adr];
		return *word_ptr;
	}
	if(0x04000000 <= adr && adr < 0x04000400)
	{
		adr -= 0x04000000;
		word_ptr = (u16*)&IoRam[adr];
		return *word_ptr;
	}
	if(0x05000000 <= adr && adr < 0x05000400)
	{
		adr -= 0x05000000;
		word_ptr = (u16*)&PalRam[adr];
		return *word_ptr;
	}
	if(0x06000000 <= adr && adr < 0x06018000)
	{
		adr -= 0x06000000;
		word_ptr = (u16*)&VRam[adr];
		return *word_ptr;
	}
	if(0x07000000 <= adr && adr < 0x07000400)
	{
		adr -= 0x07000000;
		word_ptr = (u16*)&Oam[adr];
		return *word_ptr;
	}
	if(0x08000000 <= adr && adr < (0x08000000 + filesize)){
		adr -= 0x08000000;
		word_ptr = (u16*)&Rom[adr];
		return *word_ptr;
	}

	return 0;
}

u32 agb_read_mem32(u32 adr)
{
	u32	*dword_ptr;

	if(/*0x00000000 <= adr && */adr < 0x00004000){
		dword_ptr = (u32*)&SysRom[adr];
		return *dword_ptr;
	}
	if(0x02000000 <= adr && adr < 0x02040000){
		adr -= 0x02000000;
		dword_ptr = (u32*)&ExWRam[adr];
		return *dword_ptr;
	}
	if(0x03000000 <= adr && adr < 0x03008000){
		adr -= 0x03000000;
		dword_ptr = (u32*)&InWRam[adr];
		return *dword_ptr;
	}
	if(0x04000000 <= adr && adr < 0x04000400){
		adr -= 0x04000000;
		dword_ptr = (u32*)&IoRam[adr];
		return *dword_ptr;
	}
	if(0x05000000 <= adr && adr < 0x05000400){
		adr -= 0x05000000;
		dword_ptr = (u32*)&PalRam[adr];
		return *dword_ptr;
	}
	if(0x06000000 <= adr && adr < 0x06018000){
		adr -= 0x06000000;
		dword_ptr = (u32*)&VRam[adr];
		return *dword_ptr;
	}
	if(0x07000000 <= adr && adr < 0x07000400){
		adr -= 0x07000000;
		dword_ptr = (u32*)&Oam[adr];
		return *dword_ptr;
	}
	if(0x08000000 <= adr && adr < (0x08000000 + filesize)){
		adr -= 0x08000000;
		dword_ptr = (u32*)&Rom[adr];
		return *dword_ptr;
	}

	return 0;
}

inline int agb_write_mem8(u32 adr, u8 val)
{
	char str[256];

	if(0x02000000 <= adr && adr < 0x02040000){
		ExWRam[adr - 0x02000000]	= val;
		return 0;
	}
	if(0x03000000 <= adr && adr < 0x03008000){
		InWRam[adr - 0x03000000]	= val;
		return 0;
	}
	if(0x04000000 <= adr && adr < 0x04000400){
		IoRam[adr - 0x04000000]		= val;
		/*DMA0,1,2,3̓]JntO*/
#ifdef	WIN32_MAIN
		if(adr==(REG_DM0CNT_H + 1)){
			if(val & BIT_7_){
				sprintf(str, "DMA0 sad=%08Xh, dad=%08Xh, count=%Xh(*%dbit)", 
						io_dma->dma0sad & 0x0FFFFFFF, 
						io_dma->dma0dad & 0x07FFFFFF, 
						io_dma->dma0cnt_l, 
						(io_dma->dma0cnt_h & BIT_10_)?32:16);
				console_print(str);
			}
		}
		if(adr==(REG_DM1CNT_H + 1)){
			if(val & BIT_7_){
				sprintf(str, "DMA1 sad=%08Xh, dad=%08Xh, count=%Xh(*%dbit)", 
						io_dma->dma1sad & 0x0FFFFFFF, 
						io_dma->dma1dad & 0x07FFFFFF, 
						io_dma->dma1cnt_l, 
						(io_dma->dma1cnt_h & BIT_10_)?32:16);
				console_print(str);
			}
		}
		if(adr==(REG_DM2CNT_H + 1)){
			if(val & BIT_7_){
				sprintf(str, "DMA2 sad=%08Xh, dad=%08Xh, count=%Xh(*%dbit)", 
						io_dma->dma2sad & 0x0FFFFFFF, 
						io_dma->dma2dad & 0x07FFFFFF, 
						io_dma->dma2cnt_l, 
						(io_dma->dma2cnt_h & BIT_10_)?32:16);
				console_print(str);
			}
		}
		if(adr==(REG_DM3CNT_H + 1)){
			if(val & BIT_7_){
				sprintf(str, "DMA3 sad=%08Xh, dad=%08Xh, count=%Xh(*%dbit)", 
						io_dma->dma3sad & 0x0FFFFFFF, 
						io_dma->dma3dad & 0x07FFFFFF, 
						io_dma->dma3cnt_l, 
						(io_dma->dma3cnt_h & BIT_10_)?32:16);
				console_print(str);
			}
		}
#endif	/*WIN32_MAIN*/
		return 0;
	}
	if(0x05000000 <= adr && adr < 0x05000400){
		PalRam[adr - 0x05000000]	= val;
		return 0;
	}
	if(0x06000000 <= adr && adr < 0x06018000){
		VRam[adr - 0x06000000]		= val;
		return 0;
	}
	if(0x07000000 <= adr && adr < 0x07000400){
		Oam[adr - 0x07000000]		= val;
		return 0;
	}

	return 1;
}

void agb_write_mem16(u32 adr, u16 val)
{
	agb_write_mem8(adr++, (u8)val);
	agb_write_mem8(adr, (u8)(val>>8));
}

_inline void agb_write_mem32(u32 adr, u32 val)
{
#ifdef	WIN32_MAIN
	u32	i;
	char str[256];

	/*Mappy`dprint*/
	if(adr==0xC0DED00D){
		if(!(agb_read_mem32(arm.reg[15] + 4) & 0x0FFFFFFF)){	/*nop*/
			memset(str, 0, 256);
			for(i=0; agb_read_mem8(val); i++)str[i] = agb_read_mem8(val++);
			console_print(str);
		}
	}
#endif	/*WIN32_MAIN*/

	agb_write_mem8(adr++, (u8)val);
	agb_write_mem8(adr++, (u8)(val>>8));
	agb_write_mem8(adr++, (u8)(val>>16));
	agb_write_mem8(adr, (u8)(val>>24));
}
