
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


#include <stdio.h>

#include "../zlib/unzip.h"


int CheckExtensionName(char* filename, char* extension)
{	/*t@CƊgqvOȊOԂ*/
	unsigned int flen, xlen;

	flen = strlen(filename);	/*t@C̕*/
	xlen = strlen(extension);	/*gq̕*/

	if(extension[xlen]=='*')return 0;/*SẴt@C*/

	while(xlen!=0){
		if(isupper(filename[flen]))filename[flen]+=0x20;
		if(isupper(extension[xlen]))extension[xlen]+=0x20;
		if(filename[flen]!=extension[xlen])return 0;
		flen--;
		xlen--;
	}

	return 1;
}

int IsAgbFilename(char* filename)
{	/*gqAGBt@CȂOȊOԂ*/

	if(CheckExtensionName(filename, ".agb")){
		return 1;
	}
	if(CheckExtensionName(filename, ".gba")){
		return 1;
	}
	if(CheckExtensionName(filename, ".bin")){
		return 1;
	}

	return 0;
}

unsigned int GetFileSize(char *filename)
{
	unsigned int f_start, f_end, filesize;
	FILE *fp;

	fp = fopen(filename, "rb");
	if(fp==NULL)return 0;

	fseek(fp, 0, SEEK_END);
	f_end = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	f_start = ftell(fp);
	filesize = f_end - f_start;

	fclose(fp);

	return filesize;
}

int agb_close_rom(unsigned char *pMem)
{
	if(Rom!=NULL){
		free(Rom);
		return 0;
	}

	return 1;
}

int agb_open_bios(char *filename)
{
	FILE *fp;

	fp = fopen(filename, "rb");
	if(!fp)return 0;
	fread(SysRom, 1, 1024 * 16, fp);
	fclose(fp);

	return 1;
}

int agb_open_rom(char *filename, unsigned char *pMem, unsigned int *size)
{
	unsigned int f_start, f_end;
	FILE *fp;

	console_print("Loading cartridge.");
	console_print(filename);

	fp = fopen(filename, "rb");
	if(fp==NULL)return 1;

	fseek(fp, 0, SEEK_END);
	f_end = ftell(fp);
	fseek(fp, 0, SEEK_SET);
	f_start = ftell(fp);
	*size = f_end - f_start;

	agb_close_rom(pMem);

	Rom = (unsigned char*)malloc(*size + 1);
	if(Rom==NULL)return 2;
	
	fread(Rom, 1, *size, fp);

	fclose(fp);

	return 0;
}


#ifdef	WIN32

int agb_open_ziprom(char* filename, unsigned char *pMem, unsigned int *size)
{	/*ZIPt@CROM̓ǂݍ݂ƃ̊m*/	
	unsigned int	sizeRead;
	int		err;
	char	strConFilename[512];
	char*	pConFileName, *p;
	unzFile	hUnzipFile;
	unz_file_info	fileInfo;

	console_print("Loading cartridge.");
	console_print(filename);

	hUnzipFile = NULL;

	hUnzipFile = unzOpen(filename, 0);
	if(hUnzipFile == NULL)return FALSE;

	do{
		err = unzGetCurrentFileInfo(hUnzipFile, &fileInfo, strConFilename, 
									sizeof(strConFilename), NULL, 0, NULL, 0);
		if(err!=UNZ_OK){
			unzClose(hUnzipFile);
			return 1;	/*ZIPt@C*/
		}

		p = pConFileName = strConFilename;	/*t@Co*/
		while(*p!='\0'){
			if (*p=='\\' ||*p=='/')pConFileName=p+1;
			p++;
		}

		if(IsAgbFilename(strConFilename)){	/*GBt@Cgq̔*/
			if(unzOpenCurrentFile(hUnzipFile)!=UNZ_OK){
				unzClose(hUnzipFile);
				return 2;	/*w肳ꂽt@CĂ*/
			}
			agb_close_rom(pMem);
			Rom = (u8*)malloc(fileInfo.uncompressed_size + 1);
			if(Rom==NULL)return 2;
			sizeRead = unzReadCurrentFile(hUnzipFile, (void*)Rom, fileInfo.uncompressed_size);
			if(sizeRead!=fileInfo.uncompressed_size)return 4;
			*size = fileInfo.uncompressed_size;
		}

		unzCloseCurrentFile(hUnzipFile);

		if(IsAgbFilename(strConFilename))break;/*ROMt@Cǂ񂾂I*/

	}while(unzGoToNextFile(hUnzipFile) != UNZ_END_OF_LIST_OF_FILE);

	unzClose(hUnzipFile);

	return 0;
}

#endif	/*_WIN32_*/

